/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SqlInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeObject;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;

public class GranteeManager {
    static User systemAuthorisation;
    private HashMappedList map = new HashMappedList();
    private HashMappedList roleMap = new HashMappedList();
    Database database;
    GranteeObject publicRole;
    GranteeObject dbaRole;
    GranteeObject schemaRole;
    GranteeObject changeAuthRole;
    static final IntValueHashMap rightsStringLookup;

    public GranteeManager(Database database) {
        this.database = database;
        this.addRole(this.database.nameManager.newHsqlName("PUBLIC", false, 11));
        this.publicRole = this.getRole("PUBLIC");
        this.publicRole.isPublic = true;
        this.addRole(this.database.nameManager.newHsqlName("DBA", false, 11));
        this.dbaRole = this.getRole("DBA");
        this.dbaRole.setAdminDirect();
        this.addRole(this.database.nameManager.newHsqlName("CREATE_SCHEMA", false, 11));
        this.schemaRole = this.getRole("CREATE_SCHEMA");
        this.addRole(this.database.nameManager.newHsqlName("CHANGE_AUTHORIZATION", false, 11));
        this.changeAuthRole = this.getRole("CHANGE_AUTHORIZATION");
    }

    public GranteeObject getDBARole() {
        return this.dbaRole;
    }

    public static GranteeObject getSystemRole() {
        return systemAuthorisation;
    }

    public void grant(OrderedHashSet orderedHashSet, SchemaObject schemaObject, Right right, Grantee grantee, boolean bl) {
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.grant(orderedHashSet, schemaObjectArray, right, grantee, bl);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!((GranteeObject)grantee).isGrantable(schemaObject, right)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        this.checkGranteeList(orderedHashSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            GranteeObject granteeObject = this.get((String)orderedHashSet.get(i));
            granteeObject.grant(hsqlName, right, grantee, bl);
            if (!granteeObject.isRole) continue;
            this.updateAllRights(granteeObject);
        }
    }

    public void grant(OrderedHashSet orderedHashSet, SchemaObject[] schemaObjectArray, Right right, Grantee grantee, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            if (!((GranteeObject)grantee).isGrantable(schemaObjectArray[i], right)) continue;
            this.grant(orderedHashSet, schemaObjectArray[i], right, grantee, bl);
            bl2 = true;
        }
        if (!bl2) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void checkGranteeList(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string = (String)orderedHashSet.get(i);
            GranteeObject granteeObject = this.get(string);
            if (granteeObject == null) {
                throw Error.error(4001, string);
            }
            if (!GranteeManager.isImmutable(string)) continue;
            throw Error.error(4002, string);
        }
    }

    public void grant(String string, String string2, Grantee grantee) {
        GranteeObject granteeObject = this.get(string);
        if (granteeObject == null) {
            throw Error.error(4001, string);
        }
        if (GranteeManager.isImmutable(string)) {
            throw Error.error(4002, string);
        }
        GranteeObject granteeObject2 = this.getRole(string2);
        if (granteeObject2 == null) {
            throw Error.error(2200, string2);
        }
        if (granteeObject2 == granteeObject) {
            throw Error.error(2251, string);
        }
        if (granteeObject2.hasRole(granteeObject)) {
            throw Error.error(2251, string2);
        }
        if (!((GranteeObject)grantee).isGrantable(granteeObject2)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        granteeObject.grant(granteeObject2);
        granteeObject.updateAllRights();
        if (granteeObject.isRole) {
            this.updateAllRights(granteeObject);
        }
    }

    public void checkRoleList(String string, OrderedHashSet orderedHashSet, Grantee grantee, boolean bl) {
        GranteeObject granteeObject = this.get(string);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string2 = (String)orderedHashSet.get(i);
            GranteeObject granteeObject2 = this.getRole(string2);
            if (granteeObject2 == null) {
                throw Error.error(2200, string2);
            }
            if (string2.equals("_SYSTEM") || string2.equals("PUBLIC")) {
                throw Error.error(4002, string2);
            }
            if (bl) {
                if (granteeObject.getDirectRoles().contains(granteeObject2)) {
                    throw Error.error(2200, string);
                }
            } else if (!granteeObject.getDirectRoles().contains(granteeObject2)) {
                throw Error.error(2200, string2);
            }
            if (grantee.isAdmin()) continue;
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void grantSystemToPublic(SchemaObject schemaObject, Right right) {
        this.publicRole.grant(schemaObject.getName(), right, systemAuthorisation, true);
    }

    public void revoke(String string, String string2, Grantee grantee) {
        if (!grantee.isAdmin()) {
            throw Error.error(5507);
        }
        GranteeObject granteeObject = this.get(string);
        if (granteeObject == null) {
            throw Error.error(4000, string);
        }
        GranteeObject granteeObject2 = (GranteeObject)this.roleMap.get(string2);
        granteeObject.revoke(granteeObject2);
        granteeObject.updateAllRights();
        if (granteeObject.isRole) {
            this.updateAllRights(granteeObject);
        }
    }

    public void revoke(OrderedHashSet orderedHashSet, SchemaObject schemaObject, Right right, Grantee grantee, boolean bl, boolean bl2) {
        GranteeObject granteeObject;
        String string;
        int n;
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.revoke(orderedHashSet, schemaObjectArray, right, grantee, bl, bl2);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!grantee.isFullyAccessibleByRole(hsqlName)) {
            throw Error.error(5501, schemaObject.getName().name);
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            string = (String)orderedHashSet.get(n);
            granteeObject = this.get(string);
            if (granteeObject == null) {
                throw Error.error(4001, string);
            }
            if (!GranteeManager.isImmutable(string)) continue;
            throw Error.error(4002, string);
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            string = (String)orderedHashSet.get(n);
            granteeObject = this.get(string);
            granteeObject.revoke(schemaObject, right, grantee, bl);
            granteeObject.updateAllRights();
            if (!granteeObject.isRole) continue;
            this.updateAllRights(granteeObject);
        }
    }

    public void revoke(OrderedHashSet orderedHashSet, SchemaObject[] schemaObjectArray, Right right, Grantee grantee, boolean bl, boolean bl2) {
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            this.revoke(orderedHashSet, schemaObjectArray[i], right, grantee, bl, bl2);
        }
    }

    void removeEmptyRole(GranteeObject granteeObject) {
        for (int i = 0; i < this.map.size(); ++i) {
            GranteeObject granteeObject2 = (GranteeObject)this.map.get(i);
            granteeObject2.roles.remove(granteeObject);
        }
    }

    public void removeDbObject(HsqlNameManager.HsqlName hsqlName) {
        for (int i = 0; i < this.map.size(); ++i) {
            GranteeObject granteeObject = (GranteeObject)this.map.get(i);
            granteeObject.revokeDbObject(hsqlName);
        }
    }

    public void removeDbObjects(OrderedHashSet orderedHashSet) {
        Iterator iterator = orderedHashSet.iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            for (int i = 0; i < this.map.size(); ++i) {
                GranteeObject granteeObject = (GranteeObject)this.map.get(i);
                granteeObject.revokeDbObject(hsqlName);
            }
        }
    }

    void updateAllRights(GranteeObject granteeObject) {
        GranteeObject granteeObject2;
        int n;
        for (n = 0; n < this.map.size(); ++n) {
            granteeObject2 = (GranteeObject)this.map.get(n);
            if (!granteeObject2.isRole) continue;
            granteeObject2.updateNestedRoles(granteeObject);
        }
        for (n = 0; n < this.map.size(); ++n) {
            granteeObject2 = (GranteeObject)this.map.get(n);
            if (granteeObject2.isRole) continue;
            granteeObject2.updateAllRights();
        }
    }

    public boolean removeGrantee(String string) {
        if (GranteeManager.isReserved(string)) {
            return false;
        }
        GranteeObject granteeObject = (GranteeObject)this.map.remove(string);
        if (granteeObject == null) {
            return false;
        }
        granteeObject.clearPrivileges();
        this.updateAllRights(granteeObject);
        if (granteeObject.isRole) {
            this.roleMap.remove(string);
            this.removeEmptyRole(granteeObject);
        }
        return true;
    }

    public GranteeObject addRole(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        GranteeObject granteeObject = new GranteeObject(hsqlName, this);
        granteeObject.isRole = true;
        this.map.put(hsqlName.name, granteeObject);
        this.roleMap.add(hsqlName.name, granteeObject);
        return granteeObject;
    }

    public User addUser(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        User user = new User(hsqlName, this);
        this.map.put(hsqlName.name, user);
        return user;
    }

    boolean isGrantee(String string) {
        return this.map.containsKey(string);
    }

    public static int getCheckSingleRight(String string) {
        int n = GranteeManager.getRight(string);
        if (n != 0) {
            return n;
        }
        throw Error.error(5581, string);
    }

    public static int getRight(String string) {
        return rightsStringLookup.get((Object)string, 0);
    }

    public GranteeObject get(String string) {
        return (GranteeObject)this.map.get(string);
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String string) {
        return GranteeManager.getRight(string) != 0;
    }

    public static boolean isImmutable(String string) {
        return string.equals("_SYSTEM") || string.equals("DBA") || string.equals("CREATE_SCHEMA") || string.equals("CHANGE_AUTHORIZATION");
    }

    public static boolean isReserved(String string) {
        return string.equals("_SYSTEM") || string.equals("DBA") || string.equals("CREATE_SCHEMA") || string.equals("CHANGE_AUTHORIZATION") || string.equals("PUBLIC");
    }

    public void dropRole(String string) {
        if (!this.isRole(string)) {
            throw Error.error(2200, string);
        }
        if (GranteeManager.isReserved(string)) {
            throw Error.error(5507);
        }
        this.removeGrantee(string);
    }

    public Set getRoleNames() {
        return this.roleMap.keySet();
    }

    public Collection getRoles() {
        return this.roleMap.values();
    }

    public GranteeObject getRole(String string) {
        GranteeObject granteeObject = (GranteeObject)this.roleMap.get(string);
        if (granteeObject == null) {
            throw Error.error(2200, string);
        }
        return granteeObject;
    }

    public boolean isRole(String string) {
        return this.roleMap.containsKey(string);
    }

    public String[] getSQL() {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.getRoles().iterator();
        while (iterator.hasNext()) {
            object = (String[])iterator.next();
            if (GranteeManager.isReserved(object.getName().getNameString())) continue;
            hsqlArrayList.add(object.getSQL());
        }
        iterator = this.getGrantees().iterator();
        while (iterator.hasNext()) {
            object = (Grantee)iterator.next();
            if (!(object instanceof User)) continue;
            hsqlArrayList.add(object.getSQL());
        }
        object = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(object);
        return object;
    }

    public String[] getRightstSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.getGrantees().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = stringArray.getName().getNameString();
            if (GranteeManager.isImmutable(string)) continue;
            HsqlArrayList hsqlArrayList2 = stringArray.getRightsSQL();
            hsqlArrayList.addAll(hsqlArrayList2);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newSystemObjectName("_SYSTEM", 11);
        systemAuthorisation = new User(hsqlName, null);
        GranteeManager.systemAuthorisation.isSystem = true;
        systemAuthorisation.setAdminDirect();
        systemAuthorisation.setInitialSchema(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SYSTEM_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.LOBS_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SQLJ_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        rightsStringLookup = new IntValueHashMap(7);
        rightsStringLookup.put("ALL", 63);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
        rightsStringLookup.put("EXECUTE", 32);
        rightsStringLookup.put("USAGE", 16);
        rightsStringLookup.put("REFERENCES", 64);
        rightsStringLookup.put("TRIGGER", 128);
    }
}

