/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    Database database;
    DataInputStream file;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int n) {
        this.lobBlockSize = n;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    public byte[] getBlockBytes(int n, int n2) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long l = (long)n * (long)this.lobBlockSize;
            int n3 = n2 * this.lobBlockSize;
            byte[] byArray = new byte[n3];
            this.fileSeek(l);
            this.file.readFully(byArray, 0, n3);
            this.realPosition = l + (long)n3;
            return byArray;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    public void setBlockBytes(byte[] byArray, int n, int n2) {
    }

    public int getBlockSize() {
        return this.lobBlockSize;
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    private void resetStream() throws IOException {
        InputStream inputStream;
        if (this.file != null) {
            this.file.close();
        }
        try {
            inputStream = this.getClass().getResourceAsStream(this.fileName);
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            throw Error.error(465, throwable);
        }
        this.file = new DataInputStream(inputStream);
        this.realPosition = 0L;
    }

    private void fileSeek(long l) throws IOException {
        long l2;
        if (this.file == null) {
            this.resetStream();
        }
        if (l < (l2 = this.realPosition)) {
            this.resetStream();
            l2 = 0L;
        }
        while (l > l2) {
            l2 += this.file.skip(l - l2);
        }
        this.realPosition = l;
    }
}

