/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.hsqldb.jdbc.Util;

public abstract class BaseConnectionWrapper
implements Connection {
    protected boolean isClosed = false;

    protected abstract Connection getConnection();

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public int getHoldability() throws SQLException {
        this.validate();
        return this.getConnection().getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        this.validate();
        return this.getConnection().getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.validate();
        this.getConnection().clearWarnings();
    }

    public void commit() throws SQLException {
        this.validate();
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.validate();
        this.getConnection().rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    public boolean isReadOnly() throws SQLException {
        this.validate();
        return this.getConnection().isReadOnly();
    }

    public void setHoldability(int n) throws SQLException {
        this.validate();
        this.getConnection().setHoldability(n);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.validate();
        this.getConnection().setTransactionIsolation(n);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.validate();
        this.getConnection().setAutoCommit(bl);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.validate();
        this.getConnection().setReadOnly(bl);
    }

    public String getCatalog() throws SQLException {
        this.validate();
        return this.getConnection().getCatalog();
    }

    public void setCatalog(String string) throws SQLException {
        this.validate();
        this.getConnection().setCatalog(string);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validate();
        return this.getConnection().getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return this.getConnection().getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().rollback(savepoint);
    }

    public Statement createStatement() throws SQLException {
        this.validate();
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(n, n2, n3);
    }

    public Map getTypeMap() throws SQLException {
        this.validate();
        return this.getConnection().getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validate();
        this.getConnection().setTypeMap(map);
    }

    public String nativeSQL(String string) throws SQLException {
        this.validate();
        return this.getConnection().nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, nArray);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint(string);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, stringArray);
    }
}

