/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCBlob
implements Blob {
    public static final long MIN_POS = 1L;
    public static final long MAX_POS = 0x80000000L;
    private volatile byte[] data;
    private final boolean createdByConnection;
    private boolean getBinaryStreamUsesCopy;

    public long length() throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        return byArray.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        int n2 = byArray.length;
        if (l < 1L || l > 1L + (long)n2) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        if (n < 0 || (long)n > (long)n2 - --l) {
            throw Util.outOfRangeArgument("length: " + n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, (int)l, byArray2, 0, n);
        return byArray2;
    }

    public InputStream getBinaryStream() throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        return new ByteArrayInputStream(byArray);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        byte[] byArray2 = this.data;
        this.checkValid(byArray2);
        int n = byArray2.length;
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (l > (long)n || byArray == null) {
            return -1L;
        }
        int n2 = byArray.length;
        if (n2 == 0 || --l > (long)(n - n2)) {
            return -1L;
        }
        int n3 = n - n2;
        byte by = byArray[0];
        block0: for (int i = (int)l; i <= n3; ++i) {
            if (byArray2[i] != by) continue;
            int n4 = n2;
            int n5 = i;
            int n6 = 0;
            boolean bl = true;
            while (n4-- > 0) {
                if (byArray2[n5++] == byArray[n6++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        int n = byArray.length;
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (l > (long)n || blob == null) {
            return -1L;
        }
        long l2 = blob.length();
        if (l2 == 0L || --l > (long)n - l2) {
            return -1L;
        }
        int n2 = (int)l2;
        byte[] byArray2 = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, n2);
        int n3 = n - n2;
        byte by = byArray2[0];
        block0: for (int i = (int)l; i <= n3; ++i) {
            if (byArray[i] != by) continue;
            int n4 = n2;
            int n5 = i;
            int n6 = 0;
            while (n4-- > 0) {
                if (byArray[n5++] == byArray2[n6++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw Util.nullArgument("bytes");
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        if (byArray == null) {
            throw Util.nullArgument("bytes");
        }
        if (n < 0 || n > byArray.length) {
            throw Util.outOfRangeArgument("offset: " + n);
        }
        if (n2 > byArray.length - n) {
            throw Util.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l > 1L + (long)(Integer.MAX_VALUE - n2)) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        byte[] byArray2 = this.data;
        this.checkValid(byArray2);
        int n3 = byArray2.length;
        if (--l + (long)n2 > (long)n3) {
            byte[] byArray3 = new byte[(int)l + n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
            byArray3 = null;
        }
        System.arraycopy(byArray, n, byArray2, (int)l, n2);
        this.checkValid(this.data);
        this.data = byArray2;
        return n2;
    }

    public OutputStream setBinaryStream(final long l) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        if (l < 1L || l > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        this.checkValid(this.data);
        return new ByteArrayOutputStream(){

            public synchronized void close() throws IOException {
                try {
                    JDBCBlob.this.setBytes(l, this.toByteArray());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    public void truncate(long l) throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        if (l < 0L || l > (long)byArray.length) {
            throw Util.outOfRangeArgument("len: " + l);
        }
        if (l == (long)byArray.length) {
            return;
        }
        byte[] byArray2 = new byte[(int)l];
        System.arraycopy(byArray, 0, byArray2, 0, (int)l);
        this.checkValid(this.data);
        this.data = byArray2;
    }

    public void free() throws SQLException {
        this.data = null;
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        int n = byArray.length;
        if (l < 1L || l > (long)n) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        if (l2 < 0L || l2 > (long)n - --l) {
            throw Util.outOfRangeArgument("length: " + l2);
        }
        if (l == 0L && l2 == (long)n) {
            return new ByteArrayInputStream(byArray);
        }
        byte[] byArray2 = new byte[(int)l2];
        System.arraycopy(byArray, (int)l, byArray2, 0, (int)l2);
        return new ByteArrayInputStream(byArray2);
    }

    public void setGetBinaryStreamUsesCopy(boolean bl) {
        this.getBinaryStreamUsesCopy = bl;
    }

    public boolean isGetBinaryStreamUsesCopy() {
        return this.getBinaryStreamUsesCopy;
    }

    public JDBCBlob(byte[] byArray) throws SQLException {
        this.init(byArray);
        this.createdByConnection = false;
    }

    protected JDBCBlob() {
        this.data = new byte[0];
        this.createdByConnection = true;
    }

    protected void init(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw Util.nullArgument();
        }
        this.data = byArray;
    }

    protected void checkValid(Object object) {
        if (object == null) {
            throw new RuntimeException("null data");
        }
    }

    protected byte[] data() throws SQLException {
        byte[] byArray = this.data;
        this.checkValid(byArray);
        return byArray;
    }
}

