/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.synth.SynthContext;

public class SliderPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SliderPainter";

    protected SliderPainter() {
    }

    public static SliderPainter getInstance() {
        return SliderPainter.getInstance(null);
    }

    public static SliderPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SliderPainter.getPainterClassName(synthContext, SliderPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SliderPainter.getInstance(synthContext, SliderPainter.class, UI_KEY);
        }
        return (SliderPainter)syntheticaComponentPainter;
    }

    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.hasFocus()) {
            FocusPainter.paintFocus("focus.slider", synthContext, graphics, n, n2, n3, n4);
        }
    }

    public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets;
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey("slider.track", syntheticaPainterState, -1, -1, jSlider.getOrientation());
        Insets insets2 = insets = (Insets)uIKey.findProperty(synthContext, "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jSlider);
        ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
        imagePainter.draw();
        syntheticaPainterState = new SyntheticaPainterState(synthContext, 0, true);
        uIKey = new UIKey("slider.track", syntheticaPainterState, -1, -1, jSlider.getOrientation());
        string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jSlider);
        if (string != null) {
            int n5;
            uIKey = new UIKey("slider.track", syntheticaPainterState);
            int n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jSlider, 1);
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jSlider, 50);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jSlider, 2);
            if (syntheticaPainterState.isSet(SyntheticaState.State.HOVER) || syntheticaPainterState.isSet(SyntheticaState.State.PRESSED)) {
                n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jSlider, 1);
            }
            int n9 = jSlider.getValue() - jSlider.getMinimum();
            int n10 = n5 = jSlider.getMaximum() == jSlider.getMinimum() ? n9 : jSlider.getMaximum() - jSlider.getMinimum();
            if (n5 == 0) {
                n5 = 1;
            }
            if (jSlider.getOrientation() == 0) {
                if (!jSlider.getInverted() ^ !jSlider.getComponentOrientation().isLeftToRight()) {
                    n3 = Math.max(n3 * n9 / n5, insets.left + insets.right);
                } else {
                    int n11 = Math.max(n3 * n9 / n5, insets.left + insets.right);
                    n += n3 - n11;
                    n3 = n11;
                }
            } else if (!jSlider.getInverted()) {
                int n12 = Math.max(n4 * n9 / n5, insets.top + insets.bottom);
                n2 += n4 - n12;
                n4 = n12;
            } else {
                n4 = Math.max(n4 * n9 / n5, insets.top + insets.bottom);
            }
            imagePainter = new ImagePainter(jSlider, "track", n6, n7, n8, syntheticaPainterState.getState(), graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Insets insets;
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey("slider.thumb", syntheticaPainterState, -1, -1, jSlider.getOrientation());
        Insets insets2 = insets = (Insets)uIKey.findProperty(synthContext, "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jSlider);
        if (syntheticaPainterState.isSet(SyntheticaState.State.PRESSED) && string == null) {
            syntheticaPainterState.setState(SyntheticaState.State.HOVER.toInt());
            uIKey = new UIKey("slider.thumb", syntheticaPainterState, -1, -1, jSlider.getOrientation());
            string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jSlider);
        }
        if (string != null) {
            uIKey = new UIKey("slider.thumb", syntheticaPainterState);
            int n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jSlider, 1);
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jSlider, 50);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jSlider, 2);
            if (syntheticaPainterState.isSet(SyntheticaState.State.HOVER) || syntheticaPainterState.isSet(SyntheticaState.State.PRESSED)) {
                n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jSlider, 1);
            }
            ImagePainter imagePainter = new ImagePainter(jSlider, "thumb", n6, n7, n8, syntheticaPainterState.getState(), graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
        if ((jSlider.hasFocus() || syntheticaPainterState.isSet(SyntheticaState.State.FOCUSED)) && SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb", jSlider) != null) {
            FocusPainter.paintFocus("focus.slider.thumb", jSlider, syntheticaPainterState.getState(), "", graphics, n, n2, n3, n4);
        }
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        if (string.equals("paintSliderBackground")) {
            return -1;
        }
        JSlider jSlider = (JSlider)synthContext.getComponent();
        int n4 = jSlider.getOrientation();
        int n5 = super.getCacheHash(synthContext, n, n2, n3, string);
        n5 = 31 * n5 + n4;
        return n5;
    }
}

