/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ProgressBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ProgressBarPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ProgressBarPainter() {
    }

    public static ProgressBarPainter getInstance() {
        return ProgressBarPainter.getInstance(null);
    }

    public static ProgressBarPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ProgressBarPainter.getPainterClassName(synthContext, ProgressBarPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ProgressBarPainter.getInstance(synthContext, ProgressBarPainter.class, UI_KEY);
        }
        return (ProgressBarPainter)syntheticaComponentPainter;
    }

    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jProgressBar.getInsets();
        n3 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n4 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n += insets3.left - insets2.left;
        n2 += insets3.top - insets2.top;
        int n5 = jProgressBar.getValue() > 0 || jProgressBar.isIndeterminate() ? SyntheticaState.State.ACTIVE.toInt() : 0;
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n5, false);
        UIKey uIKey = new UIKey("progressBar.x.background", syntheticaPainterState);
        if (jProgressBar.getOrientation() == 1) {
            uIKey = new UIKey("progressBar.y.background", syntheticaPainterState);
        }
        Insets insets4 = insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 2);
        String string = (String)uIKey.findProperty(synthContext, null, true, 1);
        uIKey = new UIKey("progressBar.background", syntheticaPainterState);
        if (string != null) {
            int n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jProgressBar, 1);
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jProgressBar, 50);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 6);
            if (syntheticaPainterState.isSet(SyntheticaState.State.ACTIVE)) {
                n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 5);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)jProgressBar, n6, n7, n8, syntheticaPainterState.getState(), graphics, n, n2, n3, n4, string, insets, insets4, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        Insets insets;
        Graphics2D graphics2D = (Graphics2D)graphics;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey("progressBar.x", syntheticaPainterState);
        if (n5 == 1) {
            uIKey = new UIKey("progressBar.y", syntheticaPainterState);
        }
        if ((insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 1)) == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = insets;
        if (n5 == 0 ? n3 < (n8 = insets.left + insets.right) : n4 < (n8 = insets.top + insets.bottom)) {
            return;
        }
        n8 = n3;
        int n9 = n4;
        int n10 = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.tiled", jProgressBar) ? 1 : 0;
        String string = SyntheticaLookAndFeel.getString(uIKey.get(), jProgressBar);
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.continuous", jProgressBar)) {
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            n7 = image.getWidth(null) - insets.left - insets.right;
            n6 = image.getHeight(null) - insets.top - insets.bottom;
            n8 = (n3 - insets.left - insets.right) / n7 * n7 + insets.left + insets.right;
            n9 = (n4 - insets.top - insets.bottom) / n6 * n6 + insets.top + insets.bottom;
            n10 = 1;
        }
        int n11 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jProgressBar, -1);
        n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jProgressBar, 70);
        n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 0);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ImagePainter imagePainter = null;
        if (n5 == 0) {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n11, n7, n6, syntheticaPainterState.getState(), graphics, n, n2, n8, n4, string, insets, insets2, n10, 0);
            imagePainter.draw();
        } else {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n11, n7, n6, syntheticaPainterState.getState(), graphics, n, n2 - n9 + n4, n3, n9, string, insets, insets2, 0, n10);
            imagePainter.draw();
        }
        graphics2D.setRenderingHints(renderingHints);
        if (jProgressBar.isStringPainted() && jProgressBar.isIndeterminate()) {
            SynthStyle synthStyle = synthContext.getStyle();
            Font font = synthStyle.getFont(synthContext);
            graphics.setFont(font);
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = jProgressBar.getBounds();
            int n12 = synthStyle.getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, jProgressBar.getString());
            Point point = new Point(rectangle.width / 2 - n12 / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2);
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, jProgressBar.getString(), point.x, point.y, -1);
        }
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        if (string.equals("paintProgressBarForeground")) {
            return -1;
        }
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n4 = jProgressBar.getOrientation();
        int n5 = super.getCacheHash(synthContext, n, n2, n3, string);
        n5 = 31 * n5 + n4;
        return n5;
    }
}

