/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import de.javasoft.util.OS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class SyntheticaRootPaneUI
extends BasicRootPaneUI {
    private Window window;
    private JRootPane rootPane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayoutManager;
    private MouseInputListener mouseInputListener;
    private WindowListener windowListener;
    private ComponentListener windowResizeListener;
    private JComponent titlePane;
    public static final boolean EVAL_COPY = false;
    public static final int EVAL_HEIGHT = 16;
    public static final String EVAL_TEXT = "Synthetica - Unregistered Evaluation Copy!";

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaRootPaneUI();
    }

    public static final boolean isEvalCopy() {
        return false;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.rootPane = (JRootPane)c;
        if (this.isDecorated(this.rootPane)) {
            this.installClientDecorations(this.rootPane);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.rootPane);
        this.rootPane = null;
    }

    private void installClientDecorations(JRootPane root) {
        SyntheticaTitlePane titlePane = new SyntheticaTitlePane(root, this);
        this.setTitlePane(root, titlePane);
        this.installBorder(root);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
    }

    private void uninstallClientDecorations(JRootPane root) {
        if (this.titlePane != null && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).uninstallListeners(root);
        }
        this.setTitlePane(root, null);
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.uninstallLayout(root);
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    void installBorder(JRootPane root) {
        if (this.isDecorated(root)) {
            root.setBorder(new Border(){

                public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                    SynthContext sc = SyntheticaLookAndFeel.createContext((JComponent)c, Region.ROOT_PANE, 0);
                    SyntheticaPainter.getInstance().paintRootPaneBorder(sc, g, x, y, w, h);
                }

                public Insets getBorderInsets(Component c) {
                    if (SyntheticaRootPaneUI.this.window instanceof Frame && (((Frame)SyntheticaRootPaneUI.this.window).getExtendedState() & 6) == 6) {
                        return new Insets(0, 0, 0, 0);
                    }
                    Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.size", SyntheticaRootPaneUI.this.window);
                    if (insets == null) {
                        insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.insets", SyntheticaRootPaneUI.this.window);
                    }
                    return insets;
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }
    }

    private void uninstallBorder(JRootPane root) {
        root.setBorder(null);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        Window window = this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = new MouseInputHandler();
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
            if (this.windowListener == null && !SyntheticaLookAndFeel.isWindowOpacityEnabled(this.window)) {
                if (OS.getCurrentOS() == OS.Mac) {
                    SyntheticaLookAndFeel.setWindowOpaque(this.window, false);
                }
                this.windowListener = new WindowAdapter(){

                    public void windowOpened(WindowEvent evt) {
                        Window w = evt.getWindow();
                        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(SyntheticaRootPaneUI.this.window)) {
                            SyntheticaLookAndFeel.setWindowOpaque(w, false);
                            if (SyntheticaLookAndFeel.getBoolean("Synthetica.window.contentPane.opaque", SyntheticaRootPaneUI.this.window, true)) {
                                if (w instanceof JDialog && ((JDialog)w).getContentPane() instanceof JComponent) {
                                    ((JComponent)((JDialog)w).getContentPane()).setOpaque(true);
                                } else if (w instanceof JFrame && ((JFrame)w).getContentPane() instanceof JComponent) {
                                    ((JComponent)((JFrame)w).getContentPane()).setOpaque(true);
                                }
                            }
                        }
                    }
                };
                this.window.addWindowListener(this.windowListener);
            }
            if (this.windowResizeListener == null && SyntheticaLookAndFeel.isWindowShapeEnabled(this.window)) {
                if (OS.getCurrentOS() == OS.Mac) {
                    SyntheticaLookAndFeel.updateWindowShape(this.window);
                } else {
                    this.windowResizeListener = new ComponentAdapter(){

                        public void componentResized(ComponentEvent evt) {
                            Window w = (Window)evt.getComponent();
                            SyntheticaLookAndFeel.updateWindowShape(w);
                        }
                    };
                    this.window.addComponentListener(this.windowResizeListener);
                }
            }
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
            this.window.removeWindowListener(this.windowListener);
            this.window.removeComponentListener(this.windowResizeListener);
        }
        this.mouseInputListener = null;
        this.windowListener = null;
        this.windowResizeListener = null;
        this.window = null;
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = new SyntheticaRootLayout();
        }
        this.oldLayoutManager = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.oldLayoutManager != null) {
            root.setLayout(this.oldLayoutManager);
        }
        this.oldLayoutManager = null;
        this.layoutManager = null;
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        if (this.titlePane != null) {
            this.titlePane.setVisible(false);
            layeredPane.remove(this.titlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            this.uninstallClientDecorations(this.rootPane);
            if (this.isDecorated(this.rootPane)) {
                this.installClientDecorations(this.rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.rootPane);
            if (this.isDecorated(this.rootPane)) {
                this.installWindowListeners(this.rootPane, this.rootPane.getParent());
            }
        }
    }

    public void setMaximizedBounds(Frame frame) {
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.fullscreen")) {
            return;
        }
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsX")) {
            screenBounds.x = 0;
        }
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsY")) {
            screenBounds.y = 0;
        }
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.disableAutoHideTaskBarCorrection") && screenInsets.bottom == 0) {
            ++screenInsets.bottom;
        }
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
        frame.setMaximizedBounds(maxBounds);
    }

    private boolean isDecorated(JRootPane root) {
        return root.getWindowDecorationStyle() != 0;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private static final int WINDOW_MOVE = 1;
        private static final int WINDOW_RESIZE = 2;
        private int windowAction;
        private int dragXOffset;
        private int dragYOffset;
        private Dimension dragDimension;
        private int resizeType;
        private int minimumYPos;
        private Frame frame = null;
        private Dialog dialog = null;

        private MouseInputHandler() {
            if (SyntheticaRootPaneUI.this.window instanceof Frame) {
                this.frame = (Frame)SyntheticaRootPaneUI.this.window;
            } else if (SyntheticaRootPaneUI.this.window instanceof Dialog) {
                this.dialog = (Dialog)SyntheticaRootPaneUI.this.window;
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane)) {
                return;
            }
            SyntheticaRootPaneUI.this.window.toFront();
            this.minimumYPos = ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).window.getGraphicsConfiguration().getBounds().y;
            Point windowPoint = evt.getPoint();
            Point titlePanePoint = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, windowPoint, SyntheticaRootPaneUI.this.titlePane);
            int cursor = this.position2Cursor(SyntheticaRootPaneUI.this.window, evt.getX(), evt.getY());
            if (cursor == 0 && SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(titlePanePoint) && (this.dialog != null || this.frame != null && this.frame.getExtendedState() != 6)) {
                this.windowAction = 1;
                this.dragXOffset = windowPoint.x;
                this.dragYOffset = windowPoint.y;
            } else if (this.isWindowResizable()) {
                this.windowAction = 2;
                this.dragXOffset = windowPoint.x;
                this.dragYOffset = windowPoint.y;
                this.dragDimension = new Dimension(SyntheticaRootPaneUI.this.window.getWidth(), SyntheticaRootPaneUI.this.window.getHeight());
                this.resizeType = this.position2Cursor(SyntheticaRootPaneUI.this.window, windowPoint.x, windowPoint.y);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.windowAction == 2 && !SyntheticaRootPaneUI.this.window.isValid()) {
                SyntheticaRootPaneUI.this.window.validate();
                SyntheticaRootPaneUI.this.rootPane.repaint();
            }
            this.windowAction = -1;
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseMoved(MouseEvent evt) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane)) {
                return;
            }
            int cursor = this.position2Cursor(SyntheticaRootPaneUI.this.window, evt.getX(), evt.getY());
            if (cursor != 0 && this.isWindowResizable()) {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseEntered(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseExited(MouseEvent evt) {
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseDragged(MouseEvent evt) {
            GraphicsConfiguration gc = SyntheticaRootPaneUI.this.window.getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            this.minimumYPos = gc.getBounds().y + screenInsets.top;
            boolean respectMinimumYPos = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.window.respectMinimumYPos");
            if (this.windowAction == 1) {
                Point windowPt = evt.getPoint();
                SwingUtilities.convertPointToScreen(windowPt, (Component)evt.getSource());
                windowPt.x -= this.dragXOffset;
                windowPt.y -= this.dragYOffset;
                if (respectMinimumYPos && windowPt.y < this.minimumYPos) {
                    windowPt.y = this.minimumYPos;
                }
                SyntheticaRootPaneUI.this.window.setLocation(windowPt);
            } else if (this.windowAction == 2) {
                Point pt = evt.getPoint();
                Dimension min = (Dimension)SyntheticaLookAndFeel.get("Synthetica.rootPane.minimumWindowSize", SyntheticaRootPaneUI.this.window);
                if (min == null) {
                    min = SyntheticaRootPaneUI.this.window.getMinimumSize();
                }
                Rectangle bounds = SyntheticaRootPaneUI.this.window.getBounds();
                Rectangle startBounds = new Rectangle(bounds);
                if (this.resizeType == 11 || this.resizeType == 7 || this.resizeType == 5) {
                    bounds.width = Math.max(min.width, this.dragDimension.width + pt.x - this.dragXOffset);
                }
                if (this.resizeType == 9 || this.resizeType == 4 || this.resizeType == 5) {
                    bounds.height = Math.max(min.height, this.dragDimension.height + pt.y - this.dragYOffset);
                }
                if (this.resizeType == 8 || this.resizeType == 6 || this.resizeType == 7) {
                    int dy = pt.y - this.dragYOffset;
                    bounds.y += dy;
                    bounds.height -= dy;
                    if (bounds.height < min.height) {
                        bounds.y += bounds.height - min.height;
                        bounds.height = min.height;
                    }
                }
                if (this.resizeType == 10 || this.resizeType == 6 || this.resizeType == 4) {
                    int dx = pt.x - this.dragXOffset;
                    bounds.x += dx;
                    bounds.width -= dx;
                    if (bounds.width < min.width) {
                        bounds.x += bounds.width - min.width;
                        bounds.width = min.width;
                    }
                }
                if (respectMinimumYPos && bounds.y < this.minimumYPos) {
                    bounds.y = this.minimumYPos;
                }
                if (!bounds.equals(startBounds)) {
                    SyntheticaRootPaneUI.this.window.setBounds(bounds);
                }
            }
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.frame == null) {
                return;
            }
            Point convertedPoint = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, evt.getPoint(), SyntheticaRootPaneUI.this.titlePane);
            if (SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(convertedPoint) && evt.getClickCount() == 2 && (evt.getModifiers() & 0x10) == 16) {
                if (this.frame.isResizable() && this.isFrameResizable()) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).maximize();
                } else if (this.frame.isResizable() && !this.isFrameResizable()) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).restore();
                }
            }
        }

        private int position2Cursor(Window w, int x, int y) {
            Insets insets = SyntheticaRootPaneUI.this.rootPane.getBorder().getBorderInsets(SyntheticaRootPaneUI.this.rootPane);
            int ww = w.getWidth();
            int wh = w.getHeight();
            if (x < insets.left && y < insets.top) {
                return 6;
            }
            if (x > ww - insets.right && y < insets.top) {
                return 7;
            }
            if (x < insets.left && y > wh - insets.bottom) {
                return 4;
            }
            if (x > ww - insets.right && y > wh - insets.bottom) {
                return 5;
            }
            if (x < insets.left) {
                return 10;
            }
            if (x > ww - insets.right) {
                return 11;
            }
            if (y < insets.top) {
                return 8;
            }
            if (y > wh - insets.bottom) {
                return 9;
            }
            return 0;
        }

        private boolean isFrameResizable() {
            return this.frame != null && this.frame.isResizable() && (this.frame.getExtendedState() & 6) == 0;
        }

        private boolean isDialogResizable() {
            return this.dialog != null && this.dialog.isResizable();
        }

        private boolean isWindowResizable() {
            return this.isFrameResizable() || this.isDialogResizable();
        }
    }

    private static class SyntheticaRootLayout
    implements LayoutManager2 {
        private SyntheticaRootLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            dimC = dimC == null ? new Dimension(0, 0) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getPreferredSize();
            }
            dimM = dimM == null ? new Dimension(0, 0) : dimM;
            Dimension dimT = titlePane.getPreferredSize();
            dimT = dimT == null ? new Dimension(0, 0) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width)) + insets.left + insets.right;
            int height = dimC.height + dimM.height + dimT.height + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            dimC = dimC == null ? new Dimension(0, 0) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getMinimumSize();
            }
            dimM = dimM == null ? new Dimension(0, 0) : dimM;
            Dimension dimT = titlePane.getMinimumSize();
            dimT = dimT == null ? new Dimension(0, 0) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width)) + insets.left + insets.right;
            int height = dimC.height + dimM.height + dimT.height + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        public Dimension maximumLayoutSize(Container target) {
            int height;
            Insets insets = target.getInsets();
            JRootPane root = (JRootPane)target;
            JComponent titlePane = ((SyntheticaRootPaneUI)root.getUI()).titlePane;
            Dimension dimC = new Dimension(0, 0);
            dimC = root.getContentPane() != null ? root.getContentPane().getMaximumSize() : root.getSize();
            dimC = dimC == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimC;
            Dimension dimM = new Dimension(0, 0);
            if (root.getJMenuBar() != null) {
                dimM = root.getJMenuBar().getMaximumSize();
            }
            dimM = dimM == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimM;
            Dimension dimT = titlePane.getMaximumSize();
            dimT = dimT == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimT;
            int width = Math.max(dimC.width, Math.max(dimM.width, dimT.width));
            if (width != Integer.MAX_VALUE) {
                width += insets.left + insets.right;
            }
            if ((height = Math.max(dimC.height, Math.max(dimM.height, dimT.height))) != Integer.MAX_VALUE) {
                height += insets.top + insets.bottom;
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            Container cPane;
            JMenuBar mBar;
            Dimension dimT;
            JComponent titlePane;
            JRootPane rootPane = (JRootPane)parent;
            Rectangle bounds = rootPane.getBounds();
            Insets insets = rootPane.getInsets() != null ? rootPane.getInsets() : new Insets(0, 0, 0, 0);
            int width = bounds.width - insets.right - insets.left;
            int height = bounds.height - insets.top - insets.bottom;
            int nextY = 0;
            if (rootPane.getLayeredPane() != null) {
                rootPane.getLayeredPane().setBounds(insets.left, insets.top, width, height);
            }
            if (rootPane.getGlassPane() != null) {
                rootPane.getGlassPane().setBounds(insets.left, insets.top, width, height);
            }
            if ((titlePane = ((SyntheticaRootPaneUI)rootPane.getUI()).titlePane).isEnabled() && (dimT = titlePane.getPreferredSize()) != null) {
                titlePane.setBounds(0, 0, width, dimT.height);
                nextY += dimT.height;
            }
            if ((mBar = rootPane.getJMenuBar()) != null) {
                Dimension dimM = mBar.getPreferredSize();
                mBar.setBounds(0, nextY, width, dimM.height);
                nextY += dimM.height;
            }
            if ((cPane = rootPane.getContentPane()) != null) {
                cPane.setBounds(0, nextY, width, height < nextY ? 0 : height - nextY);
            }
        }
    }
}

