/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaDefaultTableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -4003145629974364170L;
    private Constructor<?> constructor;
    private Object value;

    public SyntheticaDefaultTableCellEditor() {
        super(new JTextField());
        this.getComponent().setName("Table.editor");
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new CellFocusBorder(SyntheticaLookAndFeel.getColor("Synthetica.table.cellEditor.focus.color", jTable)));
        try {
            Class<Object> clazz = jTable.getColumnClass(n2);
            if (clazz == Object.class) {
                clazz = String.class;
            }
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            return null;
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean stopCellEditing() {
        String string = (String)super.getCellEditorValue();
        if (string != null && string.length() == 0) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = "";
            }
            super.stopCellEditing();
        }
        try {
            this.value = this.constructor.newInstance(string);
        }
        catch (Exception exception) {
            ((JComponent)this.getComponent()).setBorder(new CellFocusBorder(new Color(0xE70000)));
            return false;
        }
        return super.stopCellEditing();
    }

    private static class CellFocusBorder
    implements Border {
        private static final int BORDER_SIZE = 2;
        private Color color = Color.GRAY;

        public CellFocusBorder(Color color) {
            if (color != null) {
                this.color = color;
            }
        }

        public Insets getBorderInsets(Component component) {
            if (component.getParent() instanceof JTable) {
                JLabel jLabel = new JLabel();
                jLabel.setName("Table.cellRenderer");
                SynthStyle synthStyle = SyntheticaLookAndFeel.getStyleFactory().getStyle(jLabel, Region.LABEL);
                Insets insets = synthStyle.getInsets(new SynthContext(jLabel, Region.LABEL, synthStyle, 0), null);
                return new Insets(2, insets.left, 2, insets.right);
            }
            return new Insets(2, 2, 2, 2);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.color);
            graphics2D.draw(this.createShape(n, n2, n3 - 1, n4 - 1));
            graphics2D.draw(this.createShape(n + 1, n2 + 1, n3 - 1 - 2, n4 - 1 - 2));
        }

        private Shape createShape(float f, float f2, float f3, float f4) {
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
    }

    public static class NumberEditor
    extends SyntheticaDefaultTableCellEditor {
        private static final long serialVersionUID = 966057265129092767L;

        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }
}

