/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import java.awt.Component;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.ComboPopup;

class AltKeyEventProcessor
implements KeyEventPostProcessor {
    private static boolean altKeyPressed = false;
    private static boolean menuActivated = false;

    AltKeyEventProcessor() {
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (keyEvent.getKeyCode() == 18) {
            JMenuBar jMenuBar;
            Component component = keyEvent.getComponent();
            Window window = SwingUtilities.getWindowAncestor(component);
            JRootPane jRootPane = SwingUtilities.getRootPane(component);
            JMenuBar jMenuBar2 = jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
            if (jMenuBar == null && window instanceof JFrame) {
                jMenuBar = ((JFrame)window).getJMenuBar();
            }
            if (keyEvent.getID() == 401) {
                if (!altKeyPressed) {
                    this.altPressed(keyEvent, jMenuBar);
                }
                altKeyPressed = true;
                return true;
            }
            if (keyEvent.getID() == 402) {
                if (altKeyPressed) {
                    this.altReleased(keyEvent, jMenuBar);
                }
                altKeyPressed = false;
            }
        } else {
            altKeyPressed = false;
        }
        return false;
    }

    private void altPressed(KeyEvent keyEvent, JMenuBar jMenuBar) {
        boolean bl = UIManager.getBoolean("Synthetica.forcedAltKeyEventConsumption");
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        if (menuElementArray.length > 0) {
            if (!(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
            }
            menuActivated = false;
            if (!bl) {
                keyEvent.consume();
            }
        } else {
            menuActivated = true;
            if (jMenuBar != null && jMenuBar.getMenu(0) != null && !bl) {
                keyEvent.consume();
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    private void altReleased(KeyEvent keyEvent, JMenuBar jMenuBar) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (menuSelectionManager.getSelectedPath().length == 0 && menuActivated) {
            JMenu jMenu;
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }
}

