/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.java;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DriverManager;
import java.util.Properties;

public class JavaSystem {
    public static int gcFrequency;
    public static int memoryRecords;
    static final BigDecimal BD_1;
    static final BigDecimal MBD_1;

    public static void gc() {
        if (gcFrequency > 0 && memoryRecords > gcFrequency) {
            memoryRecords = 0;
            System.gc();
        }
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public static int precision(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        if (bigDecimal.compareTo(BD_1) < 0 && bigDecimal.compareTo(MBD_1) > 0) {
            return bigDecimal.scale();
        }
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n = bigInteger.signum() == -1 ? 1 : 0;
        return bigInteger.toString().length() - n;
    }

    public static String toString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.toString();
    }

    public static int compareIngnoreCase(String string, String string2) {
        return string.compareToIgnoreCase(string2);
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string);
    }

    public static BigInteger unscaledValue(BigDecimal bigDecimal) {
        return bigDecimal.unscaledValue();
    }

    public static void setLogToSystem(boolean bl) {
        try {
            PrintWriter printWriter = bl ? new PrintWriter(System.out) : null;
            DriverManager.setLogWriter(printWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteOnExit(File file) {
        file.deleteOnExit();
    }

    public static void saveProperties(Properties properties, String string, OutputStream outputStream) throws IOException {
        properties.store(outputStream, string);
    }

    public static void runFinalizers() {
        System.runFinalizersOnExit((boolean)true);
    }

    public static boolean createNewFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void setRAFileLength(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.setLength(l);
    }

    static {
        BD_1 = BigDecimal.valueOf(1L);
        MBD_1 = BigDecimal.valueOf(-1L);
    }
}

