/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.Util;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;

public class JDBCClobClient
implements Clob {
    ClobDataID clob;
    SessionInterface session;
    boolean isClosed;

    public synchronized InputStream getAsciiStream() throws SQLException {
        throw Util.notSupported();
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    public synchronized String getSubString(long l, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, n)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized long length() throws SQLException {
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized long position(String string, long l) throws SQLException {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, string, l - 1L);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }

    public synchronized OutputStream setAsciiStream(long l) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized Writer setCharacterStream(long l) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public synchronized int setString(long l, String string, int n, int n2) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized void truncate(long l) throws SQLException {
        try {
            this.clob.truncate(this.session, l);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    public synchronized Reader getCharacterStream(long l, long l2) throws SQLException {
        return new ClobInputStream(this.session, this.clob, l - 1L, l2);
    }

    char[] getChars(long l, int n) throws SQLException {
        try {
            return this.clob.getChars(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    JDBCClobClient(SessionInterface sessionInterface, ClobDataID clobDataID) {
        this.session = sessionInterface;
        this.clob = clobDataID;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

