/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.Util;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCArray
implements Array {
    Type arrayType;
    Type elementType;
    Object[] data;
    JDBCConnection connection;

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() throws SQLException {
        Object[] objectArray = new Object[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            objectArray[i] = this.elementType.convertSQLToJava(this.connection.sessionProxy, this.data[i]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, l - 1L, n)) {
            throw Util.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.elementType.convertSQLToJava(this.connection.sessionProxy, this.data[(int)l + i - 1]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(l, n);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Result result = this.newColumnResult(0L, this.data.length);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        Result result = this.newColumnResult(l - 1L, n);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(l, n);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
    }

    JDBCArray(Object[] objectArray, Type type, JDBCConnection jDBCConnection) throws SQLException {
        this(objectArray, type, null, jDBCConnection);
    }

    JDBCArray(Object[] objectArray, Type type, Type type2, JDBCConnection jDBCConnection) throws SQLException {
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw Util.notSupported();
        }
        this.data = objectArray;
        this.elementType = type;
        this.arrayType = type2;
        this.connection = jDBCConnection;
    }

    Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long l, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, l, n)) {
            throw Util.outOfRangeArgument();
        }
        Type[] typeArray = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData resultMetaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        resultMetaData.columnLabels = new String[]{"C1", "C2"};
        resultMetaData.colIndexes = new int[]{-1, -1};
        resultMetaData.columns = new ColumnBase[2];
        ColumnBase columnBase = new ColumnBase("", "", "", "");
        columnBase.setType(typeArray[0]);
        resultMetaData.columns[0] = columnBase;
        columnBase = new ColumnBase("", "", "", "");
        columnBase.setType(typeArray[1]);
        resultMetaData.columns[1] = columnBase;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
        for (int i = (int)l; i < n; ++i) {
            Object[] objectArray = new Object[]{i + 1, this.data[i]};
            rowSetNavigatorClient.add(objectArray);
        }
        Result result = Result.newDataResult(resultMetaData);
        result.setNavigator(rowSetNavigatorClient);
        return result;
    }
}

