/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringUtil;

public class HsqlDateTime {
    private static Locale defaultLocale = Locale.UK;
    private static long currentDateMillis;
    public static final Calendar tempCalDefault;
    public static final Calendar tempCalGMT;
    private static final Date tempDate;
    private static final String sdfdPattern = "yyyy-MM-dd";
    static SimpleDateFormat sdfd;
    private static final String sdftPattern = "HH:mm:ss";
    static SimpleDateFormat sdft;
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat sdfts;
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date date = sdfd.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long l) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date date = sdfts.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTimestampString(StringBuffer stringBuffer, long l, int n, int n2) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            tempDate.setTime(l * 1000L);
            stringBuffer.append(sdfts.format(tempDate));
            if (n2 > 0) {
                stringBuffer.append('.');
                stringBuffer.append(StringUtil.toZeroPaddedString(n, 9, n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l);
            return sdfts.format(sysDate);
        }
    }

    public static synchronized long getCurrentDateMillis(long l) {
        if (l - currentDateMillis >= 86400000L) {
            currentDateMillis = HsqlDateTime.getNormalisedDate(l);
        }
        return currentDateMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long l) {
        calendar.clear();
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.setTimeInMillis(l);
            calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, long l) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.clear();
            calendar.setTimeInMillis(l);
            tempCalGMT.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            return tempCalGMT.getTimeInMillis();
        }
    }

    public static void setTimeInMillis(Calendar calendar, long l) {
        calendar.setTimeInMillis(l);
    }

    public static long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    public static long convertToNormalisedTime(long l) {
        return HsqlDateTime.convertToNormalisedTime(l, tempCalGMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(long l, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            long l2 = HsqlDateTime.getTimeInMillis(calendar);
            return l - l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedDate(long l, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = tempCalGMT;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToTime(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToTime(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long l) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, l);
            HsqlDateTime.resetToDate(tempCalGMT);
            return HsqlDateTime.getTimeInMillis(tempCalGMT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar calendar, long l) {
        return calendar.getTimeZone().getOffset(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(long l, int n) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(l);
            return tempCalGMT.get(n);
        }
    }

    public static String toFormattedDate(Date date, String string, SimpleDateFormat simpleDateFormat) {
        String string2 = HsqlDateTime.toJavaDatePattern(string);
        try {
            simpleDateFormat.applyPattern(string2);
        }
        catch (Exception exception) {
            throw Error.error(3472);
        }
        String string3 = simpleDateFormat.format(date);
        int n = string3.indexOf("*IY");
        if (n >= 0) {
            Calendar calendar = simpleDateFormat.getCalendar();
            int n2 = 3;
            int n3 = string3.indexOf("*IYYY");
            if (n3 >= 0) {
                n2 = 5;
                n = n3;
            }
            int n4 = calendar.get(1);
            int n5 = calendar.get(3);
            if (calendar.get(3) == 1 && calendar.get(6) > 360) {
                ++n4;
            }
            String string4 = String.valueOf(n4);
            if (n2 == 3) {
                string4 = string4.substring(string4.length() - 2);
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n, n + n2, string4);
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public static String toJavaDatePattern(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (!tokenizer.next(c, dateTokens)) {
                int n2 = tokenizer.getLastMatch();
                if (n2 >= 0) {
                    stringBuffer.setLength(stringBuffer.length() - tokenizer.length());
                    stringBuffer.append(javaDateTokens[n2]);
                }
                tokenizer.reset();
                if (tokenizer.isConsumed()) continue;
            }
            if (c == '\"') {
                c = '\'';
            }
            stringBuffer.append(c);
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        String string2 = stringBuffer.toString();
        return string2;
    }

    static {
        tempCalDefault = new GregorianCalendar();
        tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
        tempDate = new Date(0L);
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdft.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdft.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        currentDateMillis = HsqlDateTime.getNormalisedDate(System.currentTimeMillis());
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "EEEE", "EE", "w", "dd", "D", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "S"};
    }

    static class Tokenizer {
        private int last;
        private int offset;
        private long state;
        private boolean consumed;

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.last = -1;
            this.offset = -1;
            this.state = 0L;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.last;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        private boolean isZeroBit(int n) {
            return (this.state & 1L << n) == 0L;
        }

        private void setBit(int n) {
            this.state |= 1L << n;
        }

        public boolean next(char c, char[][] cArray) {
            int n = ++this.offset;
            int n2 = this.offset + 1;
            int n3 = 0;
            this.consumed = false;
            int n4 = cArray.length;
            while (--n4 >= 0) {
                if (!this.isZeroBit(n4)) continue;
                if (cArray[n4][n] == c) {
                    this.consumed = true;
                    if (cArray[n4].length == n2) {
                        this.setBit(n4);
                        this.last = n4;
                        continue;
                    }
                    ++n3;
                    continue;
                }
                this.setBit(n4);
            }
            return n3 > 0;
        }
    }
}

