/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.Tools;
import venue.Venue;
import venue.VenueRequest;
import venue.VenueRequestInfoDialog;

public class VenueRequestListDialog
extends JDialog {
    private JButton searchB;
    private JButton modifyB;
    private JButton addB;
    private ComboBoxNV venueNameNV;
    private ComboBoxCN requestStatusCN;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ScrollList listSL;
    private ArrayList g_List = VenueRequest.search(-1, "", null, null);

    public VenueRequestListDialog(JFrame frame) {
        super(frame, "\u5834\u5730\u7533\u8acb\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setLayout() {
        this.venueNameNV = new ComboBoxNV(Venue.getVenueNames(), "name", "venue_seq", -1);
        this.requestStatusCN = this.getStatus();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.searchB = new JButton("\u641c\u5c0b");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.addB = new JButton("\u65b0\u589e");
        this.addB.setEnabled(User.hasPrivilege("venueRequestModify"));
        this.modifyB.setEnabled(User.hasPrivilege("venueRequestRead"));
        this.listSL = new ScrollList(560, 410, this.g_List, new int[]{80, 60, 60, 100, 100, 90, 50}, new String[]{"\u65e5\u671f", "\u958b\u59cb\u6642\u9593", "\u7d50\u675f\u6642\u9593", "\u5834\u5730", "\u7528\u9014", "\u7533\u8acb\u4eba", "\u73fe\u6cc1"}, new String[]{"DATE", "START_TIME", "END_TIME", "VENUE_NAME", "PURPOSE", "MEMBER_NAME", "STATUS"}, new boolean[7]);
        this.listSL.setDateTextFieldColumn("DATE");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 370;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("\u4f7f\u7528\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("\u81f3");
        t.getClass();
        t.addCell(jLabel2, 1, 0, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 0, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("\u5834\u5730");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.venueNameNV, 1, 1, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 2, 1, -1, 0, 115, -1);
        JLabel jLabel4 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.requestStatusCN, 1, 2, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 2, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private ComboBoxCN getStatus() {
        String[][] status = new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ)};
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), "");
        c.hasNilItem(true);
        return c;
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onSearch(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onModify(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onAdd(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        int venue_seq = this.venueNameNV.getSelectedIntValue();
        String status = this.requestStatusCN.getSelectedCode();
        ArrayList v = VenueRequest.search(venue_seq, status, this.start_dateDT.getDate(), this.end_dateDT.getDate());
        this.listSL.refreshTable(v);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int venue_request_seq = ArrayUtil.getInt("VENUE_REQUEST_SEQ", selrow, this.listSL.getTableData());
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog(this, venue_request_seq, true);
        }
    }

    public void onAdd(ActionEvent evt) {
        VenueRequestInfoDialog d = new VenueRequestInfoDialog(this, -1, false);
    }
}

