/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.MemberGroup;
import member.MemberGroupMember;
import system.Config;
import system.MasterCode;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import ui.TimeTextField;
import util.ArrayUtil;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueRequest;
import venue.VenueRequestEquipment;
import venue.VenueRequestListDialog;

public class VenueRequestInfoDialog
extends JDialog {
    private ComboBoxNV venueNV;
    private ComboBoxCN statusCN;
    private DateTextField dateDT;
    private TimeTextField start_timeTT;
    private TimeTextField end_timeTT;
    private ComboBoxCN purposeCN;
    private JTextField remarkTF;
    private JTextField user_numTF;
    private JTextField max_userTF;
    private AutoComboBoxNV memberNV;
    private JTextField approve_nameTF;
    private DateTextField approve_dateDT;
    private DateTextField entry_dateDT;
    private ComboBoxNV add_equipment_idNV;
    private ScrollList itemSL;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton cancelB;
    private VenueRequest g_VenueRequest = null;
    private ArrayList g_Items;
    private boolean g_isUpdate = false;
    private HashMap recycle_bin = new HashMap();

    public VenueRequestInfoDialog(JDialog f, int venue_request_seq, boolean isUpdate) {
        super(f, "\u65b0\u589e\u5834\u5730\u7533\u8acb", false);
        if (isUpdate) {
            this.setTitle("\u4fee\u6539\u5834\u5730\u7533\u8acb");
        }
        this.g_isUpdate = isUpdate;
        this.init(venue_request_seq);
    }

    private void init(int venue_request_seq) {
        this.g_VenueRequest = new VenueRequest(venue_request_seq);
        VenueRequestEquipment p = new VenueRequestEquipment(venue_request_seq);
        this.g_Items = p.getItems();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        this.venueNV = new ComboBoxNV(Venue.getVenueNames(), "name", "venue_seq", this.g_VenueRequest.getVenue_seq());
        this.statusCN = this.getStatusSel();
        this.dateDT = new DateTextField(this.g_VenueRequest.getStart_time());
        this.start_timeTT = new TimeTextField(this.g_VenueRequest.getStart_time());
        this.end_timeTT = new TimeTextField(this.g_VenueRequest.getEnd_time());
        this.purposeCN = new ComboBoxCN(MasterCode.getCodes("ACTIVITY"), this.g_VenueRequest.getPurpose());
        this.remarkTF = new JTextField(this.g_VenueRequest.getRemark());
        this.user_numTF = new JTextField(String.valueOf(this.g_VenueRequest.getUser_num()));
        this.max_userTF = new JTextField(String.valueOf(new Venue(this.g_VenueRequest.getVenue_seq()).getUser_capacity()));
        this.memberNV = new AutoComboBoxNV((ArrayList)MemberGroupMember.getActiveMembersInGroup(MemberGroup.ROOT_GROUP_SEQ, this.g_VenueRequest.getMember_seq()), "list_item", "member_seq", this.g_VenueRequest.getMember_seq());
        this.approve_nameTF = new JTextField(this.g_VenueRequest.getApprove_name());
        this.approve_dateDT = new DateTextField(this.g_VenueRequest.getApprove_date());
        this.entry_dateDT = new DateTextField(this.g_VenueRequest.getEntry_date());
        this.add_equipment_idNV = new ComboBoxNV(VenueEquipment.getAvailableEquipments(this.g_VenueRequest.getVenue_seq()), "name", "venue_equipment_seq", -1);
        this.max_userTF.setEnabled(false);
        this.approve_nameTF.setEnabled(false);
        this.approve_dateDT.setEnabled(false);
        this.add_itemB = new JButton("\u52a0\u5165\u8a2d\u5099");
        this.del_itemB = new JButton("\u522a\u9664\u8a2d\u5099");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30, 30});
        JLabel jLabel = new JLabel("\u5834\u5730");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.venueNV, 1, 0, 20, 0, 220, -1);
        JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.statusCN, 3, 0, 20, 0, 75, -1);
        JLabel jLabel3 = new JLabel("\u4f7f\u7528\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.dateDT, 1, 1, 20, 0);
        t.getClass();
        t.addCell(this.start_timeTT, 1, 1, 105, 0);
        JLabel jLabel4 = new JLabel("\u81f3");
        t.getClass();
        t.addCell(jLabel4, 1, 1, 155, 0);
        t.getClass();
        t.addCell(this.end_timeTT, 1, 1, 170, 0);
        JLabel jLabel5 = new JLabel("\u6279\u6838\u4eba");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 2, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.approve_nameTF, 3, 1, 20, 0, 80, -1);
        JLabel jLabel6 = new JLabel("\u805a\u6703\u985e\u5225");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.purposeCN, 1, 2, 20, 0, 220, -1);
        JLabel jLabel7 = new JLabel("\u6279\u6838\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 2, 2, 1, 0);
        t.getClass();
        t.addCell(this.approve_dateDT, 3, 2, 20, 0);
        JLabel jLabel8 = new JLabel("\u7528\u9014\u8aaa\u660e");
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 0, 3, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, 3, 20, 0, 460, -1);
        JLabel jLabel9 = new JLabel("\u7533\u8acb\u4eba");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 0, 4, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.memberNV, 1, 4, 20, 0, 460, -1);
        JLabel jLabel10 = new JLabel("\u4f7f\u7528\u4eba\u6578");
        t.getClass();
        t.getClass();
        t.addCell(jLabel10, 0, 5, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.user_numTF, 1, 5, 20, 0, 50, -1);
        JLabel jLabel11 = new JLabel("\u4eba");
        t.getClass();
        t.addCell(jLabel11, 1, 5, 70, 0);
        JLabel jLabel12 = new JLabel("\u53ef\u5bb9\u7d0d\u4eba\u6578");
        t.getClass();
        t.addCell(jLabel12, 1, 5, 100, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.max_userTF, 1, 5, 170, 0, 50, -1);
        JLabel jLabel13 = new JLabel("\u4eba");
        t.getClass();
        t.addCell(jLabel13, 1, 5, 220, 0);
        JLabel jLabel14 = new JLabel("\u7533\u8acb\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel14, 2, 5, 1, 0);
        t.getClass();
        t.addCell(this.entry_dateDT, 3, 5, 20, 0);
        JLabel jLabel15 = new JLabel("\u4f7f\u7528\u8a2d\u5099");
        t.getClass();
        t.getClass();
        t.addCell(jLabel15, 0, 6, 1, 0);
        t.getClass();
        t.addCell(this.add_equipment_idNV, 1, 6, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 2, 6, 1, 0);
        t.getClass();
        t.addCell(this.del_itemB, 3, 6, 20, 0);
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        this.itemSL = new ScrollList(560, 250, this.g_Items, new int[]{300, 80, 80, 80}, new String[]{"\u8a2d\u5099\u540d\u7a31", "\u7e3d\u53ef\u7528\u91cf", "\u6578\u91cf", "\u55ae\u4f4d"}, new String[]{"name", "max_qty", "qty", "unit"}, blArray);
        this.itemSL.setEditing_mode(true);
        this.itemSL.setBigDecimalTextFieldColumn("max_qty", false);
        this.itemSL.setBigDecimalTextFieldColumn("qty", false);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{250});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, 0, 0);
        t.addYSpace(15);
        t.addTable(new int[]{435, 70, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private ComboBoxCN getStatusSel() {
        String[][] status;
        String cur_status = this.g_VenueRequest.getStatus();
        if (!this.g_isUpdate) {
            status = new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP)};
            cur_status = Config.getS(Config.venueRequestApproval).equals("Y") ? VenueRequest.STATUS__AP : VenueRequest.STATUS__WA;
        } else {
            status = this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__WA) ? new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ)} : (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__AP) ? new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL)} : new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL)});
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), cur_status);
        c.hasNilItem(false);
        return c;
    }

    private void setEventHandler() {
        this.venueNV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onChangeVenueCN(evt);
            }
        });
        this.add_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onChangeVenueCN(ActionEvent evt) {
        this.itemSL.getTableData().clear();
        this.itemSL.fireDataChanged();
        int venue_seq = this.venueNV.getSelectedIntValue();
        ArrayList equipments = VenueEquipment.getAvailableEquipments(venue_seq);
        this.add_equipment_idNV.refreshItems(equipments);
        this.add_equipment_idNV.setItemSelected(-1);
        this.max_userTF.setText(new Integer(new Venue(venue_seq).getUser_capacity()).toString());
    }

    private void onAddItem(ActionEvent evt) {
        int index = this.add_equipment_idNV.getSelectedIndex();
        int sel_vne_seq = this.add_equipment_idNV.getSelectedIntValue();
        ArrayList v = this.itemSL.getTableData();
        Validation validation = new Validation();
        validation.add(index != 0, "\u8acb\u9078\u64c7\u8a2d\u5099", "RT");
        validation.add(ArrayUtil.indexOf(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(sel_vne_seq), v) == -1, "\u6240\u9078\u7684\u8a2d\u5099\u5df2\u7d93\u52a0\u5165", "RT");
        if (!validation.isValid()) {
            return;
        }
        ArrayList equipments = VenueEquipment.getAvailableEquipments(this.venueNV.getSelectedIntValue());
        int venue_equipment_seq = ArrayUtil.getInt(VenueEquipment.VENUE_EQUIPMENT_SEQ, --index, equipments);
        String equipment_name = ArrayUtil.getString(VenueEquipment.NAME, index, equipments);
        double max_qty = ArrayUtil.getDouble(VenueEquipment.QTY, index, equipments);
        String unit = ArrayUtil.getString(VenueEquipment.UNIT, index, equipments);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put(VenueRequestEquipment.VENUE_REQUEST_EQUIPMENT_SEQ, new Integer(-1));
        h.put(VenueEquipment.NAME, equipment_name);
        h.put(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(venue_equipment_seq));
        h.put("max_qty", new BigDecimal(max_qty));
        h.put(VenueEquipment.QTY.toLowerCase(), new BigDecimal(0));
        h.put(VenueEquipment.UNIT.toLowerCase(), unit);
        v.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        ArrayList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.venueNV.getSelectedIndex(), "\u5834\u5730", "CBNVIR");
        validation.add(this.dateDT.getInput(), "\u4f7f\u7528\u65e5\u671f", "R,D");
        validation.add(this.start_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u958b\u59cb)", "R,T");
        validation.add(this.end_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u7d50\u675f)", "R,T");
        validation.add(this.purposeCN.getSelectedCode(), "\u7528\u9014\u985e\u5225", "R");
        validation.add(this.user_numTF.getText(), "\u4f7f\u7528\u4eba\u6578", "R,I,GTZ");
        validation.add(this.memberNV.getSelectedIntValue(), "\u7533\u8acb\u4eba", "CBNVIR");
        validation.add(this.entry_dateDT.getInput(), "\u7533\u8acb\u65e5\u671f", "R,D");
        int over_user = Integer.parseInt(this.user_numTF.getText()) - Integer.parseInt(this.max_userTF.getText());
        validation.add(over_user <= 0, "\u4f7f\u7528\u4eba\u6578\u4e0d\u53ef\u5927\u904e\u53ef\u5bb9\u7d0d\u4eba\u6578", "RT");
        ArrayList items = this.itemSL.getTableData();
        int i = 0;
        while (i < items.size()) {
            double qty = ArrayUtil.getDouble(VenueRequestEquipment.QTY, i, items);
            validation.add(qty, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u6578\u91cf", "R,F,GTZ");
            double max_qty = ArrayUtil.getDouble("MAX_QTY", i, items);
            validation.add(max_qty - qty >= 0.0, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u6578\u91cf\u5927\u904e\u7e3d\u53ef\u7528\u91cf", "RT");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        String venueStartTime = TimeUtil.getStringByTime(Config.getT(Config.venueStartTime));
        String venueEndTime = TimeUtil.getStringByTime(Config.getT(Config.venueEndTime));
        validation = new Validation();
        validation.add(this.start_timeTT.getInput().compareTo(venueStartTime) >= 0 && this.start_timeTT.getInput().compareTo(venueEndTime) <= 0, "\u4f7f\u7528\u6642\u9593(\u958b\u59cb)\u5fc5\u9808\u8981\u5728" + venueStartTime + "-" + venueEndTime + "\u4e4b\u5167", "RT");
        validation.add(this.end_timeTT.getInput().compareTo(venueStartTime) >= 0 && this.end_timeTT.getInput().compareTo(venueEndTime) <= 0, "\u4f7f\u7528\u6642\u9593(\u7d50\u675f)\u5fc5\u9808\u8981\u5728" + venueStartTime + "-" + venueEndTime + "\u4e4b\u5167", "RT");
        if (!validation.isValid()) {
            return false;
        }
        ArrayList overlaps = VenueRequest.getOverlappedRequests(this.g_VenueRequest.getVenue_Request_seq(), this.venueNV.getSelectedIntValue(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()));
        if (!overlaps.isEmpty()) {
            String msg = "\u5834\u5730\u5df2\u88ab\u4e0b\u9762\u7684\u7533\u8acb\u6240\u4f7f\u7528:\n";
            int i2 = 0;
            while (i2 < overlaps.size()) {
                String purpose = ArrayUtil.getString("PURPOSE", i2, overlaps);
                Timestamp start_time = ArrayUtil.getTimestamp("START_TIME", i2, overlaps);
                Timestamp end_time = ArrayUtil.getTimestamp("END_TIME", i2, overlaps);
                msg = String.valueOf(msg) + purpose + " " + TimeUtil.getStringByDate(start_time) + " " + TimeUtil.getStringByTime(start_time) + "-" + TimeUtil.getStringByTime(end_time) + "\n";
                ++i2;
            }
            WinUtil.showMessage(this, msg);
            return false;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_isUpdate) {
            VenueRequest.update(this.g_VenueRequest.getVenue_Request_seq(), this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
        } else {
            VenueRequest.insert(this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
        }
        ((VenueRequestListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

