/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import util.ArrayListSet;
import util.ArrayUtil;

public class VenueRequestEquipment {
    public static String VENUE_REQUEST_EQUIPMENT_SEQ = "venue_request_equipment_seq";
    public static String VENUE_REQUEST_SEQ = "venue_request_seq";
    public static String VENUE_EQUIPMENT_SEQ = "venue_equipment_seq";
    public static String QTY = "qty";
    private int g_Venue_request_seq = -1;
    private ArrayList g_Items = null;

    public VenueRequestEquipment() {
    }

    public VenueRequestEquipment(int venue_request_seq) {
        this.g_Venue_request_seq = venue_request_seq;
        DBConn conn = new DBConn();
        this.g_Items = VenueRequestEquipment.load(this.g_Venue_request_seq, conn);
        conn.commit();
    }

    public ArrayList getItems() {
        return this.g_Items;
    }

    private static ArrayList load(int venue_request_seq, DBConn conn) {
        String sql = "select vnre.venue_request_equipment_seq AS VENUE_REQUEST_EQUIPMENT_SEQ,vnre.venue_request_seq AS VENUE_REQUEST_SEQ,vnre.venue_equipment_seq AS VENUE_EQUIPMENT_SEQ,vnre.qty AS QTY,vne.qty AS MAX_QTY,vne.name AS NAME,vne.UNIT AS UNIT from venue_request_equipment vnre,venue_equipment vne where vne.venue_equipment_seq=vnre.venue_equipment_seq and vnre.venue_request_seq=? order by venue_request_equipment_seq";
        return DBUtil.select(new String[]{"VENUE_REQUEST_EQUIPMENT_SEQ", "VENUE_REQUEST_SEQ", "VENUE_EQUIPMENT_SEQ", "QTY", "MAX_QTY", "NAME", "UNIT"}, new int[]{4, 4, 4, 8, 8, 12, 12}, new Object[]{new Integer(venue_request_seq)}, new int[]{4}, sql, conn);
    }

    public static void update(int venue_request_seq, ArrayList items, DBConn conn) {
        ArrayList old_items = VenueRequestEquipment.load(venue_request_seq, conn);
        ArrayListSet set = new ArrayListSet(old_items, items, new String[]{VENUE_REQUEST_EQUIPMENT_SEQ});
        ArrayList v = set.getLeftOnly();
        int i = 0;
        while (i < v.size()) {
            int vn_request_equipment_seq = ArrayUtil.getInt(VENUE_REQUEST_EQUIPMENT_SEQ, i, v);
            VenueRequestEquipment.delete(vn_request_equipment_seq, conn);
            ++i;
        }
        v = set.getIntersectOfRight();
        i = 0;
        while (i < v.size()) {
            VenueRequestEquipment.update(ArrayUtil.getInt(VENUE_REQUEST_EQUIPMENT_SEQ, i, v), ArrayUtil.getInt(VENUE_EQUIPMENT_SEQ, i, v), ArrayUtil.getDouble(QTY, i, v), conn);
            ++i;
        }
        v = set.getRightOnly();
        i = 0;
        while (i < v.size()) {
            VenueRequestEquipment.insert(venue_request_seq, ArrayUtil.getInt(VENUE_EQUIPMENT_SEQ, i, v), ArrayUtil.getDouble(QTY, i, v), conn);
            ++i;
        }
    }

    private static void insert(int venue_request_seq, int venue_equipment_seq, double qty, DBConn conn) {
        String sql = "insert into venue_request_equipment( VENUE_REQUEST_EQUIPMENT_SEQ,VENUE_REQUEST_SEQ,VENUE_EQUIPMENT_SEQ,QTY)values(?,?,?,?)";
        int seq = DBUtil.getNextValueFor("venue_request_equipment_seq", conn);
        DBUtil.update(new Object[]{new Integer(seq), new Integer(venue_request_seq), new Integer(venue_equipment_seq), new BigDecimal(qty)}, new int[]{4, 4, 4, 8}, sql, conn);
    }

    private static void update(int venue_request_equipment_seq, int venue_equipment_seq, double qty, DBConn conn) {
        String sql = "update venue_request_equipment set VENUE_REQUEST_EQUIPMENT_SEQ=?,VENUE_EQUIPMENT_SEQ=?,QTY=? where VENUE_REQUEST_EQUIPMENT_SEQ=?";
        DBUtil.update(new Object[]{new Integer(venue_request_equipment_seq), new Integer(venue_equipment_seq), new BigDecimal(qty), new Integer(venue_request_equipment_seq)}, new int[]{4, 4, 8, 4}, sql, conn);
    }

    private static void delete(int venue_request_equipment_seq, DBConn conn) {
        String sql = "delete from venue_request_equipment where VENUE_REQUEST_EQUIPMENT_SEQ=?";
        DBUtil.update(new Object[]{new Integer(venue_request_equipment_seq)}, new int[]{4}, sql, conn);
    }
}

