/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import venue.VenueRequestEquipment;

public class VenueRequest {
    private int g_Venue_Request_seq = -1;
    private int g_Venue_seq = -1;
    private String g_Status = "WA";
    private int g_Member_seq = -1;
    private Timestamp g_Entry_date = null;
    private int g_Approve_user_seq = -1;
    private String g_Approve_name = "";
    private Timestamp g_Approve_date = null;
    private Timestamp g_Start_time = null;
    private Timestamp g_End_time = null;
    private String g_Purpose = "";
    private String g_Remark = "";
    private int g_User_num = 0;
    public static String STATUS__WA = "WA";
    public static String STATUS__AP = "AP";
    public static String STATUS__CL = "CL";
    public static String STATUS__RJ = "RJ";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__WA, "\u5f85\u6279\u51c6"}, new String[]{STATUS__AP, "\u5df2\u6279\u51c6"}, new String[]{STATUS__CL, "\u5df2\u53d6\u6d88"}, new String[]{STATUS__RJ, "\u4e0d\u6279\u51c6"}};

    public VenueRequest() {
    }

    public VenueRequest(int venue_request_seq) {
        this.g_Venue_Request_seq = venue_request_seq;
        this.load();
    }

    public int getVenue_Request_seq() {
        return this.g_Venue_Request_seq;
    }

    public int getVenue_seq() {
        return this.g_Venue_seq;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public Timestamp getEntry_date() {
        return this.g_Entry_date;
    }

    public Timestamp getStart_time() {
        return this.g_Start_time;
    }

    public Timestamp getEnd_time() {
        return this.g_End_time;
    }

    public String getPurpose() {
        return this.g_Purpose;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    public String getApprove_name() {
        return this.g_Approve_name;
    }

    public Timestamp getApprove_date() {
        return this.g_Approve_date;
    }

    public int getUser_num() {
        return this.g_User_num;
    }

    private void load() {
        String sql = "select VENUE_SEQ,STATUS,START_TIME,END_TIME,PURPOSE,REMARK,USER_NUM,MEMBER_SEQ,ENTRY_DATE,APPROVE_USER_SEQ,APPROVE_DATE from venue_request vnr where VENUE_REQUEST_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"VENUE_SEQ", "STATUS", "START_TIME", "END_TIME", "PURPOSE", "REMARK", "USER_NUM", "MEMBER_SEQ", "ENTRY_DATE", "APPROVE_USER_SEQ", "APPROVE_DATE"}, new int[]{4, 12, 93, 93, 12, 12, 4, 4, 93, 4, 93}, new Object[]{new Integer(this.g_Venue_Request_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Venue_seq = ArrayUtil.getInt("VENUE_SEQ", 0, v);
            this.g_Status = ArrayUtil.getString("STATUS", 0, v);
            this.g_Member_seq = ArrayUtil.getInt("MEMBER_SEQ", 0, v);
            this.g_Entry_date = ArrayUtil.getTimestamp("ENTRY_DATE", 0, v);
            this.g_Approve_user_seq = ArrayUtil.getInt("APPROVE_USER_SEQ", 0, v);
            this.g_Approve_date = ArrayUtil.getTimestamp("APPROVE_DATE", 0, v);
            this.g_Start_time = ArrayUtil.getTimestamp("START_TIME", 0, v);
            this.g_End_time = ArrayUtil.getTimestamp("END_TIME", 0, v);
            this.g_Purpose = ArrayUtil.getString("PURPOSE", 0, v);
            this.g_Remark = ArrayUtil.getString("REMARK", 0, v);
            this.g_User_num = ArrayUtil.getInt("USER_NUM", 0, v);
        }
    }

    public static void insert(int venue_seq, String status, int member_seq, Timestamp entry_date, Timestamp start_time, Timestamp end_time, String purpose, String remark, int user_num, ArrayList request_equipment) {
        String sql = "insert into venue_request( VENUE_REQUEST_SEQ,VENUE_SEQ,STATUS,MEMBER_SEQ,ENTRY_DATE,APPROVE_USER_SEQ,APPROVE_DATE,START_TIME,END_TIME,PURPOSE,REMARK,USER_NUM)values(?,?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int venue_request_seq = DBUtil.getNextValueFor("venue_request_seq", conn);
        Timestamp approve_date = null;
        if (status.equals(STATUS__AP)) {
            approve_date = TimeUtil.getCurrentDate();
        }
        DBUtil.update(new Object[]{new Integer(venue_request_seq), new Integer(venue_seq), status, new Integer(member_seq), entry_date, new Integer(-1), approve_date, start_time, end_time, purpose, remark, new Integer(user_num)}, new int[]{4, 4, 12, 4, 93, 4, 93, 93, 93, 12, 12, 4}, sql, conn);
        VenueRequestEquipment.update(venue_request_seq, request_equipment, conn);
        conn.commit();
    }

    public static void update(int venue_request_seq, int venue_seq, String status, int member_seq, Timestamp entry_date, Timestamp start_time, Timestamp end_time, String purpose, String remark, int user_num, ArrayList request_equipment) {
        String sql = "update venue_request set VENUE_SEQ=?,STATUS=?,MEMBER_SEQ=?,ENTRY_DATE=?,APPROVE_USER_SEQ=?,APPROVE_DATE=?,START_TIME=?,END_TIME=?,PURPOSE=?,REMARK=?,USER_NUM=? where VENUE_REQUEST_SEQ=?";
        DBConn conn = new DBConn();
        Timestamp approve_date = null;
        if (status.equals(STATUS__AP)) {
            approve_date = TimeUtil.getCurrentDate();
        }
        DBUtil.update(new Object[]{new Integer(venue_seq), status, new Integer(member_seq), entry_date, new Integer(-1), approve_date, start_time, end_time, purpose, remark, new Integer(user_num), new Integer(venue_request_seq)}, new int[]{4, 12, 4, 93, 4, 93, 93, 93, 12, 12, 4, 4}, sql, conn);
        VenueRequestEquipment.update(venue_request_seq, request_equipment, conn);
        conn.commit();
    }

    public static ArrayList search(int venue_seq, String status, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"vr.VENUE_SEQ=?", "vr.STATUS=?", "vr.START_TIME>=?", "vr.END_TIME<?"}, new Object[]{new Integer(venue_seq), status, start_date, TimeUtil.adjustDate(end_date, 1)}, new int[]{4, 12, 93, 93});
        String sql = "select vr.venue_request_seq,vr.start_time as date,vr.start_time,vr.end_time,vn.name as venue_name,mc.name as purpose,mm.name_chi as member_name,vr.status from venue_request vr,venue vn,member mm,master_code mc where vr.venue_seq=vn.venue_seq and vr.member_seq=mm.member_seq and vr.purpose=mc.code" + clause.getConds() + " order by vr.status desc,vr.start_time,vn.name" + " limit 1000";
        RecordList v = DBUtil.select(new String[]{"VENUE_REQUEST_SEQ", "DATE", "START_TIME", "END_TIME", "VENUE_NAME", "PURPOSE", "MEMBER_NAME", "STATUS"}, new int[]{4, 93, 93, 93, 12, 12, 12, 12}, clause.getPrepValues(), clause.getPrepTypes(), sql);
        int i = 0;
        while (i < v.size()) {
            ArrayUtil.setString("STATUS", Tools.getStatusName(STATUS_MAP, ArrayUtil.getString("STATUS", i, v)), i, v);
            ArrayUtil.setString("START_TIME", TimeUtil.getStringByTime(ArrayUtil.getTimestamp("START_TIME", i, v)), i, v);
            ArrayUtil.setString("END_TIME", TimeUtil.getStringByTime(ArrayUtil.getTimestamp("END_TIME", i, v)), i, v);
            ++i;
        }
        return v;
    }

    public static ArrayList getOverlappedRequests(int venue_request_seq, int venue_seq, Timestamp start_time, Timestamp end_time) {
        String sql = "select mc.NAME as PURPOSE,vnr.start_time as start_time,vnr.end_time as end_time from venue_request vnr,master_code mc where vnr.venue_request_seq<>? and vnr.venue_seq=? and vnr.PURPOSE=mc.code and vnr.status<>'" + STATUS__CL + "'" + " and vnr.status<>'" + STATUS__RJ + "'" + " and(" + "  (vnr.start_time>=? and vnr.start_time<=?)" + "  or" + "  (vnr.end_time>=? and vnr.end_time<=?)" + " )";
        return DBUtil.select(new String[]{"PURPOSE", "START_TIME", "END_TIME"}, new int[]{12, 93, 93}, new Object[]{new Integer(venue_request_seq), new Integer(venue_seq), start_time, end_time, start_time, end_time}, new int[]{4, 4, 93, 93, 93, 93}, sql);
    }
}

