/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import system.SystemCode;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueListDialog;

public class VenueInfoDialog
extends JDialog {
    JTextField nameTF;
    ComboBoxCN statusCN;
    JTextArea descTA;
    JTextField user_capacityTF;
    JTextField request_beforeTF;
    private ScrollList itemSL;
    JButton add_itemB;
    JButton del_itemB;
    JButton saveB;
    JButton cancelB;
    private Venue g_Venue = null;
    private ArrayList g_Items;
    private boolean g_isUpdate = true;
    private boolean g_isFreeEquipment = false;

    public VenueInfoDialog(JDialog f, int venue_seq) {
        super(f, "\u65b0\u589e\u5834\u5730", false);
        if (venue_seq >= 0) {
            this.setTitle("\u4fee\u6539\u5834\u5730");
            this.g_isUpdate = true;
        } else if (venue_seq == Venue.FREE_EQUIPMENT_SEQ) {
            this.setTitle("\u4fee\u6539\u6d41\u52d5\u8a2d\u5099");
            this.g_isFreeEquipment = true;
        } else {
            this.g_isUpdate = false;
        }
        this.init(venue_seq);
    }

    private void init(int venue_seq) {
        this.g_Venue = new Venue(venue_seq);
        VenueEquipment p = new VenueEquipment(venue_seq);
        this.g_Items = p.getItems();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        if (!this.g_isFreeEquipment) {
            this.nameTF = new JTextField(this.g_Venue.getName());
            String defaultStatus = this.g_isUpdate ? this.g_Venue.getStatus() : "A";
            this.statusCN = new ComboBoxCN(SystemCode.getStatus(), defaultStatus);
            this.statusCN.hasNilItem(false);
            this.descTA = new JTextArea(this.g_Venue.getDesc());
            this.user_capacityTF = new JTextField(Integer.toString(this.g_Venue.getUser_capacity()));
            this.request_beforeTF = new JTextField(Integer.toString(this.g_Venue.getRequest_before()));
        }
        this.add_itemB = new JButton("\u52a0\u5165\u8a2d\u5099");
        this.del_itemB = new JButton("\u522a\u9664\u8a2d\u5099");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        if (!this.g_isFreeEquipment) {
            int[] nArray = new int[4];
            nArray[0] = 100;
            nArray[1] = 240;
            nArray[2] = 120;
            t.getClass();
            nArray[3] = 0;
            t.addTable(nArray, new int[]{30, 60});
            JLabel jLabel = new JLabel("\u5834\u5730\u540d\u7a31");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.nameTF, 1, 0, 20, 0, 280, -1);
            JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 2, 0, 1, 0, 40, -1);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.statusCN, 3, 0, -1, 0, 80, -1);
            JLabel jLabel3 = new JLabel("\u7c21\u4ecb");
            t.getClass();
            t.getClass();
            t.addCell(jLabel3, 0, 1, 1, 0);
            JScrollPane jScrollPane = new JScrollPane(this.descTA);
            t.getClass();
            t.addCell(jScrollPane, 1, 1, 20, 0, 420, 60);
            int[] nArray2 = new int[5];
            nArray2[0] = 100;
            nArray2[1] = 60;
            nArray2[2] = 230;
            nArray2[3] = 90;
            t.getClass();
            nArray2[4] = 0;
            t.addTable(nArray2, new int[]{30, 30});
            JLabel jLabel4 = new JLabel("\u5bb9\u7d0d\u4eba\u6578");
            t.getClass();
            t.getClass();
            t.addCell(jLabel4, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.user_capacityTF, 1, 0, 20, 0, 35, -1);
            JLabel jLabel5 = new JLabel("\u4eba");
            t.getClass();
            t.getClass();
            t.addCell(jLabel5, 2, 0, -1, 0);
            JLabel jLabel6 = new JLabel("\u8655\u7406\u7533\u8acb\u5929\u6578");
            t.getClass();
            t.getClass();
            t.addCell(jLabel6, 0, 1, 1, -1);
            t.getClass();
            t.getClass();
            t.addCell(this.request_beforeTF, 1, 1, 20, -1, 35, -1);
            JLabel jLabel7 = new JLabel("\u5929");
            t.getClass();
            t.getClass();
            t.addCell(jLabel7, 2, 1, -1, -1);
        } else {
            int[] nArray = new int[5];
            nArray[0] = 100;
            nArray[1] = 60;
            nArray[2] = 230;
            nArray[3] = 90;
            t.getClass();
            nArray[4] = 0;
            t.addTable(nArray, new int[]{120, 30});
        }
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 3, 1, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.del_itemB, 4, 1, -1, -1);
        this.itemSL = new ScrollList(560, 300, this.g_Items, new int[]{145, 230, 60, 55, 80}, new String[]{"\u8a2d\u5099\u540d\u7a31", "\u8a73\u7d30\u8aaa\u660e", "\u6578\u91cf", "\u55ae\u4f4d", "\u73fe\u6cc1"}, new String[]{VenueEquipment.NAME, VenueEquipment.DESC, VenueEquipment.QTY, VenueEquipment.UNIT, VenueEquipment.STATUS}, new boolean[]{true, true, true, true, true});
        this.itemSL.setEditing_mode(true);
        ComboBoxNV item_status = new ComboBoxNV(SystemCode.getStatus(), "name", "code", "A");
        item_status.hasNilItem(false);
        this.itemSL.setComboxNVColumn(VenueEquipment.STATUS, item_status);
        t.addYSpace(15);
        int[] nArray = new int[1];
        t.getClass();
        nArray[0] = 0;
        t.addTable(nArray, new int[]{300});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        t.addYSpace(15);
        t.addTable(new int[]{435, 70, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private void setEventHandler() {
        this.add_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onAddItem(ActionEvent evt) {
        ArrayList v = this.itemSL.getTableData();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(-1));
        h.put(VenueEquipment.VENUE_SEQ, new Integer(this.g_Venue.getVenue_seq()));
        h.put(VenueEquipment.DESC, "");
        h.put(VenueEquipment.QTY, new BigDecimal(1));
        h.put(VenueEquipment.UNIT, "\u500b");
        h.put(VenueEquipment.STATUS, "A");
        v.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        ArrayList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        if (this.g_Venue.getVenue_seq() != Venue.FREE_EQUIPMENT_SEQ) {
            validation.add(this.nameTF.getText(), "\u5834\u5730\u540d\u7a31", "R");
            validation.add(this.user_capacityTF.getText(), "\u5bb9\u7d0d\u4eba\u6578", "R,I,GTZ");
            validation.add(this.request_beforeTF.getText(), "\u8655\u7406\u7533\u8acb\u5929\u6578", "R,I,GEZ");
        }
        ArrayList items = this.itemSL.getTableData();
        int i = 0;
        while (i < items.size()) {
            String name = ArrayUtil.getString(VenueEquipment.NAME, i, items);
            double qty = ArrayUtil.getDouble(VenueEquipment.QTY, i, items);
            String unit = ArrayUtil.getString(VenueEquipment.UNIT, i, items);
            validation.add(name, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u540d\u7a31", "R");
            validation.add(qty, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u6578\u91cf", "R,F,GTZ");
            validation.add(unit, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u55ae\u4f4d", "R");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_isFreeEquipment) {
            Venue.updateFreeEquipment(items);
        } else if (this.g_isUpdate) {
            Venue.update(this.g_Venue.getVenue_seq(), this.nameTF.getText(), this.descTA.getText(), this.statusCN.getSelectedCode(), Integer.parseInt(this.user_capacityTF.getText()), Integer.parseInt(this.request_beforeTF.getText()), new String("N"), items);
        } else {
            Venue.insert(this.nameTF.getText(), this.descTA.getText(), this.statusCN.getSelectedCode(), Integer.parseInt(this.user_capacityTF.getText()), Integer.parseInt(this.request_beforeTF.getText()), new String("N"), items);
        }
        ((VenueListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

