/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import util.ArrayListSet;
import util.ArrayUtil;
import util.RecordList;
import venue.Venue;

public class VenueEquipment {
    private int g_Venue_seq = -1;
    private ArrayList g_Items = null;
    public static String VENUE_EQUIPMENT_SEQ = "VENUE_EQUIPMENT_SEQ";
    public static String VENUE_SEQ = "VENUE_SEQ";
    public static String NAME = "NAME";
    public static String DESC = "DESC";
    public static String QTY = "QTY";
    public static String UNIT = "UNIT";
    public static String STATUS = "STATUS";

    public VenueEquipment(int venue_seq) {
        this.g_Venue_seq = venue_seq;
        DBConn conn = new DBConn();
        this.g_Items = VenueEquipment.load(this.g_Venue_seq, conn);
        conn.commit();
    }

    public ArrayList getItems() {
        return this.g_Items;
    }

    public static ArrayList load(int venue_seq, DBConn conn) {
        String sql = "select venue_equipment_seq,name,desc,qty,unit,status from venue_equipment where venue_seq=? order by venue_equipment_seq";
        return DBUtil.select(new String[]{"VENUE_EQUIPMENT_SEQ", "NAME", "DESC", "QTY", "UNIT", "STATUS"}, new int[]{4, 12, 12, 8, 12, 12}, new Object[]{new Integer(venue_seq)}, new int[]{4}, sql, conn);
    }

    public static void update(int venue_seq, ArrayList items, DBConn conn) {
        ArrayList old_items = VenueEquipment.load(venue_seq, conn);
        ArrayListSet set = new ArrayListSet(old_items, items, new String[]{VENUE_EQUIPMENT_SEQ});
        ArrayList v = set.getLeftOnly();
        int i = 0;
        while (i < v.size()) {
            int venue_equipment_seq = ArrayUtil.getInt(VENUE_EQUIPMENT_SEQ, i, v);
            VenueEquipment.delete(venue_equipment_seq, conn);
            ++i;
        }
        v = set.getIntersectOfRight();
        i = 0;
        while (i < v.size()) {
            VenueEquipment.update(ArrayUtil.getInt(VENUE_EQUIPMENT_SEQ, i, v), ArrayUtil.getString("NAME", i, v), ArrayUtil.getString("DESC", i, v), ArrayUtil.getDouble("QTY", i, v), ArrayUtil.getString("UNIT", i, v), ArrayUtil.getString("STATUS", i, v), conn);
            ++i;
        }
        v = set.getRightOnly();
        i = 0;
        while (i < v.size()) {
            VenueEquipment.insert(venue_seq, ArrayUtil.getString("NAME", i, v), ArrayUtil.getString("DESC", i, v), ArrayUtil.getDouble("QTY", i, v), ArrayUtil.getString("UNIT", i, v), ArrayUtil.getString("STATUS", i, v), conn);
            ++i;
        }
    }

    private static void insert(int venue_seq, String name, String desc, double qty, String unit, String status, DBConn conn) {
        String sql = "insert into venue_equipment( VENUE_EQUIPMENT_SEQ,VENUE_SEQ,NAME,DESC,QTY,UNIT,STATUS)values(?,?,?,?,?,?,?)";
        int venue_equipment_seq = DBUtil.getNextValueFor("venue_equipment_seq", conn);
        DBUtil.update(new Object[]{new Integer(venue_equipment_seq), new Integer(venue_seq), name, desc, new BigDecimal(qty), unit, status}, new int[]{4, 4, 12, 12, 8, 12, 12}, sql, conn);
    }

    private static void update(int equipment_seq, String name, String desc, double qty, String unit, String status, DBConn conn) {
        String sql = "update venue_equipment set NAME=?,DESC=?,QTY=?,UNIT=?,STATUS=? where VENUE_EQUIPMENT_SEQ=?";
        DBUtil.update(new Object[]{name, desc, new BigDecimal(qty), unit, status, new Integer(equipment_seq)}, new int[]{12, 12, 8, 12, 12, 4}, sql, conn);
    }

    private static void delete(int venue_equipment_seq, DBConn conn) {
        String sql = "delete from venue_equipment where VENUE_EQUIPMENT_SEQ=?";
        DBUtil.update(new Object[]{new Integer(venue_equipment_seq)}, new int[]{4}, sql, conn);
    }

    public static ArrayList getAvailableEquipments(int venue_seq) {
        String sql = "select venue_equipment_seq,venue_seq,name,desc,qty,unit from venue_equipment where (venue_seq=? or venue_seq=" + Venue.FREE_EQUIPMENT_SEQ + ")" + " and status='A'" + " order by venue_seq desc,name";
        RecordList v = DBUtil.select(new String[]{"VENUE_EQUIPMENT_SEQ", "VENUE_SEQ", "NAME", "DESC", "QTY", "UNIT"}, new int[]{4, 4, 12, 12, 8, 12}, new Object[]{new Integer(venue_seq)}, new int[]{4}, sql);
        int i = 0;
        while (i < v.size()) {
            if (ArrayUtil.getInt("VENUE_SEQ", i, v) == Venue.FREE_EQUIPMENT_SEQ) {
                ArrayUtil.setString("NAME", String.valueOf(ArrayUtil.getString("NAME", i, v)) + "(\u6d41\u52d5\u8a2d\u5099)", i, v);
            }
            ++i;
        }
        return v;
    }
}

