/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import java.util.ArrayList;
import system.SystemCode;
import util.ArrayUtil;
import util.RecordList;
import venue.VenueEquipment;

public class Venue {
    public static int FREE_EQUIPMENT_SEQ = -2;
    private int g_Venue_seq = -1;
    private String g_Name = "";
    private String g_Desc = "";
    private String g_Status = "";
    private int g_User_capacity = 0;
    private int g_Request_before = 0;
    private String g_Has_floor_plan = "";

    public Venue() {
    }

    public Venue(int venue_seq) {
        this.g_Venue_seq = venue_seq;
        this.load();
    }

    public int getVenue_seq() {
        return this.g_Venue_seq;
    }

    public String getName() {
        return this.g_Name;
    }

    public String getDesc() {
        return this.g_Desc;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public int getUser_capacity() {
        return this.g_User_capacity;
    }

    public int getRequest_before() {
        return this.g_Request_before;
    }

    public String getHas_floor_plan() {
        return this.g_Has_floor_plan;
    }

    private void load() {
        String sql = "select NAME,DESC,STATUS,USER_CAPACITY,REQUEST_BEFORE,HAS_FLOOR_PLAN from venue where VENUE_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"NAME", "DESC", "STATUS", "USER_CAPACITY", "REQUEST_BEFORE", "HAS_FLOOR_PLAN"}, new int[]{12, 12, 12, 4, 4, 12}, new Object[]{new Integer(this.g_Venue_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Name = ArrayUtil.getString("NAME", 0, v);
            this.g_Desc = ArrayUtil.getString("DESC", 0, v);
            this.g_Status = ArrayUtil.getString("STATUS", 0, v);
            this.g_User_capacity = ArrayUtil.getInt("USER_CAPACITY", 0, v);
            this.g_Request_before = ArrayUtil.getInt("REQUEST_BEFORE", 0, v);
            this.g_Has_floor_plan = ArrayUtil.getString("HAS_FLOOR_PLAN", 0, v);
        }
    }

    public static int insert(String name, String desc, String status, int user_capacity, int request_before, String has_floor_plan, ArrayList equipments) {
        String sql = "insert into venue( VENUE_SEQ,NAME,DESC,STATUS,USER_CAPACITY,REQUEST_BEFORE,HAS_FLOOR_PLAN)values(?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int venue_seq = DBUtil.getNextValueFor("venue_seq", conn);
        DBUtil.update(new Object[]{new Integer(venue_seq), name, desc, status, new Integer(user_capacity), new Integer(request_before), has_floor_plan}, new int[]{4, 12, 12, 12, 4, 4, 12}, sql, conn);
        VenueEquipment.update(venue_seq, equipments, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_seq : -1;
    }

    public static int update(int venue_seq, String name, String desc, String status, int user_capacity, int request_before, String has_floor_plan, ArrayList equipments) {
        String sql = "update venue set NAME=?,DESC=?,STATUS=?,USER_CAPACITY=?,REQUEST_BEFORE=?,HAS_FLOOR_PLAN=? where VENUE_SEQ=?";
        DBConn conn = new DBConn();
        DBUtil.update(new Object[]{name, desc, status, new Integer(user_capacity), new Integer(request_before), has_floor_plan, new Integer(venue_seq)}, new int[]{12, 12, 12, 4, 4, 12, 4}, sql, conn);
        VenueEquipment.update(venue_seq, equipments, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_seq : -1;
    }

    public static int updateFreeEquipment(ArrayList equipments) {
        DBConn conn = new DBConn();
        VenueEquipment.update(FREE_EQUIPMENT_SEQ, equipments, conn);
        conn.commit();
        return FREE_EQUIPMENT_SEQ;
    }

    public static ArrayList search() {
        String sql = "select venue_seq,name,desc,status,user_capacity,request_before,has_floor_plan from venue where venue_seq>=? order by status asc, name";
        RecordList v = DBUtil.select(new String[]{"VENUE_SEQ", "NAME", "DESC", "USER_CAPACITY", "REQUEST_BEFORE", "HAS_FLOOR_PLAN", "STATUS"}, new int[]{4, 12, 12, 4, 4, 12, 12}, new Object[]{new Integer(-1)}, new int[]{4}, sql);
        int i = 0;
        while (i < v.size()) {
            ArrayUtil.setString("STATUS", SystemCode.getStatus(ArrayUtil.getString("STATUS", i, v)), i, v);
            ++i;
        }
        return v;
    }

    public static ArrayList getVenueNames() {
        String sql = "select venue_seq,name,user_capacity,request_before from venue where STATUS='A' order by name";
        return DBUtil.select(new String[]{"VENUE_SEQ", "NAME", "USER_CAPACITY", "REQUEST_BEFORE"}, new int[]{4, 12, 4, 4}, sql);
    }

    public static String getVenueName(int venue_seq) {
        ArrayList venueName = Venue.getVenueNames();
        int i = ArrayUtil.indexOf("CODE", new Integer(venue_seq), venueName);
        return ArrayUtil.getString("NAME", i, venueName);
    }
}

