/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ui.ProcessingDialog;

public class WinUtil {
    public static void setFixedWindow(Component c, int width, int height) {
        c.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setLocation(Math.max(0, (screenSize.width - width) / 2), Math.max(0, (screenSize.height - height) / 2));
        if (c instanceof JFrame) {
            JFrame f = (JFrame)c;
            f.setResizable(false);
        } else if (c instanceof JDialog) {
            JDialog f = (JDialog)c;
            f.setResizable(false);
        }
    }

    public static JDialog getWaitingDialog(JDialog parent, String message) {
        return WinUtil.getWaitingDialog(parent, message, 0.0);
    }

    public static JDialog getWaitingDialog(JDialog parent, String message, double wait_second) {
        ProcessingDialog f = new ProcessingDialog(parent, "", true);
        return f;
    }

    public static boolean getConfirm(Component c, String message) {
        int reply = JOptionPane.showConfirmDialog(c, message, "\u8cc7\u8a0a", 1);
        return reply == 0;
    }

    public static void showMessage(Component c, String message) {
        JOptionPane.showMessageDialog(c, message, "\u8cc7\u8a0a", 1);
    }

    public static boolean getConfirmSave(Component c) {
        return WinUtil.getConfirm(c, "\u662f\u5426\u5132\u5b58\u8cc7\u6599?");
    }

    public static boolean getConfirmCancel(Component c) {
        return WinUtil.getConfirm(c, "\u53d6\u6d88\u8f38\u5165?");
    }
}

