/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JPanel;
import util.Tools;
import util.WinUtil;

public class TableLayout
extends JPanel {
    private int g_WindowX = 0;
    private int g_WindowY = 0;
    private int g_Tx = 0;
    private int g_Ty = 0;
    private int g_NextTx = 0;
    private int g_NextTy = 0;
    private int[] g_Columns;
    private int[] g_Rows;
    public final int LEFT = -1;
    public final int RIGHT = 1;
    public final int TOP = -1;
    public final int BUTTOM = 1;
    public final int CENTER = 0;
    public final int FULLSIZE = 0;
    public final int DEFSIZE = -1;
    public final int TABLEREMAIN = 0;

    public TableLayout(JDialog d, int windowX, int windowY, int marginX, int marginY) {
        this.g_WindowX = windowX;
        this.g_WindowY = windowY;
        this.g_NextTx = marginX;
        this.g_NextTy = marginY;
        this.setLayout(null);
        d.setSize(this.g_WindowX, this.g_WindowY);
        d.add(this);
        WinUtil.setFixedWindow(d, windowX, windowY);
    }

    public TableLayout(int windowX, int windowY, int marginX, int marginY) {
        this.g_WindowX = windowX;
        this.g_WindowY = windowY;
        this.g_NextTx = marginX;
        this.g_NextTy = marginY;
        this.setLayout(null);
    }

    public void addTable(int[] columns, int[] rows) {
        this.g_Columns = new int[columns.length + 1];
        this.g_Rows = new int[rows.length + 1];
        this.g_Columns[0] = 0;
        this.g_Rows[0] = 0;
        this.g_Tx = this.g_NextTx;
        this.g_Ty = this.g_NextTy;
        int remainWidth = this.g_WindowX - 2 * this.g_NextTx - 8;
        int i = 0;
        while (i < columns.length) {
            remainWidth -= columns[i];
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            this.g_Columns[i + 1] = columns[i] != 0 ? this.g_Columns[i] + columns[i] : this.g_Columns[i] + remainWidth;
            ++i;
        }
        i = 0;
        while (i < rows.length) {
            this.g_Rows[i + 1] = this.g_Rows[i] + rows[i];
            this.g_NextTy += rows[i];
            ++i;
        }
    }

    public void addCell(Component comp, int colnum, int rownum, int colstyle, int rowstyle) {
        this.addCell(comp, colnum, rownum, colstyle, rowstyle, -1, -1);
    }

    public void addCell(Component comp, int colnum, int rownum, int colstyle, int rowstyle, int compsizeX, int compsizeY) {
        if (colnum >= this.g_Columns.length - 1) {
            Tools.writeError("Column number " + colnum + " is overflow");
            return;
        }
        if (rownum >= this.g_Rows.length - 1) {
            Tools.writeError("Row number " + rownum + " is overflow");
            return;
        }
        int cell_sizeX = this.g_Columns[colnum + 1] - this.g_Columns[colnum];
        int cell_sizeY = this.g_Rows[rownum + 1] - this.g_Rows[rownum];
        int comp_sizeX = 0;
        int comp_sizeY = 0;
        comp_sizeX = compsizeX > 0 ? compsizeX : (compsizeX == 0 ? cell_sizeX : (comp.getSize().getWidth() != 0.0 ? (int)comp.getSize().getWidth() : (int)comp.getPreferredSize().getWidth()));
        comp_sizeY = compsizeY > 0 ? compsizeY : (compsizeY == 0 ? cell_sizeY : (comp.getSize().getHeight() != 0.0 ? (int)comp.getSize().getHeight() : (int)comp.getPreferredSize().getHeight()));
        int shiftX = 0;
        int shiftY = 0;
        if (colstyle == 0) {
            shiftX = (cell_sizeX - comp_sizeX) / 2;
        } else if (colstyle == 1) {
            shiftX = cell_sizeX - comp_sizeX;
        } else if (colstyle == -1) {
            shiftX = 0;
        } else if (colstyle > 1) {
            shiftX = colstyle;
        } else if (colstyle < -1) {
            shiftX = cell_sizeX - comp_sizeX + colstyle;
        }
        if (rowstyle == 0) {
            shiftY = (cell_sizeY - comp_sizeY) / 2;
        } else if (rowstyle == 1) {
            shiftY = cell_sizeY - comp_sizeY;
        } else if (rowstyle == -1) {
            shiftY = 0;
        } else if (rowstyle > 1) {
            shiftY = rowstyle;
        } else if (rowstyle < -1) {
            shiftY = cell_sizeY - comp_sizeY + rowstyle;
        }
        int cx = this.g_Tx + this.g_Columns[colnum] + shiftX;
        int cy = this.g_Ty + this.g_Rows[rownum] + shiftY;
        comp.setBounds(cx, cy, comp_sizeX, comp_sizeY);
        this.add(comp);
    }

    public void addYSpace(int height) {
        this.addTable(new int[1], new int[]{height});
    }
}

