/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import ui.CheckBoxYN;
import ui.ComboBoxNV;
import ui.DateTextField;
import util.Arith;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class ScrollList2
extends JScrollPane {
    private String[] gColKeys;
    private ScrollTable gTable = new ScrollTable();
    private TableModel gTableModel;

    public ScrollList2(int width, int height, RecordList data, int[] col_widths, String[] col_headers, String[] col_keys, boolean[] col_editable) {
        this.setViewportView(this.gTable);
        this.setVerticalScrollBarPolicy(22);
        this.gColKeys = col_keys;
        this.gTableModel = new TableModel(data, col_headers, col_keys, col_editable);
        this.gTable.setModel(this.gTableModel);
        this.gTable.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.gTable.getTableHeader().setReorderingAllowed(false);
        this.gTable.setRowHeight(20);
        this.gTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        MultiLineHeaderRenderer mhr = new MultiLineHeaderRenderer();
        int i = 0;
        while (i < col_widths.length) {
            TableColumn tc = this.gTable.getColumnModel().getColumn(i);
            tc.setPreferredWidth(col_widths[i]);
            tc.setHeaderRenderer(mhr);
            this.setTextFieldColumn(this.gColKeys[i]);
            ++i;
        }
    }

    public void setEditing_mode(boolean s) {
        this.gTable.setEditing_mode(s);
    }

    public void setHorizontalScroll() {
        this.gTable.setAutoResizeMode(0);
    }

    public void setMatchedRowProperties(String[] colNames, Object[] values, Color color, boolean editable) {
        this.gTableModel.setMatchedRow(colNames, values);
        this.gTableModel.setMatchRowEditable(editable);
        this.gTable.setMatchedRowBgColor(color);
    }

    public void setColorColumn(String colName) {
    }

    public String getChangedColName(TableModelEvent evt) {
        if (evt.getColumn() != -1) {
            return this.gColKeys[evt.getColumn()];
        }
        return "";
    }

    public void addActionListener(TableModelListener c) {
        this.gTableModel.addTableModelListener(c);
    }

    public RecordList getTableData() {
        return this.gTableModel.getTableData();
    }

    public int getSelectedRow() {
        return this.gTable.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.gTable.getSelectedRows();
    }

    public JTableHeader getTableHeader() {
        return this.gTable.getTableHeader();
    }

    public void setSelectedRow(int row, int col) {
        this.gTable.changeSelection(row, col, false, false);
    }

    public void fireDataChanged() {
        this.gTableModel.fireTableDataChanged();
    }

    public void refreshTable() {
        this.gTableModel.refreshTable();
    }

    public void refreshTable(RecordList r) {
        this.gTableModel.refreshTable(r);
    }

    private int getColIndexByKey(String col_key) {
        int i = 0;
        while (i < this.gColKeys.length) {
            if (this.gColKeys[i].equals(col_key)) {
                return i;
            }
            ++i;
        }
        Tools.writeError("no " + col_key + " to set the ScrollList column type");
        return -1;
    }

    public void setTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new TextFieldEditor(new TextField()));
        tc.setCellRenderer(new TextField());
    }

    public void setIntegerTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new IntegerTextFieldEditor(new IntegerTextField()));
        tc.setCellRenderer(new IntegerTextField());
    }

    public void setBigDecimalTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new BigDecimalTextFieldEditor(new BigDecimalTextField()));
        tc.setCellRenderer(new BigDecimalTextField());
    }

    public void setDateTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new DateTextFieldEditor(new DateTextField()));
        DateTextField f = new DateTextField();
        f.setEmptyBorder();
        tc.setCellRenderer(f);
    }

    public void setTimeTextFieldColumn(String col_key, Timestamp date_part) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new TimeTextFieldEditor(new TimeTextField(date_part)));
        tc.setCellRenderer(new TimeTextField(date_part));
    }

    public void setDateTimeTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new DateTimeTextFieldEditor(new DateTimeTextField()));
        tc.setCellRenderer(new DateTimeTextField());
    }

    public void setComboxNVColumn(String col_key, ComboBoxNV editor) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        ComboBoxNV renderer = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(editor);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            renderer = (ComboBoxNV)ois.readObject();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        tc.setCellEditor(new ComboBoxNVEditor(editor));
        tc.setCellRenderer(renderer);
    }

    public void setCheckBoxYNColumn(String col_key, String true_value, String false_value) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.gTable.getColumnModel().getColumn(colIndex);
        CheckBoxYN editor = new CheckBoxYN(true_value, false_value, "");
        CheckBoxYN renderer = new CheckBoxYN(true_value, false_value, "");
        tc.setCellEditor(new CheckBoxYNEditor(editor));
        tc.setCellRenderer(renderer);
    }

    class BigDecimalTextField
    extends JTextField
    implements TableCellRenderer {
        public BigDecimalTextField() {
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(Arith.formatAmount(((BigDecimal)item_value).doubleValue()));
            return this;
        }
    }

    class BigDecimalTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private BigDecimalTextField gTextField;

        public BigDecimalTextFieldEditor(BigDecimalTextField tf) {
            this.gTextField = tf;
        }

        public Object getCellEditorValue() {
            try {
                Double.parseDouble(this.gTextField.getText());
                return new BigDecimal(this.gTextField.getText());
            }
            catch (NumberFormatException e) {
                return new BigDecimal(0);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(Arith.formatDouble(((BigDecimal)value).doubleValue()));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    class CheckBoxYNEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private CheckBoxYN gCheckBox;

        public CheckBoxYNEditor(CheckBoxYN box) {
            this.gCheckBox = box;
        }

        public Object getCellEditorValue() {
            return this.gCheckBox.isSelected() ? this.gCheckBox.getTrue_value() : this.gCheckBox.getFalse_value();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gCheckBox.setSelected(value.equals(this.gCheckBox.getTrue_value()));
            return this.gCheckBox;
        }
    }

    class ComboBoxNVEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBoxNV gComboBoxNV;

        public ComboBoxNVEditor(ComboBoxNV box) {
            this.gComboBoxNV = box;
        }

        public Object getCellEditorValue() {
            return this.gComboBoxNV.getSelectedObjectValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gComboBoxNV.setSelectedItem(value);
            this.fireEditingStopped();
            return this.gComboBoxNV;
        }
    }

    class DateTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DateTextField gTextField;

        public DateTextFieldEditor(DateTextField tf) {
            this.gTextField = tf;
            this.gTextField.setEmptyBorder();
        }

        public Object getCellEditorValue() {
            return TimeUtil.getDateByString(this.gTextField.getText());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setValue(TimeUtil.getStringByDate((Timestamp)value));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    class DateTimeTextField
    extends JTextField
    implements TableCellRenderer {
        public DateTimeTextField() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(TimeUtil.getStringByDateTime((Timestamp)item_value));
            return this;
        }
    }

    class DateTimeTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DateTimeTextField gTextField;

        public DateTimeTextFieldEditor(DateTimeTextField tf) {
            this.gTextField = tf;
        }

        public Object getCellEditorValue() {
            StringTokenizer st = new StringTokenizer(this.gTextField.getText(), " ");
            return TimeUtil.getDateByString(st.nextToken(), st.nextToken());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(TimeUtil.getStringByDateTime((Timestamp)value));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    class IntegerTextField
    extends JTextField
    implements TableCellRenderer {
        public IntegerTextField() {
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(String.valueOf(item_value));
            return this;
        }
    }

    class IntegerTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntegerTextField gTextField;

        public IntegerTextFieldEditor(IntegerTextField tf) {
            this.gTextField = tf;
        }

        public Object getCellEditorValue() {
            try {
                Integer.parseInt(this.gTextField.getText());
                return new Integer(this.gTextField.getText());
            }
            catch (NumberFormatException e) {
                return new Integer(0);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(String.valueOf(value));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    public class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        public MultiLineHeaderRenderer() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ListCellRenderer renderer = this.getCellRenderer();
            ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
            this.setCellRenderer(renderer);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setListData(v);
            return this;
        }
    }

    class ScrollTable
    extends JTable {
        private boolean gEditing_mode = false;
        private Color gMatchedRowBgColor = null;

        ScrollTable() {
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (this.gEditing_mode) {
                if (this.isRowSelected(row) && this.isColumnSelected(column)) {
                    c.setForeground(Color.BLACK);
                    c.setBackground(Color.YELLOW);
                } else {
                    c.setForeground(Color.BLACK);
                    if (this.gMatchedRowBgColor != null && ((TableModel)this.getModel()).isRowMatched(row)) {
                        c.setBackground(this.gMatchedRowBgColor);
                    } else {
                        c.setBackground(Color.WHITE);
                    }
                }
            } else if (this.isRowSelected(row)) {
                c.setForeground(Color.BLACK);
                c.setBackground(Color.lightGray);
            } else {
                c.setForeground(Color.BLACK);
                if (this.gMatchedRowBgColor != null && ((TableModel)this.getModel()).isRowMatched(row)) {
                    c.setBackground(this.gMatchedRowBgColor);
                } else {
                    c.setBackground(Color.WHITE);
                }
            }
            return c;
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c instanceof JTextComponent) {
                ((JTextField)c).selectAll();
            }
            return c;
        }

        public void setEditing_mode(boolean s) {
            this.gEditing_mode = s;
        }

        public boolean getEditing_mode() {
            return this.gEditing_mode;
        }

        public void setMatchedRowBgColor(Color color) {
            this.gMatchedRowBgColor = color;
        }
    }

    public class TableModel
    extends AbstractTableModel {
        private String[] gColKeys;
        private String[] gColHeaders;
        private boolean[] gColEditable;
        private String[] gMatchRowCols;
        private Object[] gMatchRowValues;
        private boolean gMatchedRowEditable = true;
        private RecordList gData = null;

        public TableModel(RecordList r, String[] headers, String[] keys) {
            this.gData = r;
            this.gColHeaders = headers;
            this.gColKeys = keys;
        }

        public TableModel(RecordList r, String[] headers, String[] keys, boolean[] editable) {
            this.gData = r;
            this.gColHeaders = headers;
            this.gColKeys = keys;
            this.gColEditable = editable;
            this.gMatchRowCols = new String[0];
            this.gMatchRowValues = new Object[0];
        }

        public void setMatchedRow(String[] colNames, Object[] values) {
            this.gMatchRowCols = colNames;
            this.gMatchRowValues = values;
        }

        public void setMatchRowEditable(boolean editable) {
            this.gMatchedRowEditable = editable;
        }

        public boolean isRowMatched(int row) {
            if (this.gMatchRowCols.length == 0) {
                return false;
            }
            int i = 0;
            while (i < this.gMatchRowCols.length) {
                if (!this.gData.getObj(this.gMatchRowCols[i], row).equals(this.gMatchRowValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int getColumnCount() {
            return this.gColHeaders.length;
        }

        public int getRowCount() {
            return this.gData.size();
        }

        public String getColumnName(int col) {
            return this.gColHeaders[col];
        }

        public String getColumnKey(int col) {
            return this.gColKeys[col];
        }

        public Object getValueAt(int row, int col) {
            String key = this.gColKeys[col];
            return this.gData.getObj(key, row);
        }

        public void setValueAt(Object obj, int row, int col) {
            this.gData.setObj(this.gColKeys[col], obj, row);
            this.fireTableCellUpdated(row, col);
        }

        public void refreshTable() {
            this.fireTableDataChanged();
        }

        public void refreshTable(RecordList r) {
            this.gData = r;
            this.fireTableDataChanged();
        }

        public RecordList getTableData() {
            return this.gData;
        }

        public boolean isCellEditable(int row, int col) {
            int i = 0;
            while (i < this.gMatchRowCols.length) {
                if (!this.gData.getObj(this.gMatchRowCols[i], row).equals(this.gMatchRowValues[i])) break;
                if (i == this.gMatchRowCols.length - 1) {
                    return this.gMatchedRowEditable;
                }
                ++i;
            }
            return this.gColEditable[col];
        }

        public Class getColumnClass(int c) {
            Class<?> cl;
            try {
                cl = this.getValueAt(0, c).getClass();
            }
            catch (Exception e) {
                cl = "".getClass();
            }
            return cl;
        }
    }

    class TextField
    extends JTextField
    implements TableCellRenderer {
        public TextField() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(item_value == null ? "" : item_value.toString());
            return this;
        }
    }

    class TextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TextField gTextField;

        public TextFieldEditor(TextField tf) {
            this.gTextField = tf;
        }

        public Object getCellEditorValue() {
            return this.gTextField.getText();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(value == null ? "" : value.toString());
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    class TimeTextField
    extends JTextField
    implements TableCellRenderer {
        private Timestamp gDate_part;

        public TimeTextField(Timestamp date_part) {
            this.gDate_part = date_part;
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Timestamp getDate_part() {
            return this.gDate_part;
        }

        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(TimeUtil.getStringByTime((Timestamp)item_value));
            return this;
        }
    }

    class TimeTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TimeTextField gTextField;

        public TimeTextFieldEditor(TimeTextField tf) {
            this.gTextField = tf;
        }

        public Object getCellEditorValue() {
            String date = TimeUtil.getStringByDate(this.gTextField.getDate_part());
            return TimeUtil.getDateByString(date, this.gTextField.getText());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(TimeUtil.getStringByTime((Timestamp)value));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }
}

