/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import util.TimeUtil;

public class DateTextField
extends JFormattedTextField
implements TableCellRenderer {
    public DateTextField() {
        this.setFormat();
        this.setValue("--/--/----");
        this.setSize(80, (int)this.getPreferredSize().getHeight());
    }

    public DateTextField(Timestamp t) {
        this();
        String value = TimeUtil.getStringByDate(t);
        if (!value.equals("")) {
            this.setValue(value);
        }
    }

    private void setFormat() {
        MaskFormatter fmt = null;
        try {
            fmt = new MaskFormatter("**/**/****");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        DefaultFormatterFactory fmtFactory = new DefaultFormatterFactory(fmt);
        this.setFormatterFactory(fmtFactory);
    }

    public String getInput() {
        if (this.getValue().equals("--/--/----")) {
            return "";
        }
        if (this.getValue().equals("  /  /    ")) {
            return "";
        }
        return (String)this.getValue();
    }

    public Timestamp getDate() {
        if (this.getValue() == null) {
            return null;
        }
        return TimeUtil.getDateByString((String)this.getValue());
    }

    public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(TimeUtil.getStringByDate((Timestamp)item_value));
        return this;
    }

    public void setEmptyBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }
}

