/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import ui.ComboBoxNV;
import util.ArrayUtil;

public class AutoComboBoxNV
extends ComboBoxNV {
    ComboBoxModel model = this.getModel();
    JTextComponent editor;
    AutoDocument document = new AutoDocument();
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoComboBoxNV(ArrayList items, String name_col, String value_col, int selected_value) {
        super(items, name_col, value_col, selected_value);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!AutoComboBoxNV.this.selecting) {
                    AutoComboBoxNV.this.highlightCompletedText(0);
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoComboBoxNV.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoComboBoxNV.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (AutoComboBoxNV.this.isDisplayable()) {
                    AutoComboBoxNV.this.setPopupVisible(true);
                }
                AutoComboBoxNV.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoComboBoxNV.this.hitBackspace = true;
                        AutoComboBoxNV.this.hitBackspaceOnSelection = AutoComboBoxNV.this.editor.getSelectionStart() != AutoComboBoxNV.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        e.consume();
                        AutoComboBoxNV.this.getToolkit().beep();
                        break;
                    }
                    case 38: {
                        if (AutoComboBoxNV.this.getSelectedIndex() == 0) {
                            AutoComboBoxNV.this.getToolkit().beep();
                            break;
                        }
                        AutoComboBoxNV.this.document.setText(AutoComboBoxNV.this.getName(AutoComboBoxNV.this.getSelectedIndex() - 1));
                        break;
                    }
                    case 40: {
                        if (AutoComboBoxNV.this.getSelectedIndex() == AutoComboBoxNV.this.getItems().size() - 1) {
                            AutoComboBoxNV.this.getToolkit().beep();
                            break;
                        }
                        AutoComboBoxNV.this.document.setText(AutoComboBoxNV.this.getName(AutoComboBoxNV.this.getSelectedIndex() + 1));
                        break;
                    }
                    case 33: {
                        if (AutoComboBoxNV.this.getSelectedIndex() <= 8) {
                            AutoComboBoxNV.this.getToolkit().beep();
                            break;
                        }
                        AutoComboBoxNV.this.document.setText(AutoComboBoxNV.this.getName(AutoComboBoxNV.this.getSelectedIndex() - 8));
                        break;
                    }
                    case 34: {
                        if (AutoComboBoxNV.this.getSelectedIndex() >= AutoComboBoxNV.this.getItems().size() - 8) {
                            AutoComboBoxNV.this.getToolkit().beep();
                            break;
                        }
                        AutoComboBoxNV.this.document.setText(AutoComboBoxNV.this.getName(AutoComboBoxNV.this.getSelectedIndex() + 8));
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AutoComboBoxNV.this.highlightCompletedText(0);
            }

            public void focusLost(FocusEvent e) {
                if (AutoComboBoxNV.this.hidePopupOnFocusLoss) {
                    AutoComboBoxNV.this.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(this.getEditor());
        Object selected = this.getSelectedObjectValue();
        if (selected != null) {
            this.document.setText(selected.toString());
        }
        this.highlightCompletedText(0);
        this.setEditable(true);
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextComponent)newEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this.document);
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.document.getLength());
        this.editor.moveCaretPosition(start);
    }

    public void setNameSelected(Object selected_name) {
        ArrayList items = this.getItems();
        int i = 0;
        while (i < items.size()) {
            String name = ArrayUtil.getString(this.getName_col(), i, items);
            if (name.equals(selected_name)) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        if (items.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setSelected(int index) {
        this.setSelectedIndex(0);
        this.document.setText(this.getSelectedName());
    }

    private String getName(int i) {
        return ArrayUtil.getString(this.getName_col(), i, this.getItems());
    }

    private Object lookupItem(String pattern) {
        String selectedItem = this.getSelectedName();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int i = 0;
        int n = this.model.getSize();
        while (i < n) {
            String currentItem = this.getName(i);
            if (currentItem != null && this.startsWithIgnoreCase(currentItem.toString(), pattern)) {
                return currentItem;
            }
            ++i;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().startsWith(str2.toUpperCase());
    }

    class AutoDocument
    extends PlainDocument {
        AutoDocument() {
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (AutoComboBoxNV.this.selecting) {
                return;
            }
            if (AutoComboBoxNV.this.hitBackspace) {
                if (offs > 0) {
                    if (AutoComboBoxNV.this.hitBackspaceOnSelection) {
                        --offs;
                    }
                } else {
                    AutoComboBoxNV.this.getToolkit().beep();
                }
                AutoComboBoxNV.this.highlightCompletedText(offs);
            } else {
                super.remove(offs, len);
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoComboBoxNV.this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = AutoComboBoxNV.this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                AutoComboBoxNV.this.setNameSelected(item);
            } else {
                item = AutoComboBoxNV.this.getSelectedName();
                offs -= str.length();
                AutoComboBoxNV.this.getToolkit().beep();
            }
            this.setText(item.toString());
            AutoComboBoxNV.this.highlightCompletedText(offs + str.length());
        }

        private void setText(String text) {
            try {
                super.remove(0, this.getLength());
                super.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

