/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import util.RecordList;
import util.RecordListSet;

public class UserPrivilege {
    private int g_User_seq = -1;
    private RecordList g_Items = null;
    public static String USER_PRIVILEGE_SEQ = "user_privilege_seq";
    public static String USER_SEQ = "user_seq";
    public static String MEMBER_GROUP_SEQ = "member_group_seq";
    public static String PRIVILEGE = "privilege";

    public UserPrivilege(int user_seq) {
        this.g_User_seq = user_seq;
        DBConn conn = new DBConn();
        this.g_Items = UserPrivilege.load(this.g_User_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int user_seq, DBConn conn) {
        String sql = "select * from user_privilege where user_seq=?";
        return DBUtil.run("select * from user_privilege where user_seq=?", user_seq);
    }

    public static void update(int user_seq, RecordList items, DBConn conn) {
        RecordList old_items = UserPrivilege.load(user_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{USER_PRIVILEGE_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int seq = r.getI(USER_PRIVILEGE_SEQ, i);
            UserPrivilege.delete(seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            UserPrivilege.update(items, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            UserPrivilege.insert(items, user_seq, i, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int user_seq, int i, DBConn conn) {
        String sql = "insert into user_privilege( user_privilege_seq,user_seq,member_group_seq,privilege)values(?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(USER_PRIVILEGE_SEQ, conn), new Integer(user_seq), items.getInteger(MEMBER_GROUP_SEQ), items.getS(PRIVILEGE)};
        DBUtil.run("insert into user_privilege( user_privilege_seq,user_seq,member_group_seq,privilege)values(?,?,?,?)", pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update user_privilege set user_seq=?,member_group_seq=?,privilege=? where user_privilege_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getInteger(USER_SEQ), items.getInteger(MEMBER_GROUP_SEQ), items.getS(PRIVILEGE), items.getInteger(USER_PRIVILEGE_SEQ)};
        DBUtil.run("update user_privilege set user_seq=?,member_group_seq=?,privilege=? where user_privilege_seq=?", pvs, conn);
    }

    private static void delete(int seq, DBConn conn) {
        String sql = "delete from user_privilege where user_privilege_seq=?";
        DBUtil.run("delete from user_privilege where user_privilege_seq=?", seq, conn);
    }
}

