/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import system.MasterCode;
import system.MasterGroup;
import system.User;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.Validation;
import util.WinUtil;

public class MasterCodeInfoDialog
extends JDialog {
    private JButton addB;
    private JButton saveB;
    private JButton cancelB;
    private ScrollList itemSL;
    private String g_Code_group = "";
    private ArrayList g_Codes;
    private boolean g_isUpdate = true;

    public MasterCodeInfoDialog(JDialog f, String code_group) {
        super(f, "\u4fee\u6539\u81ea\u5b9a\u9078\u9805", false);
        this.init(code_group);
    }

    private void init(String code_group) {
        this.g_Code_group = code_group;
        MasterCode p = new MasterCode(code_group);
        this.g_Codes = p.getCodes();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        String group_name = "";
        int i = 0;
        while (i < MasterGroup.ALL_GROUPS.length) {
            if (MasterGroup.ALL_GROUPS[i].equals(this.g_Code_group)) {
                group_name = MasterGroup.ALL_GROUP_NAMES[i];
            }
            ++i;
        }
        this.addB = new JButton("\u52a0\u5165\u9805\u76ee");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.addB.setEnabled(User.hasPrivilege("masterCodeModify"));
        this.saveB.setEnabled(User.hasPrivilege("masterCodeModify"));
        TableLayout t = new TableLayout(this, 400, 390, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 205;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30});
        JLabel jLabel = new JLabel("\u9078\u9805\u985e\u5225");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel(group_name);
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 2, 0, -1, 0);
        this.itemSL = new ScrollList(360, 250, this.g_Codes, new int[]{60, 65, 180, 65}, new String[]{"\u986f\u793a\u6b21\u5e8f", "\u9810\u8a2d\u9078\u53d6", "\u540d\u7a31", "\u751f\u6548\u4e2d"}, new String[]{MasterCode.DISPLAY_ORDER, MasterCode.DEFAULT_ITEM, MasterCode.NAME, MasterCode.STATUS}, new boolean[]{true, true, true, true});
        this.itemSL.setEditing_mode(true);
        this.itemSL.setCheckBoxYNColumn(MasterCode.DEFAULT_ITEM, "Y", "N");
        this.itemSL.setCheckBoxYNColumn(MasterCode.STATUS, "A", "D");
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{250});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, 0, 0);
        t.addYSpace(15);
        int[] nArray3 = new int[3];
        nArray3[0] = 250;
        nArray3[1] = 65;
        t.getClass();
        nArray3[2] = 0;
        t.addTable(nArray3, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private void setEventHandler() {
        this.addB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterCodeInfoDialog.this.onAddItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterCodeInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterCodeInfoDialog.this.onCancel(evt);
            }
        });
        this.itemSL.addActionListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                MasterCodeInfoDialog.this.onTableChanged(e);
            }
        });
    }

    private void onAddItem(ActionEvent evt) {
        this.addNewItem();
    }

    private void addNewItem() {
        ArrayList v = this.itemSL.getTableData();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put(MasterCode.CODE, "");
        h.put(MasterCode.NAME, "");
        h.put(MasterCode.DISPLAY_ORDER, new Integer(MasterCode.getMaxDisplaySeq(this.g_Code_group) + 1));
        h.put(MasterCode.DEFAULT_ITEM, "N");
        h.put(MasterCode.STATUS, "A");
        v.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onTableChanged(TableModelEvent e) {
        if (this.itemSL.getChangedColName(e).equals(MasterCode.DEFAULT_ITEM)) {
            ArrayList v = this.itemSL.getTableData();
            String default_item = ArrayUtil.getString(MasterCode.DEFAULT_ITEM, e.getFirstRow(), v);
            if (default_item.equals("Y")) {
                int i = 0;
                while (i < v.size()) {
                    if (i != e.getFirstRow()) {
                        ArrayUtil.setString(MasterCode.DEFAULT_ITEM, "N", i, v);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        ArrayList codes = this.itemSL.getTableData();
        int i = 0;
        while (i < codes.size()) {
            int display_order = ArrayUtil.getInt(MasterCode.DISPLAY_ORDER, i, codes);
            String name = ArrayUtil.getString(MasterCode.NAME, i, codes);
            validation.add(display_order, "\u7b2c" + (i + 1) + "\u9805\u7684\u986f\u793a\u6b21\u5e8f", "I,GTZ");
            validation.add(name, "\u7b2c" + (i + 1) + "\u9805\u7684\u540d\u7a31", "R");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        MasterCode.update(this.g_Code_group, codes);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

