/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import mainapp.MainFrame;
import system.Config;
import system.Constants;
import system.User;
import ui.TableLayout;
import util.Validation;

public class LoginDialog
extends JDialog {
    private JTextField login_idTF;
    private JPasswordField passwordTF;
    private JButton loginB;
    private JButton cancelB;

    public LoginDialog(Frame frame) {
        super(frame, "\u767b\u5165", true);
        this.setLayout();
        this.setEventHandler();
        if (Constants.DB_VERSION_USE != Config.getI(Config.dbVersion)) {
            JOptionPane.showMessageDialog(null, "\u7a0b\u5f0f\u6240\u9700\u7528\u8cc7\u6599\u5eab\u7248\u672c:" + Constants.DB_VERSION_USE + " \u8207\u73fe\u5b58\u8cc7\u6599\u5eab\u7248\u672c:" + Config.getI(Config.dbVersion) + " \u4e0d\u7b26\u5408,\u7a0b\u5f0f\u7d42\u6b62.");
            System.exit(0);
        } else {
            this.setShow();
        }
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 250, 180, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.addTable(nArray, new int[]{30, 30});
        this.login_idTF = new JTextField();
        this.passwordTF = new JPasswordField();
        JLabel jLabel = new JLabel("\u767b\u5165\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.login_idTF, 1, 0, 20, 0, 120, -1);
        JLabel jLabel2 = new JLabel("\u5bc6\u78bc");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.passwordTF, 1, 1, 20, 0, 120, -1);
        t.addYSpace(10);
        t.addTable(new int[]{100, 20, 80}, new int[]{20});
        this.loginB = new JButton("\u767b\u5165");
        this.cancelB = new JButton("\u53d6\u6d88");
        t.addCell(this.loginB, 0, 0, 1, 10);
        t.addCell(this.cancelB, 2, 0, -1, 10);
    }

    public void setEventHandler() {
        this.loginB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.onLogin(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.onCancel(evt);
            }
        });
    }

    public void onLogin(ActionEvent evt) {
        String login_id = this.login_idTF.getText();
        String password = new String(this.passwordTF.getPassword());
        Validation validation = new Validation();
        validation.add(login_id, "\u767b\u5165\u7de8\u865f", "R");
        validation.add(password, "\u5bc6\u78bc", "R");
        if (!validation.isValid()) {
            return;
        }
        if (User.login(login_id, password)) {
            MainFrame.initMainFrame();
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "\u767b\u5165\u7de8\u865f/\u5bc6\u78bc\u932f\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\u3002");
        }
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    public void setShow() {
        if (!Constants.LOGIN_ID.equals("")) {
            if (User.login(Constants.LOGIN_ID, Constants.PASSWORD)) {
                MainFrame.initMainFrame();
            } else {
                JOptionPane.showMessageDialog(null, "\u767b\u5165\u7de8\u865f/\u5bc6\u78bc\u932f\u8aa4\uff0c\u8acb\u91cd\u65b0\u8f38\u5165\u3002");
                this.setVisible(true);
            }
        } else {
            this.setVisible(true);
        }
    }
}

