/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import util.RecordList;
import util.Tools;

public class Config {
    public static String adminPwd = "adminPwd";
    public static String churchName = "churchName";
    public static String memberIdFormat = "memberIdFormat";
    public static String memberIdCheckDigit = "memberIdCheckDigit";
    public static String venueStartTime = "venueStartTime";
    public static String venueEndTime = "venueEndTime";
    public static String venueRequestApproval = "venueRequestApproval";
    public static String companyName = "companyName";
    public static String receiptIdFormat = "receiptIdFormat";
    public static String voucherIdFormat = "voucherIdFormat";
    public static String startAcPeriod = "startAcPeriod";
    public static String currencyCode = "currencyCode";
    public static String dbVersion = "dbVersion";
    public static String dbFix = "dbFix";
    public static String dbUpdateDate = "dbUpdateDate";

    public static int getI(String name) {
        String sql = "select i from config where name=?";
        RecordList r = DBUtil.run("select i from config where name=?", name);
        if (r.isEmpty()) {
            Tools.writeError("Config: no config name: " + name);
            return -1;
        }
        return r.getI("i", 0);
    }

    public static String getS(String name) {
        String sql = "select s from config where name=?";
        RecordList r = DBUtil.run("select s from config where name=?", name);
        if (r.isEmpty()) {
            Tools.writeError("Config: no config name: " + name);
            return "";
        }
        return r.getS("s", 0);
    }

    public static double getD(String name) {
        String sql = "select d from config where name=?";
        RecordList r = DBUtil.run("select d from config where name=?", name);
        if (r.isEmpty()) {
            Tools.writeError("Config: no config name: " + name);
            return -1.0;
        }
        return r.getD("d", 0);
    }

    public static Timestamp getT(String name) {
        String sql = "select t from config where name=?";
        RecordList r = DBUtil.run("select t from config where name=?", name);
        if (r.isEmpty()) {
            Tools.writeError("Config: no config name: " + name);
            return null;
        }
        return r.getT("t", 0);
    }

    public static void setI(String name, int value) {
        String sql = "update config set i=? where name=?";
        if (Config.exist(name)) {
            DBUtil.run("update config set i=? where name=?", new Object[]{new Integer(value), name});
        }
    }

    public static void setS(String name, String value) {
        String sql = "update config set s=? where name=?";
        if (Config.exist(name)) {
            DBUtil.run("update config set s=? where name=?", new Object[]{value, name});
        }
    }

    public static void setD(String name, double value) {
        String sql = "update config set d=? where name=?";
        if (Config.exist(name)) {
            DBUtil.run("update config set d=? where name=?", new Object[]{new BigDecimal(value), name});
        }
    }

    public static void setT(String name, Timestamp value) {
        String sql = "update config set t=? where name=?";
        if (Config.exist(name)) {
            DBUtil.run("update config set t=? where name=?", new Object[]{value, name});
        }
    }

    public static boolean exist(String name) {
        String sql = "select * from config where name=?";
        RecordList r = DBUtil.run("select * from config where name=?", name);
        return !r.isEmpty();
    }
}

