/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import util.RecordList;
import util.RecordListSet;

public class MemberRemark {
    private int g_Member_seq = -1;
    private RecordList g_Items = null;
    public static String MEMBER_REMARK_SEQ = "member_remark_seq";
    public static String MEMBER_SEQ = "member_seq";
    public static String CODE = "code";
    public static String REMARK = "remark";

    public MemberRemark(int member_seq) {
        this.g_Member_seq = member_seq;
        DBConn conn = new DBConn();
        this.g_Items = MemberRemark.load(this.g_Member_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int member_seq, DBConn conn) {
        String sql = "select * from member_remark where member_seq=?";
        return DBUtil.run("select * from member_remark where member_seq=?", member_seq);
    }

    public static void update(int member_seq, RecordList items, DBConn conn) {
        RecordList old_items = MemberRemark.load(member_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{MEMBER_REMARK_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int seq = r.getI(MEMBER_REMARK_SEQ, i);
            MemberRemark.delete(seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            MemberRemark.update(items, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            MemberRemark.insert(items, member_seq, i, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int member_seq, int i, DBConn conn) {
        String sql = "insert into member_remark( member_remark_seq,member_seq,code,remark)values(?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(MEMBER_REMARK_SEQ, conn), new Integer(member_seq), items.getS(CODE), items.getS(REMARK)};
        DBUtil.run("insert into member_remark( member_remark_seq,member_seq,code,remark)values(?,?,?,?)", pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update member_remark set member_seq=?,code=?,remark=? where member_remark_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getInteger(MEMBER_SEQ), items.getS(CODE), items.getS(REMARK), items.getInteger(MEMBER_REMARK_SEQ)};
        DBUtil.run("update member_remark set member_seq=?,code=?,remark=? where member_remark_seq=?", pvs, conn);
    }

    private static void delete(int seq, DBConn conn) {
        String sql = "delete from member_remark where member_remark_seq=?";
        DBUtil.run("delete from member_remark where member_remark_seq=?", seq, conn);
    }
}

