/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import member.Member;
import member.MemberAttendanceListDialog;
import member.MemberCardPrintout;
import member.MemberGroupListDialog;
import member.MemberInfoDialog;
import member.MemberLabelPrintoutDialog;
import member.MemberReceiptListDialog;
import system.User;
import ui.ComboBoxCN;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.WinUtil;

public class MemberListDialog
extends JDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton attendanceB;
    private JButton receiptB;
    private JButton groupB;
    private JButton print_cardB;
    private JButton print_labelB;
    private JTextField member_idTF;
    private JTextField name_chiTF;
    private JTextField name_engTF;
    private ComboBoxCN fellowshipCN;
    private ComboBoxCN homeCN;
    private ScrollList listSL;
    private ArrayList g_List = Member.search("", "", "");

    public MemberListDialog(JFrame frame) {
        super(frame, "\u6703\u773e\u8cc7\u6599\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.member_idTF = new JTextField();
        this.name_chiTF = new JTextField();
        this.name_engTF = new JTextField();
        this.searchB = new JButton("\u641c\u5c0b");
        this.addB = new JButton("\u65b0\u589e");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.attendanceB = new JButton("\u51fa\u5e2d\u8a18\u9304");
        this.receiptB = new JButton("\u6536\u64da\u8a18\u9304");
        this.groupB = new JButton("\u8eab\u4efd\u8a18\u9304");
        this.print_cardB = new JButton("\u5217\u5370\u6703\u773e\u8b49");
        this.print_labelB = new JButton("\u5217\u5370\u6703\u773e\u6a19\u7c64");
        this.addB.setEnabled(User.hasPrivilege("memberModify"));
        this.receiptB.setEnabled(User.hasPrivilege("receiptRead"));
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        JLabel jLabel = new JLabel("\u4e2d\u6587\u59d3\u540d");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.name_chiTF, 1, 0, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel2 = new JLabel("\u82f1\u6587\u59d3\u540d");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.name_engTF, 1, 1, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.groupB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("\u6703\u773e\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_idTF, 1, 2, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.attendanceB, 2, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.print_cardB, 3, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.receiptB, 2, 3, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.print_labelB, 3, 3, -1, 0, 115, -1);
        boolean[] blArray = new boolean[4];
        blArray[3] = true;
        this.listSL = new ScrollList(560, 380, this.g_List, new int[]{160, 85, 265, 40}, new String[]{"\u6703\u773e\u7de8\u865f", "\u59d3\u540d(\u4e2d\u6587)", "\u59d3\u540d(\u82f1\u6587)", "\u9078\u53d6"}, new String[]{"member_id", "name_chi", "name_eng", "selected"}, blArray);
        this.listSL.setCheckBoxYNColumn("selected", "Y", "N");
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{380});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onModify(evt);
            }
        });
        this.attendanceB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewAttendance(evt);
            }
        });
        this.receiptB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewReceipt(evt);
            }
        });
        this.groupB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewGroup(evt);
            }
        });
        this.print_cardB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onPrintCard(evt);
            }
        });
        this.print_labelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onPrintLabel(evt);
            }
        });
        this.listSL.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MemberListDialog.this.onClickListHeader(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        ArrayList v = Member.search(this.member_idTF.getText(), this.name_chiTF.getText(), this.name_engTF.getText());
        this.listSL.refreshTable(v);
    }

    public void onAdd(ActionEvent evt) {
        MemberInfoDialog d = new MemberInfoDialog(this);
    }

    public void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberInfoDialog memberInfoDialog = new MemberInfoDialog(this, member_seq);
        }
    }

    public void onViewAttendance(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberAttendanceListDialog memberAttendanceListDialog = new MemberAttendanceListDialog(this, member_seq);
        }
    }

    public void onViewReceipt(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberReceiptListDialog memberReceiptListDialog = new MemberReceiptListDialog(this, member_seq);
        }
    }

    public void onViewGroup(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberGroupListDialog memberGroupListDialog = new MemberGroupListDialog(this, member_seq);
        }
    }

    public void onPrintCard(ActionEvent evt) {
        ArrayList<Integer> member_seqs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.listSL.getTableData().size()) {
            if (ArrayUtil.getString("SELECTED", i, this.listSL.getTableData()).equals("Y")) {
                int member_seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.listSL.getTableData());
                member_seqs.add(new Integer(member_seq));
            }
            ++i;
        }
        if (!member_seqs.isEmpty()) {
            JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
            MemberCardPrintout p = new MemberCardPrintout("", "", member_seqs);
            p.genFile();
            wait_dialog.dispose();
        } else {
            WinUtil.showMessage(this, "\u8acb\u5728\u9078\u53d6\u683c\u5167\u9078\u53d6\u6703\u773e");
        }
    }

    public void onPrintLabel(ActionEvent evt) {
        ArrayList<Integer> member_seqs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.listSL.getTableData().size()) {
            if (ArrayUtil.getString("SELECTED", i, this.listSL.getTableData()).equals("Y")) {
                int member_seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.listSL.getTableData());
                member_seqs.add(new Integer(member_seq));
            }
            ++i;
        }
        if (!member_seqs.isEmpty()) {
            MemberLabelPrintoutDialog d = new MemberLabelPrintoutDialog(this, member_seqs);
        } else {
            WinUtil.showMessage(this, "\u8acb\u5728\u9078\u53d6\u683c\u5167\u9078\u53d6\u6703\u773e");
        }
    }

    public void onClickListHeader(MouseEvent evt) {
        JTable table = ((JTableHeader)evt.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if (((ScrollList.TableModel)table.getModel()).getColumnKey(vColIndex).equals("SELECTED")) {
            ArrayList v = this.listSL.getTableData();
            int i = 0;
            while (i < v.size()) {
                ArrayUtil.setString("SELECTED", "Y", i, v);
                ++i;
            }
            this.listSL.refreshTable(v);
        }
    }
}

