/*
 * Decompiled with CFR 0.152.
 */
package member;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import member.Member;
import util.ArrayListCreator;
import util.ArrayUtil;
import util.Tools;

public class MemberLabelPrintout {
    private float g_MM2PT = 2.8346f;
    private float g_A4_width = 210.0f;
    private float g_A4_height = 297.0f;
    private ArrayList g_Member_info = null;
    private Properties g_Config = null;
    private String g_Output_file = "";
    private int g_Cellx;
    private int g_Celly;
    private int g_Copy;
    private String g_Direction;
    private boolean g_Use_border;
    private int g_EmptyCell;
    private boolean g_Use_test_border;
    private float g_Margin_top;
    private float g_Margin_bottom;

    public MemberLabelPrintout(String start_member_id, String end_member_id, ArrayList member_seqs, String cellx, String celly, String copy, String direction, String sorting, boolean use_border) {
        this.g_Member_info = Member.getMemberCardInfo(start_member_id, end_member_id, member_seqs, sorting);
        this.g_Output_file = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".pdf";
        this.g_Cellx = Integer.parseInt(cellx);
        this.g_Celly = Integer.parseInt(celly);
        this.g_Copy = Integer.parseInt(copy);
        this.g_Direction = direction;
        this.g_Use_border = use_border;
        this.g_Config = new Properties();
        try {
            this.g_Config.load(new FileInputStream("config/member_label_config.txt"));
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        this.g_EmptyCell = this.getIntFromConfig("empty_cell");
        this.g_Use_test_border = this.getBooleanFromConfig("use_test_border");
        this.g_Margin_top = this.getFloatFromConfig("margin_top");
        this.g_Margin_bottom = this.getFloatFromConfig("margin_bottom");
    }

    private int getIntFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    private float getFloatFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Float.valueOf(value).floatValue();
        }
        return 0.0f;
    }

    private String getStringFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return value;
        }
        return "";
    }

    private boolean getBooleanFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        return value != null && value.equals("Y");
    }

    public boolean genFile() {
        boolean border_size = false;
        boolean test_border_size = false;
        if (this.g_Use_test_border) {
            test_border_size = true;
        }
        if (this.g_Use_border) {
            border_size = true;
        }
        MemberLabelPrintout.addEmptyCell(this.g_Member_info, this.g_EmptyCell);
        this.g_Member_info = MemberLabelPrintout.dupCopy(this.g_Member_info, this.g_Copy);
        MemberLabelPrintout.padFullPage(this.g_Member_info, this.g_Cellx, this.g_Celly);
        if (this.g_Direction.equals("V")) {
            this.g_Member_info = MemberLabelPrintout.swapVertical(this.g_Member_info, this.g_Cellx, this.g_Celly);
        }
        if (this.g_Member_info.size() == 0) {
            return false;
        }
        Document document = new Document(PageSize.A4, 0.0f, 0.0f, this.g_Margin_top * this.g_MM2PT, this.g_Margin_bottom * this.g_MM2PT);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.g_Output_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            BaseFont bf = BaseFont.createFont((String)(String.valueOf(System.getenv("WINDIR")) + "/fonts/mingliu.ttc,0"), (String)"Identity-H", (boolean)true);
            BaseFont bf_eng = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfPTable page_table = new PdfPTable(this.g_Cellx);
            page_table.setTotalWidth(this.g_A4_width * this.g_MM2PT);
            page_table.setWidthPercentage(100.0f);
            page_table.setLockedWidth(true);
            page_table.getDefaultCell().setPadding(0.0f);
            int i = 0;
            while (i < this.g_Member_info.size()) {
                String member_id = ArrayUtil.getString("MEMBER_ID", i, this.g_Member_info);
                String name_eng = ArrayUtil.getString("NAME_ENG", i, this.g_Member_info);
                String name_chi = ArrayUtil.getString("NAME_CHI", i, this.g_Member_info);
                PdfPTable cell_table = new PdfPTable(1);
                cell_table.setTotalWidth(this.g_A4_width / (float)this.g_Cellx * this.g_MM2PT);
                cell_table.setWidthPercentage(100.0f);
                cell_table.setLockedWidth(true);
                cell_table.getDefaultCell().setPadding(0.0f);
                cell_table.getDefaultCell().setBorderWidth((float)test_border_size);
                PdfPCell name_chi_cell = new PdfPCell(new Phrase(name_chi, new Font(bf, 17.0f)));
                name_chi_cell.setFixedHeight(8.0f * this.g_MM2PT);
                name_chi_cell.setHorizontalAlignment(1);
                name_chi_cell.setVerticalAlignment(6);
                name_chi_cell.setBorderWidth((float)test_border_size);
                PdfPCell name_eng_cell = new PdfPCell(new Phrase(name_eng, new Font(bf_eng, 8.0f)));
                name_eng_cell.setFixedHeight(4.5f * this.g_MM2PT);
                name_eng_cell.setHorizontalAlignment(1);
                name_eng_cell.setBorderWidth((float)test_border_size);
                Barcode39 code = new Barcode39();
                code.setCode(member_id);
                code.setX(0.8f);
                code.setN(2.0f);
                code.setBarHeight(18.0f);
                code.setSize(0.0f);
                code.setFont(null);
                Color bar_color = member_id.equals("") ? Color.white : null;
                PdfPCell barcode_cell = new PdfPCell(code.createImageWithBarcode(cb, bar_color, null));
                barcode_cell.setFixedHeight(6.9f * this.g_MM2PT);
                barcode_cell.setPadding(0.0f);
                barcode_cell.setVerticalAlignment(6);
                barcode_cell.setHorizontalAlignment(1);
                barcode_cell.setBorderWidth((float)test_border_size);
                PdfPCell member_id_cell = new PdfPCell(new Phrase(member_id, FontFactory.getFont((String)"Helvetica", (float)9.0f)));
                member_id_cell.setFixedHeight(6.0f * this.g_MM2PT);
                member_id_cell.setHorizontalAlignment(1);
                member_id_cell.setPadding(0.0f);
                member_id_cell.setVerticalAlignment(4);
                member_id_cell.setBorderWidth((float)test_border_size);
                cell_table.addCell(name_chi_cell);
                cell_table.addCell(name_eng_cell);
                cell_table.addCell(barcode_cell);
                cell_table.addCell(member_id_cell);
                PdfPCell page_cell = new PdfPCell(cell_table);
                float page_cell_height = (this.g_A4_height - this.g_Margin_top - this.g_Margin_bottom) / (float)this.g_Celly;
                page_cell.setFixedHeight(page_cell_height * this.g_MM2PT);
                page_cell.setBorderWidth((float)border_size);
                page_cell.setVerticalAlignment(5);
                page_table.addCell(page_cell);
                ++i;
            }
            document.add((Element)page_table);
        }
        catch (DocumentException e1) {
            Tools.writeError(e1.getMessage());
        }
        catch (IOException e2) {
            Tools.writeError(e2.getMessage());
        }
        document.close();
        try {
            Runtime.getRuntime().exec("cmd.exe /c \"" + this.g_Output_file + "\"");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return true;
    }

    private static void addEmptyCell(ArrayList member_info, int empty_cell) {
        if (empty_cell == 0) {
            return;
        }
        ArrayListCreator ac = new ArrayListCreator(new String[]{"member_seq", "member_id", "name_chi", "name_eng"});
        int i = 0;
        while (i < empty_cell) {
            ac.add(new Object[]{new Integer(-1), "", "", ""});
            ++i;
        }
        member_info.addAll(0, ac.getArrayList());
    }

    private static ArrayList dupCopy(ArrayList member_info, int copy) {
        if (copy <= 1) {
            return member_info;
        }
        ArrayList<HashMap> v = new ArrayList<HashMap>();
        int member_size = member_info.size();
        int i = 0;
        while (i < member_size) {
            HashMap h = (HashMap)member_info.get(i);
            int j = 0;
            while (j < copy) {
                v.add(h);
                ++j;
            }
            ++i;
        }
        return v;
    }

    private static void padFullPage(ArrayList member_info, int cellx, int celly) {
        int cell_per_page = cellx * celly;
        int remain_cell = cell_per_page - member_info.size() % cell_per_page;
        if (remain_cell == cell_per_page) {
            return;
        }
        ArrayListCreator ac = new ArrayListCreator(new String[]{"member_seq", "member_id", "name_chi", "name_eng"});
        int i = 0;
        while (i < remain_cell) {
            ac.add(new Object[]{new Integer(-1), "", "", ""});
            ++i;
        }
        member_info.addAll(ac.getArrayList());
    }

    private static ArrayList swapVertical(ArrayList member_info, int cellx, int celly) {
        ArrayList v = (ArrayList)member_info.clone();
        int cell_per_page = cellx * celly;
        int total_page = member_info.size() / cell_per_page;
        int j = 0;
        while (j < total_page) {
            int i = 0;
            while (i < cell_per_page) {
                HashMap h = (HashMap)member_info.get(j * cell_per_page + i);
                int vertical_pos = j * cell_per_page + (cellx * (i % celly) + i / celly);
                v.set(vertical_pos, h);
                ++i;
            }
            ++j;
        }
        return v;
    }
}

