/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import member.MemberGroup;
import member.MemberGroupMember;
import member.MemberGroupSelectComboBox;
import ui.ScrollList;
import ui.TableLayout;
import util.RecordList;
import util.RecordListSet;
import util.Validation;

public class MemberGroupSelectDialog
extends JDialog {
    private RecordList gResultGroups;
    private RecordList gSelGroups;
    private RecordList gNonSelGroups;
    private RecordList gAllActiveGroups;
    private ScrollList selListSL;
    private ScrollList nonSelListSL;
    private JButton addB;
    private JButton delB;
    private JButton confirmB;
    private MemberGroupSelectComboBox parentCB;

    public MemberGroupSelectDialog(JDialog dialog, MemberGroupSelectComboBox parent, RecordList groups) {
        super(dialog, "\u9078\u53d6\u8eab\u4efd\u7fa4\u7d44", false);
        this.gResultGroups = groups;
        this.gAllActiveGroups = MemberGroup.getAllActiveGroups();
        this.gSelGroups = this.getSelGroups();
        this.gNonSelGroups = this.getNonSelGroups();
        this.parentCB = parent;
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.addB = new JButton("\u52a0\u5165");
        this.delB = new JButton("\u79fb\u9664");
        this.confirmB = new JButton("\u78ba\u5b9a");
        this.selListSL = new ScrollList(440, 150, this.gSelGroups, new int[]{415}, new String[]{"\u5df2\u9078\u7684\u7fa4\u7d44"}, new String[]{"path"}, new boolean[1]);
        this.nonSelListSL = new ScrollList(440, 150, this.gNonSelGroups, new int[]{415}, new String[]{"\u672a\u9078\u7684\u7fa4\u7d44"}, new String[]{"path"}, new boolean[1]);
        TableLayout t = new TableLayout(this, 480, 395, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 70;
        nArray[1] = 70;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{160, 30, 150});
        int row = 0;
        t.getClass();
        t.getClass();
        t.addCell(this.nonSelListSL, 0, row, -1, -1);
        ++row;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 0, row, -1, 0, 60, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.delB, 1, row, -1, 0, 60, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.confirmB, 2, row, 1, 0, 60, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.selListSL, 0, ++row, -1, -1);
    }

    public void setEventHandler() {
        this.addB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onAdd(evt);
            }
        });
        this.delB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onDel(evt);
            }
        });
        this.confirmB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onConfirm(evt);
            }
        });
    }

    public void onAdd(ActionEvent evt) {
        int selrow = this.nonSelListSL.getSelectedRow();
        if (selrow >= 0) {
            int mg_seq = this.gNonSelGroups.getI(MemberGroupMember.MEMBER_GROUP_SEQ, selrow);
            this.gNonSelGroups.remove(selrow);
            this.nonSelListSL.refreshTable(this.gNonSelGroups);
            this.gSelGroups.setI(MemberGroupMember.MEMBER_GROUP_SEQ, mg_seq, this.gSelGroups.size());
            this.formatGroups(this.gSelGroups);
            this.selListSL.refreshTable(this.gSelGroups);
        }
    }

    public void onDel(ActionEvent evt) {
        int selrow = this.selListSL.getSelectedRow();
        if (selrow >= 0) {
            int mg_seq = this.gSelGroups.getI(MemberGroupMember.MEMBER_GROUP_SEQ, selrow);
            this.gSelGroups.remove(selrow);
            this.selListSL.refreshTable(this.gSelGroups);
            this.gNonSelGroups.setI(MemberGroupMember.MEMBER_GROUP_SEQ, mg_seq, this.gNonSelGroups.size());
            this.formatGroups(this.gNonSelGroups);
            this.sortGroups(this.gNonSelGroups);
            this.nonSelListSL.refreshTable(this.gNonSelGroups);
        }
    }

    public void onConfirm(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(!this.gSelGroups.isEmpty(), "\u6700\u5c11\u9078\u53d6\u4e00\u500b\u7fa4\u7d44", "RT");
        if (!validation.isValid()) {
            return;
        }
        this.gResultGroups.clear();
        int i = 0;
        while (i < this.gSelGroups.size()) {
            this.gResultGroups.add(this.gSelGroups.get(i));
            ++i;
        }
        this.parentCB.refreshSelection();
        this.dispose();
    }

    private RecordList getSelGroups() {
        RecordListSet s = new RecordListSet(this.gAllActiveGroups, this.gResultGroups, new String[]{MemberGroupMember.MEMBER_GROUP_SEQ});
        RecordList r = s.getIntersectOfLeft();
        this.formatGroups(r);
        this.sortGroups(r);
        return r;
    }

    private RecordList getNonSelGroups() {
        RecordListSet s = new RecordListSet(this.gAllActiveGroups, this.gResultGroups, new String[]{MemberGroupMember.MEMBER_GROUP_SEQ});
        RecordList r = s.getLeftOnly();
        this.formatGroups(r);
        this.sortGroups(r);
        return r;
    }

    private void formatGroups(RecordList r) {
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("path", MemberGroup.getGroupPath(r.getI(MemberGroupMember.MEMBER_GROUP_SEQ)));
            ++i;
        }
    }

    private void sortGroups(RecordList r) {
        r.sort("path");
    }
}

