/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import member.MemberGroup;
import util.ComparableHashMap;
import util.RecordList;
import util.RecordListSet;
import util.TimeUtil;
import util.Tools;

public class MemberGroupMember {
    private int g_Member_group_seq = -1;
    private RecordList g_Items = null;
    public static String MEMBER_GROUP_MEMBER_SEQ = "member_group_member_seq";
    public static String MEMBER_GROUP_SEQ = "member_group_seq";
    public static String MEMBER_SEQ = "member_seq";
    public static String START_DATE = "start_date";
    public static String END_DATE = "end_date";
    public static String REMARK = "remark";

    public MemberGroupMember(int member_group_seq) {
        this.g_Member_group_seq = member_group_seq;
        DBConn conn = new DBConn();
        this.g_Items = MemberGroupMember.load(this.g_Member_group_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int member_group_seq, DBConn conn) {
        String sql = "select mb.name_chi,mgm.* from member_group_member mgm,member mb where mgm.member_seq=mb.member_seq and mgm.member_group_seq=?";
        return DBUtil.run("select mb.name_chi,mgm.* from member_group_member mgm,member mb where mgm.member_seq=mb.member_seq and mgm.member_group_seq=?", new Integer(member_group_seq));
    }

    public static void update(int member_group_seq, RecordList items) {
        DBConn conn = new DBConn();
        RecordList oldItems = MemberGroupMember.load(member_group_seq, conn);
        RecordListSet set = new RecordListSet(oldItems, items, new String[]{MEMBER_GROUP_MEMBER_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            MemberGroupMember.delete(r, i, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            MemberGroupMember.update(r, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            MemberGroupMember.insert(r, i, conn);
            ++i;
        }
        conn.commit();
    }

    public static void insert(RecordList items, int i, DBConn conn) {
        String sql = "insert into member_group_member( member_group_member_seq,member_group_seq,member_seq,start_date,end_date,remark)values(?,?,?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(MEMBER_GROUP_MEMBER_SEQ, conn), items.getInteger(MEMBER_GROUP_SEQ), items.getInteger(MEMBER_SEQ), items.getT(START_DATE), items.getT(END_DATE), items.getS(REMARK)};
        DBUtil.run("insert into member_group_member( member_group_member_seq,member_group_seq,member_seq,start_date,end_date,remark)values(?,?,?,?,?,?)", pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update member_group_member set member_group_seq=?,member_seq=?,start_date=?,end_date=?,remark=? where member_group_member_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getInteger(MEMBER_GROUP_SEQ), items.getInteger(MEMBER_SEQ), items.getT(START_DATE), items.getT(END_DATE), items.getS(REMARK), items.getInteger(MEMBER_GROUP_MEMBER_SEQ)};
        DBUtil.run("update member_group_member set member_group_seq=?,member_seq=?,start_date=?,end_date=?,remark=? where member_group_member_seq=?", pvs, conn);
    }

    private static void delete(RecordList items, int i, DBConn conn) {
        String sql = "delete from member_group_member where member_group_member_seq=?";
        Object[] pvs = new Object[]{items.getInteger(MEMBER_GROUP_MEMBER_SEQ, i)};
        DBUtil.run("delete from member_group_member where member_group_member_seq=?", pvs, conn);
    }

    public static RecordList getMemberInParentGroup(int member_group_seq, String name_chi, String name_eng, String member_id) {
        MemberGroup mg = new MemberGroup(member_group_seq);
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(member_id) like lower(?)", "lower(name_chi) like lower(?)", "lower(name_eng) like lower(?)"}, new String[]{Tools.pad(member_id), Tools.pad(name_chi), Tools.pad(name_eng)});
        String sql = "select member_seq,name_chi,name_eng,member_id,'N' as selected from member where member_seq in(  select member_seq from member_group_member mgm where member_group_seq=" + mg.getParent_group_seq() + " )" + clause.getConds() + " order by name_chi";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static int getGroupMemberNum(int member_group_seq, boolean isActive) {
        String sql = "select count(*) as total from member_group_member where member_group_seq=?" + (isActive ? " and end_date>=curdate()" : "");
        RecordList r = DBUtil.run(sql, new Integer(member_group_seq));
        return r.getI("total", 0);
    }

    public static ComparableHashMap createMemberHashMap(int member_group_seq, int member_seq, Timestamp start_date, Timestamp end_date) {
        ComparableHashMap h = new ComparableHashMap();
        h.put(MEMBER_GROUP_MEMBER_SEQ, new Integer(-1));
        h.put(MEMBER_GROUP_SEQ, new Integer(member_group_seq));
        h.put(MEMBER_SEQ, new Integer(member_seq));
        h.put(START_DATE, start_date);
        h.put(END_DATE, end_date);
        h.put(REMARK, "");
        return h;
    }

    public static void markExpired(RecordList items) {
        MemberGroupMember.setExpiredCol(items);
        items.sort("expired,name_chi");
    }

    public static void setExpiredCol(RecordList items) {
        Timestamp curdate = TimeUtil.getCurrentDate();
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            Timestamp end_date = items.getT("end_date");
            if (curdate.before(TimeUtil.adjustDate(end_date, 1))) {
                items.setS("expired", "N");
            } else {
                items.setS("expired", "Y");
            }
            ++i;
        }
    }

    public static RecordList getMemberAllGroup(int member_seq) {
        String sql = "select * from member_group_member where member_seq=?";
        RecordList r = DBUtil.run("select * from member_group_member where member_seq=?", member_seq);
        MemberGroupMember.setExpiredCol(r);
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("path", MemberGroup.getGroupPath(r.getI(MEMBER_GROUP_SEQ)));
            ++i;
        }
        r.sort("expired,path");
        return r;
    }

    public static RecordList getActiveMembersInGroup(int member_group_seq, int member_seq) {
        String sql = "select  member_seq ,name_eng||' '||name_chi||' ('||member_id||')' as list_item ,name_eng||' '||name_chi as name ,name_eng ,name_chi from member_group_member mgm,member mb where mgm.member_seq=mb.member_seq and mgm.member_group_seq=? and  (  (start_date<=curdate() and end_date>=curdate())  or  member_seq=? ) ";
        return DBUtil.run("select  member_seq ,name_eng||' '||name_chi||' ('||member_id||')' as list_item ,name_eng||' '||name_chi as name ,name_eng ,name_chi from member_group_member mgm,member mb where mgm.member_seq=mb.member_seq and mgm.member_group_seq=? and  (  (start_date<=curdate() and end_date>=curdate())  or  member_seq=? ) ", new Integer[]{new Integer(member_group_seq), new Integer(member_seq)});
    }
}

