/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import java.sql.Timestamp;
import member.MemberGroupPrivilege;
import util.RecordList;

public class MemberGroup {
    private int g_Member_group_seq = -1;
    private int g_Parent_group_seq = -1;
    private String g_Name = "";
    private Timestamp g_Start_date = null;
    private Timestamp g_End_date = null;
    private int g_Display_seq = -1;
    public static int ROOT_GROUP_SEQ = 1;

    public MemberGroup() {
    }

    public MemberGroup(int member_group_seq) {
        this.g_Member_group_seq = member_group_seq;
        this.load(null);
    }

    public MemberGroup(int member_group_seq, DBConn conn) {
        this.g_Member_group_seq = member_group_seq;
        this.load(conn);
    }

    public int getMember_group_seq() {
        return this.g_Member_group_seq;
    }

    public int getParent_group_seq() {
        return this.g_Parent_group_seq;
    }

    public String getName() {
        return this.g_Name;
    }

    public Timestamp getStart_date() {
        return this.g_Start_date;
    }

    public Timestamp getEnd_date() {
        return this.g_End_date;
    }

    public int getDisplay_seq() {
        return this.g_Display_seq;
    }

    private void load(DBConn conn) {
        String sql = "select * from member_group where member_group_seq=?";
        RecordList r = DBUtil.run("select * from member_group where member_group_seq=?", new Integer(this.g_Member_group_seq), conn);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Parent_group_seq = r.getI("parent_group_seq");
            this.g_Name = r.getS("name");
            this.g_Start_date = r.getT("start_date");
            this.g_End_date = r.getT("end_date");
            this.g_Display_seq = r.getI("display_seq");
        }
    }

    public static int insert(int parent_group_seq, String name, Timestamp start_date, Timestamp end_date) {
        String sql = "insert into member_group( member_group_seq,parent_group_seq,name,start_date,end_date,display_seq)values(?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int member_group_seq = DBUtil.getNextValueFor("member_group_seq", conn);
        String sql2 = "select max(display_seq) as display_seq from member_group where parent_group_seq=" + parent_group_seq;
        RecordList r = DBUtil.run(sql2, new Object[0], conn);
        int maxDisplaySeq = r.getI("display_seq", 0);
        if (maxDisplaySeq == -1) {
            maxDisplaySeq = 0;
        }
        Object[] pvs = new Object[]{new Integer(member_group_seq), new Integer(parent_group_seq), name, start_date, end_date, new Integer(maxDisplaySeq + 10)};
        DBUtil.run("insert into member_group( member_group_seq,parent_group_seq,name,start_date,end_date,display_seq)values(?,?,?,?,?,?)", pvs, conn);
        MemberGroupPrivilege.updateGroupPrivilege(member_group_seq, parent_group_seq, conn);
        conn.commit();
        return conn.isSuccessful() ? member_group_seq : -1;
    }

    public static int update(int member_group_seq, String name, Timestamp start_date, Timestamp end_date, int display_seq) {
        String sql = "update member_group set name=?,start_date=?,end_date=?,display_seq=? where member_group_seq=?";
        Object[] pvs = new Object[]{name, start_date, end_date, new Integer(display_seq), new Integer(member_group_seq)};
        DBConn conn = new DBConn();
        DBUtil.run("update member_group set name=?,start_date=?,end_date=?,display_seq=? where member_group_seq=?", pvs, conn);
        conn.commit();
        return conn.isSuccessful() ? member_group_seq : -1;
    }

    public static RecordList getRootGroup() {
        String sql = "select * from member_group where member_group_seq=0";
        return DBUtil.run("select * from member_group where member_group_seq=0");
    }

    public static RecordList getAllGroups() {
        String sql = "select * from member_group";
        return DBUtil.run("select * from member_group");
    }

    public static RecordList getAllActiveGroups() {
        String sql = "select * from member_group where start_date<=curdate() and end_date>=curdate()";
        return DBUtil.run("select * from member_group where start_date<=curdate() and end_date>=curdate()");
    }

    public static RecordList getChildGroups(int member_group_seq, DBConn conn) {
        String sql = "select * from member_group where parent_group_seq=?";
        return DBUtil.run("select * from member_group where parent_group_seq=?", member_group_seq, conn);
    }

    public static String getGroupPath(int member_group_seq) {
        String sql = "select * from member_group order by start_date";
        RecordList r = DBUtil.run("select * from member_group order by start_date");
        int k = r.indexOf("member_group_seq", member_group_seq);
        if (k == -1) {
            return "";
        }
        int pg_seq = r.getI("parent_group_seq", k);
        StringBuffer name = new StringBuffer(r.getS("name", k));
        block0: while (pg_seq != -1) {
            int i = 0;
            while (i < r.size()) {
                int mg_seq = r.getI("member_group_seq", i);
                if (mg_seq == pg_seq) {
                    name = name.insert(0, ">");
                    name = name.insert(0, r.getS("name", i));
                    pg_seq = r.getI("parent_group_seq", i);
                    continue block0;
                }
                ++i;
            }
        }
        return name.toString();
    }

    public static String getOneNameStringOfGroups(RecordList member_groups) {
        String name = "";
        int i = 0;
        while (i < member_groups.size()) {
            MemberGroup mg = new MemberGroup(member_groups.getI("member_group_seq", i));
            name = String.valueOf(name) + mg.getName();
            if (i != member_groups.size() - 1) {
                name = String.valueOf(name) + ",";
            }
            ++i;
        }
        return name;
    }
}

