/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import member.MemberGroup;
import member.MemberGroupMember;
import member.MemberRemark;
import system.UserSession;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Member {
    private int g_Member_seq = -1;
    private String g_Member_id = "";
    private String g_Name_chi = "";
    private String g_Name_eng = "";
    private String g_Hkid = "";
    private String g_Gender = "";
    private Timestamp g_Dob = null;
    private String g_Address = "";
    private String g_Tel1 = "";
    private String g_Tel2 = "";
    private String g_Email = "";
    private String g_Career = "";
    private String g_Education = "";
    private String g_Hobby = "";
    private String g_Marital_status = "";
    private Timestamp g_Baptist_date = null;
    private Timestamp g_Church_join_date = null;
    private String g_Login_id = "";
    private String g_Password = "";

    public Member() {
    }

    public Member(int member_seq) {
        this.g_Member_seq = member_seq;
        this.load();
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public String getMember_id() {
        return this.g_Member_id;
    }

    public String getName_chi() {
        return this.g_Name_chi;
    }

    public String getName_eng() {
        return this.g_Name_eng;
    }

    public String getHkid() {
        return this.g_Hkid;
    }

    public String getGender() {
        return this.g_Gender;
    }

    public Timestamp getDob() {
        return this.g_Dob;
    }

    public String getAddress() {
        return this.g_Address;
    }

    public String getTel1() {
        return this.g_Tel1;
    }

    public String getTel2() {
        return this.g_Tel2;
    }

    public String getEmail() {
        return this.g_Email;
    }

    public String getCareer() {
        return this.g_Career;
    }

    public String getEducation() {
        return this.g_Education;
    }

    public String getHobby() {
        return this.g_Hobby;
    }

    public String getMarital_status() {
        return this.g_Marital_status;
    }

    public Timestamp getBaptist_date() {
        return this.g_Baptist_date;
    }

    public Timestamp getChurch_join_date() {
        return this.g_Church_join_date;
    }

    public String getLogin_id() {
        return this.g_Login_id;
    }

    public String getPassword() {
        return this.g_Password;
    }

    private void load() {
        String sql = "select * from member where member_seq=?";
        RecordList r = DBUtil.run("select * from member where member_seq=?", this.g_Member_seq);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Member_id = r.getS("member_id");
            this.g_Name_chi = r.getS("name_chi");
            this.g_Name_eng = r.getS("name_eng");
            this.g_Hkid = r.getS("hkid");
            this.g_Gender = r.getS("gender");
            this.g_Dob = r.getT("dob");
            this.g_Address = r.getS("address");
            this.g_Tel1 = r.getS("tel1");
            this.g_Tel2 = r.getS("tel2");
            this.g_Email = r.getS("email");
            this.g_Career = r.getS("career");
            this.g_Education = r.getS("education");
            this.g_Hobby = r.getS("hobby");
            this.g_Marital_status = r.getS("marital_status");
            this.g_Baptist_date = r.getT("baptist_date");
            this.g_Church_join_date = r.getT("church_join_date");
            this.g_Login_id = r.getS("login_id");
            this.g_Password = r.getS("password");
        }
    }

    public static int insert(String member_id, String name_chi, String name_eng, String hkid, String gender, Timestamp dob, String address, String tel1, String tel2, String email, String career, String education, String hobby, String marital_status, Timestamp baptist_date, Timestamp church_join_date, String new_photo_path, String login_id, String password, RecordList remarks) {
        String sql = "insert into member( member_seq,member_id,name_chi,name_eng,hkid,gender,dob,address,tel1,tel2,email,career,education,hobby,marital_status,baptist_date,church_join_date,login_id)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int member_seq = -1;
        member_seq = DBUtil.getNextValueFor("member_seq", conn);
        if (!new_photo_path.equals("")) {
            String photo_location = "image/member_photo/" + member_seq + ".jpg";
            Tools.copyFile(new_photo_path, photo_location);
        }
        DBUtil.run("insert into member( member_seq,member_id,name_chi,name_eng,hkid,gender,dob,address,tel1,tel2,email,career,education,hobby,marital_status,baptist_date,church_join_date,login_id)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{new Integer(member_seq), member_id, name_chi, name_eng, hkid, gender, dob, address, tel1, tel2, email, career, education, hobby, marital_status, baptist_date, church_join_date, login_id}, conn);
        Member.updatePassword(member_seq, password, conn);
        MemberRemark.update(member_seq, remarks, conn);
        MemberGroup mg = new MemberGroup(MemberGroup.ROOT_GROUP_SEQ, conn);
        RecordList r = new RecordList();
        r.add(MemberGroupMember.createMemberHashMap(MemberGroup.ROOT_GROUP_SEQ, member_seq, TimeUtil.getCurrentDate(), mg.getEnd_date()));
        MemberGroupMember.insert(r, 0, conn);
        conn.commit();
        return conn.isSuccessful() ? member_seq : -1;
    }

    public static int update(int member_seq, String member_id, String name_chi, String name_eng, String hkid, String gender, Timestamp dob, String address, String tel1, String tel2, String email, String career, String education, String hobby, String marital_status, Timestamp baptist_date, Timestamp church_join_date, String new_photo_path, String login_id, String password, RecordList remarks) {
        String sql = "update member set member_id=?,name_chi=?,name_eng=?,hkid=?,gender=?,dob=?,address=?,tel1=?,tel2=?,email=?,career=?,education=?,hobby=?,marital_status=?,baptist_date=?,church_join_date=?,login_id=? where member_seq=?";
        DBConn conn = new DBConn();
        if (!new_photo_path.equals("")) {
            String photo_location = "image/member_photo/" + member_seq + ".jpg";
            Tools.copyFile(new_photo_path, photo_location);
        }
        DBUtil.run("update member set member_id=?,name_chi=?,name_eng=?,hkid=?,gender=?,dob=?,address=?,tel1=?,tel2=?,email=?,career=?,education=?,hobby=?,marital_status=?,baptist_date=?,church_join_date=?,login_id=? where member_seq=?", new Object[]{member_id, name_chi, name_eng, hkid, gender, dob, address, tel1, tel2, email, career, education, hobby, marital_status, baptist_date, church_join_date, login_id, new Integer(member_seq)}, conn);
        Member.updatePassword(member_seq, password, conn);
        MemberRemark.update(member_seq, remarks, conn);
        conn.commit();
        return conn.isSuccessful() ? member_seq : -1;
    }

    public static void updatePassword(int member_seq, String password, DBConn conn) {
        if (password.equals("")) {
            return;
        }
        String sql = "update member set PASSWORD=? where MEMBER_SEQ=?";
        DBUtil.run("update member set PASSWORD=? where MEMBER_SEQ=?", new Object[]{Tools.md5(password), new Integer(member_seq)}, conn);
    }

    public static ArrayList search(String member_id, String name_chi, String name_eng) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(mb.member_id) like lower(?)", "lower(mb.name_chi) like lower(?)", "lower(mb.name_eng) like lower(?)"}, new String[]{Tools.pad(member_id), Tools.pad(name_chi), Tools.pad(name_eng)});
        String sql = "select distinct mb.member_seq,mb.member_id,mb.name_chi,mb.name_eng,'n' as selected from member mb,member_group_member mgm,user_privilege_vw upv where mb.member_seq=mgm.member_seq and mgm.member_group_seq=upv.member_group_seq and upv.privilege='memberRead' and upv.user_seq=" + UserSession.getLoginUserSeq() + clause.getConds() + " order by mb.member_seq";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static RecordList getMemberCardInfo(String start_member_id, String end_member_id, ArrayList member_seqs, String sorting) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"member_id>=?", "member_id<=?", "1=? and member_seq in" + DBUtil.getSQLInValues(member_seqs)}, new Object[]{start_member_id, end_member_id, !member_seqs.isEmpty() ? new Integer(1) : new Integer(-1)});
        String sql = "select member_seq,member_id,name_chi,name_eng from member" + clause.getConds() + (sorting.equals("") ? "" : "order by " + sorting);
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static ArrayList getAllActiveMembers(int member_seq) {
        String sql = "select member_seq,name_eng||' '||name_chi||' ('||member_id||')' as list_item,name_eng||' '||name_chi as name,name_eng,name_chi from member where status='A' or member_seq=? order by name_eng";
        return DBUtil.run("select member_seq,name_eng||' '||name_chi||' ('||member_id||')' as list_item,name_eng||' '||name_chi as name,name_eng,name_chi from member where status='A' or member_seq=? order by name_eng", member_seq);
    }

    public static int getMemberSeq(String member_id) {
        String sql = "select member_seq from member where lower(member_id)=lower(?)";
        RecordList r = DBUtil.run("select member_seq from member where lower(member_id)=lower(?)", member_id);
        return !r.isEmpty() ? r.getI("member_seq", 0) : -1;
    }

    public static boolean isIdAllowed(int member_seq, String newId) {
        String sql = "select 1 from member where member_seq<>? and(  lower(member_id)=lower(?)  or lower(login_id)=lower(?) )";
        RecordList r = DBUtil.run("select 1 from member where member_seq<>? and(  lower(member_id)=lower(?)  or lower(login_id)=lower(?) )", new Object[]{new Integer(member_seq), newId, newId});
        if (!r.isEmpty()) {
            return false;
        }
        return !newId.equals("admin");
    }
}

