/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBConn;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import snaq.db.ConnectionPool;
import system.Constants;
import util.RecordList;
import util.Tools;

public class DBUtil {
    private static ConnectionPool gConnPool;
    private static boolean isDebugConnPool;

    static {
        isDebugConnPool = false;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        String url = "";
        url = Constants.DB_TYPE.equals("network") ? "jdbc:hsqldb:hsql://" + Constants.DB_PATH + "/acts" : "jdbc:hsqldb:file:" + Constants.DB_PATH + "/acts";
        gConnPool = new ConnectionPool("local", 8, 30, 180000L, url, "sa", "");
        if (isDebugConnPool) {
            gConnPool.setDebug(true);
            gConnPool.setLog(System.out);
        }
    }

    public static ConnectionPool getConnPool() {
        return gConnPool;
    }

    public static RecordList run(String sql) {
        return DBUtil.run(sql, null, null);
    }

    public static RecordList run(String sql, int pv) {
        return DBUtil.run(sql, new Object[]{new Integer(pv)}, null);
    }

    public static RecordList run(String sql, int pv, DBConn conn) {
        return DBUtil.run(sql, new Object[]{new Integer(pv)}, conn);
    }

    public static RecordList run(String sql, DBConn conn) {
        return DBUtil.run(sql, null, conn);
    }

    public static RecordList run(String sql, Object pv) {
        return DBUtil.run(sql, new Object[]{pv}, null);
    }

    public static RecordList run(String sql, Object[] pvs) {
        return DBUtil.run(sql, pvs, null);
    }

    /*
     * Unable to fully structure code
     */
    public static RecordList run(String sql, Object[] pvs, DBConn conn) {
        block8: {
            block9: {
                is_single_query = false;
                if (conn == null) {
                    is_single_query = true;
                    conn = new DBConn(is_single_query);
                }
                if (!conn.isRunnable()) {
                    Tools.writeException("The connection is not runnable(rollbacked or not ever begin)");
                    return new RecordList();
                }
                try {
                    stat = conn.getConn().prepareStatement(sql);
                    DBUtil.setPrepareValue(stat, sql, pvs);
                    if (sql.startsWith("select")) {
                        rs = stat.executeQuery();
                        r = DBUtil.toRecordList(rs);
                    } else {
                        stat.executeUpdate();
                        r = new RecordList();
                    }
                    break block8;
                }
                catch (Exception e) {
                    conn.rollback();
                    Tools.writeError(e);
                    Tools.writeError("error sql[ " + sql + " ]");
                    if (pvs == null) break block9;
                    val = "";
                    i = 0;
                    ** while (i < pvs.length)
                }
lbl-1000:
                // 1 sources

                {
                    val = String.valueOf(val) + pvs[i].toString() + (i == pvs.length - 1 ? "" : ",");
                    ++i;
                    continue;
                }
lbl30:
                // 1 sources

                Tools.writeError("prepared values[ " + val + " ]");
            }
            r = new RecordList();
        }
        if (is_single_query) {
            conn.commit();
        }
        return r;
    }

    private static void setPrepareValue(PreparedStatement stat, String sql, Object[] pvs) throws SQLException {
        int count = 0;
        int i = 0;
        while (i < sql.length()) {
            char next = sql.charAt(i);
            if (next == '?') {
                ++count;
            }
            ++i;
        }
        if (pvs == null) {
            if (count != 0) {
                throw new SQLException("no. of ? and prepare values does not match in sql");
            }
            return;
        }
        if (count != pvs.length) {
            throw new SQLException("no. of ? and prepare values does not match in sql");
        }
        i = 0;
        while (i < pvs.length) {
            if (pvs[i] instanceof Integer) {
                stat.setInt(i + 1, (Integer)pvs[i]);
            } else if (pvs[i] instanceof BigDecimal) {
                stat.setBigDecimal(i + 1, (BigDecimal)pvs[i]);
            } else if (pvs[i] instanceof String) {
                if (pvs[i].equals("")) {
                    stat.setNull(i + 1, 0);
                } else {
                    stat.setString(i + 1, (String)pvs[i]);
                }
            } else if (pvs[i] instanceof Timestamp) {
                stat.setTimestamp(i + 1, (Timestamp)pvs[i]);
            } else {
                stat.setNull(i + 1, 0);
            }
            ++i;
        }
    }

    private static RecordList toRecordList(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        RecordList r = new RecordList();
        int row = 0;
        int count = rsmd.getColumnCount();
        while (rs.next()) {
            r.setCurrentRow(row);
            int i = 0;
            while (i < count) {
                String colName = rsmd.getColumnLabel(i + 1).toLowerCase();
                String colType = rsmd.getColumnTypeName(i + 1);
                if (colType.equals("INTEGER") || colType.equals("BIGINT")) {
                    rs.getInt(colName);
                    if (rs.wasNull()) {
                        r.setI(colName, -1);
                    } else {
                        r.setI(colName, rs.getInt(colName));
                    }
                } else if (colType.equals("DECIMAL")) {
                    if (rs.getBigDecimal(colName) == null) {
                        r.setD(colName, -1.0);
                    } else {
                        r.setD(colName, rs.getBigDecimal(colName).doubleValue());
                    }
                } else if (colType.equals("VARCHAR") || colType.equals("LONGVARCHAR") || colType.equals("CHARACTER")) {
                    if (rs.getString(colName) == null) {
                        r.setS(colName, "");
                    } else {
                        r.setS(colName, rs.getString(colName));
                    }
                } else if (colType.equals("TIMESTAMP")) {
                    r.setT(colName, rs.getTimestamp(colName));
                }
                ++i;
            }
            ++row;
        }
        return r;
    }

    public static String getSQLInValues(ArrayList values) {
        StringBuffer s = new StringBuffer();
        s.append(" (");
        int i = 0;
        while (i < values.size()) {
            if (!(values.get(i) instanceof Integer)) {
                s.append("'");
            }
            s.append(values.get(i).toString());
            if (!(values.get(i) instanceof Integer)) {
                s.append("'");
            }
            if (i != values.size() - 1) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    public static int getNextValueFor(String seq_name, DBConn conn) {
        seq_name = seq_name.toLowerCase();
        String sql = "select next value for " + seq_name + " as seq from dual";
        RecordList r = DBUtil.run(sql, conn);
        return r.getI("seq", 0);
    }

    public static int getCurValueFor(String seq_name, DBConn conn) {
        seq_name = seq_name.toUpperCase();
        String sql = "select next_value from information_schema.system_sequences where sequence_name=?";
        RecordList r = DBUtil.run(sql, new String[]{seq_name}, conn);
        String s = r.getS("next_value", 0);
        return Integer.parseInt(s);
    }

    public static void setValueFor(String seq_name, int value, DBConn conn) {
        seq_name = seq_name.toLowerCase();
        String sql = "alter sequence " + seq_name + " restart with " + value;
        DBUtil.run(sql, null, conn);
    }

    public static RecordList select(String[] a, int[] b, Object[] pvs, int[] c, String sql) {
        return DBUtil.run(sql, pvs);
    }

    public static RecordList select(String[] a, int[] b, Object[] pvs, int[] c, String sql, DBConn conn) {
        return DBUtil.run(sql, pvs, conn);
    }

    public static RecordList select(String[] a, int[] b, String sql) {
        return DBUtil.run(sql);
    }

    public static RecordList update(Object[] pvs, int[] c, String sql, DBConn conn) {
        return DBUtil.run(sql, pvs, conn);
    }

    public static RecordList update(Object[] pvs, int[] c, String sql) {
        return DBUtil.run(sql, pvs);
    }
}

