/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityListDialog;
import attendance.ActivityMemberGroup;
import attendance.Attendance;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.MemberGroup;
import member.MemberGroupSelectComboBox;
import system.MasterCode;
import ui.ComboBoxCN;
import ui.DateTextField;
import ui.TableLayout;
import ui.TimeTextField;
import util.RecordList;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class ActivityInfoDialog
extends JDialog {
    JTextField nameTF;
    JTextField lecturerTF;
    JTextField venueTF;
    JTextField remarkTF;
    ComboBoxCN typeCN;
    ComboBoxCN statusCN;
    MemberGroupSelectComboBox mgCB;
    DateTextField dateDT;
    TimeTextField start_timeTT;
    TimeTextField end_timeTT;
    TimeTextField late_timeTT;
    TimeTextField start_record_timeTT;
    TimeTextField end_record_timeTT;
    private RecordList g_Member_groups = null;
    JButton saveB;
    JButton cancelB;
    private Activity g_Activity = null;
    private boolean g_isUpdate = false;

    public ActivityInfoDialog(JDialog f) {
        super(f, "\u65b0\u589e\u805a\u6703", false);
        this.g_Activity = new Activity();
        this.g_Member_groups = MemberGroup.getRootGroup();
        this.g_isUpdate = false;
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public ActivityInfoDialog(JDialog f, int activity_seq, boolean isUpdate) {
        super(f, "\u4fee\u6539\u805a\u6703", false);
        this.g_isUpdate = isUpdate;
        this.g_Activity = new Activity(activity_seq);
        ActivityMemberGroup amg = new ActivityMemberGroup(activity_seq);
        this.g_Member_groups = amg.getItems();
        if (!this.g_isUpdate) {
            this.g_Activity.resetActivit_seq();
            this.g_Activity.resetDate();
            amg.resetHeadcount();
        }
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void init(int activity_seq) {
    }

    void setEditLayout() {
        this.nameTF = new JTextField(this.g_Activity.getName());
        this.lecturerTF = new JTextField(this.g_Activity.getLecturer());
        this.venueTF = new JTextField(this.g_Activity.getVenue());
        this.remarkTF = new JTextField(this.g_Activity.getRemark());
        this.typeCN = new ComboBoxCN(MasterCode.getCodes("ACTIVITY"), this.g_Activity.getType());
        this.statusCN = this.getStatusSel();
        this.mgCB = new MemberGroupSelectComboBox(this.g_Member_groups);
        this.dateDT = new DateTextField(this.g_Activity.getDate());
        this.start_timeTT = new TimeTextField(this.g_Activity.getStart_time());
        this.end_timeTT = new TimeTextField(this.g_Activity.getEnd_time());
        this.late_timeTT = new TimeTextField(this.g_Activity.getLate_time());
        this.start_record_timeTT = new TimeTextField(this.g_Activity.getStart_record_time());
        this.end_record_timeTT = new TimeTextField(this.g_Activity.getEnd_record_time());
        if (Attendance.existActivityAttendance(this.g_Activity.getActivity_seq())) {
            this.typeCN.setEnabled(false);
            this.mgCB.setEnabled(false);
            this.dateDT.setEnabled(false);
            this.start_timeTT.setEnabled(false);
            this.end_timeTT.setEnabled(false);
            this.late_timeTT.setEnabled(false);
            this.start_record_timeTT.setEnabled(false);
            this.end_record_timeTT.setEnabled(false);
        }
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        TableLayout t = new TableLayout(this, 500, 300, 12, 5);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 120;
        nArray[2] = 100;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("\u805a\u6703\u985e\u5225");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.typeCN, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, 0, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 3, 0, 20, 0);
        JLabel jLabel3 = new JLabel("\u805a\u6703\u540d\u7a31");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 1, 20, 0, 140, -1);
        JLabel jLabel4 = new JLabel("\u5730\u9ede");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 2, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.venueTF, 3, 1, 20, 0, 140, -1);
        JLabel jLabel5 = new JLabel("\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.dateDT, 1, 2, 20, 0);
        JLabel jLabel6 = new JLabel("\u8b1b\u54e1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 2, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.lecturerTF, 3, 2, 20, 0, 140, -1);
        int[] nArray2 = new int[6];
        nArray2[0] = 80;
        nArray2[1] = 50;
        nArray2[2] = 100;
        nArray2[3] = 50;
        nArray2[4] = 100;
        t.getClass();
        nArray2[5] = 0;
        t.addTable(nArray2, new int[]{30, 30});
        JLabel jLabel7 = new JLabel("\u805a\u6703\u958b\u59cb\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_timeTT, 1, 0, 20, 0);
        JLabel jLabel8 = new JLabel("\u805a\u6703\u7d50\u675f\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 2, 0, 1, 0);
        t.getClass();
        t.addCell(this.end_timeTT, 3, 0, 20, 0);
        JLabel jLabel9 = new JLabel("\u9072\u5230\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 4, 0, 1, 0);
        t.getClass();
        t.addCell(this.late_timeTT, 5, 0, 20, 0);
        JLabel jLabel10 = new JLabel("\u958b\u59cb\u9ede\u5230\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel10, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.start_record_timeTT, 1, 1, 20, 0);
        JLabel jLabel11 = new JLabel("\u7d50\u675f\u9ede\u5230\u6642\u9593");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, 1, 1, 0);
        t.getClass();
        t.addCell(this.end_record_timeTT, 3, 1, 20, 0);
        int[] nArray3 = new int[2];
        nArray3[0] = 80;
        t.getClass();
        nArray3[1] = 0;
        t.addTable(nArray3, new int[]{30, 30});
        JLabel jLabel12 = new JLabel("\u53c3\u52a0\u8005\u8eab\u4efd");
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.mgCB, 1, 0, 20, 0, 360, -1);
        JLabel jLabel13 = new JLabel("\u5099\u8a3b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, 1, 20, 0, 360, -1);
        t.addTable(new int[]{400, 10, 80}, new int[]{60});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    public ComboBoxCN getStatusSel() {
        String[][] status;
        String cur_status = this.g_Activity.getStatus();
        if (this.g_Activity.getStatus().equals("")) {
            status = new String[][]{Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CP)};
            cur_status = Activity.STATUS__CP;
        } else {
            status = new String[][]{Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CP), Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CL)};
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), cur_status);
        c.hasNilItem(false);
        return c;
    }

    public void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActivityInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActivityInfoDialog.this.onCancel(evt);
            }
        });
    }

    public void onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.typeCN.getSelectedCode(), "\u805a\u6703\u985e\u5225", "R");
        validation.add(this.dateDT.getInput(), "\u805a\u6703\u65e5\u671f", "R,D");
        validation.add(this.start_timeTT.getInput(), "\u805a\u6703\u958b\u59cb\u6642\u9593", "R,T");
        validation.add(this.end_timeTT.getInput(), "\u805a\u6703\u7d50\u675f\u6642\u9593", "R,T");
        validation.add(this.late_timeTT.getInput(), "\u9072\u5230\u6642\u9593", "R,T");
        validation.add(this.start_record_timeTT.getInput(), "\u958b\u59cb\u9ede\u5230\u6642\u9593", "R,T");
        validation.add(this.end_record_timeTT.getInput(), "\u7d50\u675f\u9ede\u5230\u6642\u9593", "R,T");
        validation.add(!this.mgCB.getSelGroups().isEmpty(), "\u5fc5\u9808\u9078\u64c7\u53c3\u52a0\u8005\u8eab\u4efd", "RT");
        if (!validation.isValid()) {
            return;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        String activity_date = this.dateDT.getInput();
        RecordList mgs = this.mgCB.getSelGroups();
        int i = 0;
        while (i < mgs.size()) {
            if (!mgs.hasObj(ActivityMemberGroup.HEADCOUNT, i)) {
                mgs.setI(ActivityMemberGroup.HEADCOUNT, 0, i);
            }
            ++i;
        }
        if (this.g_isUpdate) {
            Activity.update(this.g_Activity.getActivity_seq(), this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.nameTF.getText(), this.lecturerTF.getText(), this.dateDT.getDate(), this.start_timeTT.getTime(activity_date), this.end_timeTT.getTime(activity_date), this.late_timeTT.getTime(activity_date), this.start_record_timeTT.getTime(activity_date), this.end_record_timeTT.getTime(activity_date), this.venueTF.getText(), this.remarkTF.getText(), mgs);
        } else {
            Activity.insert(this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.nameTF.getText(), this.lecturerTF.getText(), this.dateDT.getDate(), this.start_timeTT.getTime(activity_date), this.end_timeTT.getTime(activity_date), this.late_timeTT.getTime(activity_date), this.start_record_timeTT.getTime(activity_date), this.end_record_timeTT.getTime(activity_date), this.venueTF.getText(), this.remarkTF.getText(), mgs);
        }
        ((ActivityListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

