/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Voucher;
import account.VoucherItem;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import system.Config;
import util.Arith;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import util.WinUtil;

public class VoucherPrintout {
    private float g_MM2PT = 2.8346f;
    private float g_Width = 210.0f * this.g_MM2PT;
    private float g_Height = 99.0f * this.g_MM2PT;
    private float g_Margin = 5.0f * this.g_MM2PT;
    private RecordList gVouchers = null;
    private RecordList gVoucherItems = null;
    private String gOutputFile = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".pdf";

    public VoucherPrintout(ArrayList ac_doc_seqs) {
        this.gVouchers = Voucher.getVouchers(ac_doc_seqs);
        this.gVoucherItems = VoucherItem.getVoucherItems(ac_doc_seqs);
    }

    public boolean genFile() {
        if (this.gVouchers.isEmpty()) {
            WinUtil.showMessage(null, "\u6b64\u7bc4\u570d\u4e2d\u6c92\u6709\u50b3\u7968\u6216\u7576\u4e2d\u50b3\u7968\u5df2\u53d6\u6d88");
            return true;
        }
        Document document = new Document(new Rectangle(this.g_Width, this.g_Height), this.g_Margin, this.g_Margin, this.g_Margin, this.g_Margin);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.gOutputFile));
            document.open();
            BaseFont bf = BaseFont.createFont((String)(String.valueOf(System.getenv("WINDIR")) + "/fonts/mingliu.ttc,0"), (String)"Identity-H", (boolean)true);
            Font F15 = new Font(bf, 18.0f, 1);
            Font F9 = new Font(bf, 9.0f);
            Image header_logo = Image.getInstance((String)"image/logo.jpg");
            PdfPCell emptyC = new PdfPCell(new Phrase(" ", F9));
            emptyC.setBorder(0);
            int i = 0;
            while (i < this.gVouchers.size()) {
                PdfPTable header_table = new PdfPTable(new float[]{130.0f, 70.0f});
                header_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                header_table.setWidthPercentage(100.0f);
                header_table.setLockedWidth(true);
                header_table.getDefaultCell().setPadding(0.0f);
                PdfPCell header_logoC = new PdfPCell(header_logo, true);
                header_logoC.setBorder(0);
                PdfPCell header_receiptC = new PdfPCell(new Phrase("\u50b3\u7968", F15));
                header_receiptC.setHorizontalAlignment(2);
                header_receiptC.setBorder(0);
                header_table.addCell(header_logoC);
                header_table.addCell(header_receiptC);
                PdfPTable parent_table = new PdfPTable(new float[]{12.0f, 135.0f, 18.0f, 35.0f});
                parent_table.getDefaultCell().setBorder(0);
                parent_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                parent_table.setWidthPercentage(100.0f);
                parent_table.setLockedWidth(true);
                parent_table.getDefaultCell().setPadding(0.0f);
                PdfPCell dataC = new PdfPCell();
                dataC.setBorder(0);
                this.gVouchers.setCurrentRow(i);
                dataC.setPhrase(new Phrase("\u65e5\u671f:", F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(TimeUtil.getStringByDate(this.gVouchers.getT(Voucher.DATE)), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase("\u50b3\u7968\u7de8\u865f:", F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(this.gVouchers.getS(Voucher.ID), F9));
                parent_table.addCell(dataC);
                PdfPTable item_table = new PdfPTable(new float[]{15.0f * this.g_MM2PT, 35.0f * this.g_MM2PT, 60.0f * this.g_MM2PT, 35.0f * this.g_MM2PT, 20.0f * this.g_MM2PT, 20.0f * this.g_MM2PT});
                item_table.getDefaultCell().setBorder(0);
                item_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                item_table.setWidthPercentage(100.0f);
                item_table.setLockedWidth(true);
                item_table.getDefaultCell().setPadding(0.0f);
                int ac_doc_seq = this.gVouchers.getI(Voucher.AC_DOC_SEQ);
                RecordList items = this.gVoucherItems.getGroupItems(Voucher.AC_DOC_SEQ, ac_doc_seq);
                PdfPCell item_headerC = new PdfPCell(new Phrase("\u5e33\u6236", F9));
                item_headerC.setBorder(3);
                item_table.addCell(item_headerC);
                item_headerC.setPhrase(new Phrase(" ", F9));
                item_table.addCell(item_headerC);
                item_headerC.setPhrase(new Phrase("\u6458\u8981", F9));
                item_table.addCell(item_headerC);
                item_headerC.setPhrase(new Phrase("\u652f\u7968\u865f\u78bc", F9));
                item_table.addCell(item_headerC);
                item_headerC.setHorizontalAlignment(2);
                item_headerC.setPhrase(new Phrase("\u501f\u65b9(" + Config.getS(Config.currencyCode) + ")", F9));
                item_table.addCell(item_headerC);
                item_headerC.setPhrase(new Phrase("\u8cb8\u65b9(" + Config.getS(Config.currencyCode) + ")", F9));
                item_table.addCell(item_headerC);
                double ttlDebit = 0.0;
                double ttlCredit = 0.0;
                int j = 0;
                while (j < items.size()) {
                    items.setCurrentRow(j);
                    double debit = items.getD(VoucherItem.DEBIT);
                    double credit = items.getD(VoucherItem.CREDIT);
                    PdfPCell ac_idC = new PdfPCell(new Phrase(items.getS("id"), F9));
                    PdfPCell ac_nameC = new PdfPCell(new Phrase(items.getS("name"), F9));
                    PdfPCell remarkC = new PdfPCell(new Phrase(items.getS(VoucherItem.REMARK), F9));
                    PdfPCell cheque_noC = new PdfPCell(new Phrase(items.getS(VoucherItem.CHEQUE_NO), F9));
                    PdfPCell debitC = new PdfPCell(new Phrase(debit == 0.0 ? "" : Arith.formatAmount(debit), F9));
                    PdfPCell creditC = new PdfPCell(new Phrase(credit == 0.0 ? "" : Arith.formatAmount(credit), F9));
                    ttlDebit = Arith.add(ttlDebit, debit);
                    ttlCredit = Arith.add(ttlCredit, credit);
                    ac_idC.setBorder(0);
                    ac_nameC.setBorder(0);
                    remarkC.setBorder(0);
                    cheque_noC.setBorder(0);
                    debitC.setBorder(0);
                    debitC.setHorizontalAlignment(2);
                    creditC.setBorder(0);
                    creditC.setHorizontalAlignment(2);
                    item_table.addCell(ac_idC);
                    item_table.addCell(ac_nameC);
                    item_table.addCell(remarkC);
                    item_table.addCell(cheque_noC);
                    item_table.addCell(debitC);
                    item_table.addCell(creditC);
                    ++j;
                }
                PdfPCell totalC = new PdfPCell(new Phrase(Arith.formatAmount(ttlDebit), F9));
                totalC.setHorizontalAlignment(2);
                totalC.setBorder(1);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(totalC);
                totalC.setPhrase(new Phrase(Arith.formatAmount(ttlCredit), F9));
                item_table.addCell(totalC);
                int j2 = 0;
                while (j2 < 9 - items.size()) {
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    ++j2;
                }
                PdfPCell signC = new PdfPCell(new Phrase("\u8f38\u5165\u8005\u7f72\u540d", F9));
                signC.setHorizontalAlignment(2);
                signC.setBorder(1);
                signC.setColspan(2);
                item_table.addCell(signC);
                item_table.addCell(emptyC);
                signC.setPhrase(new Phrase("\u6279\u6838\u8005\u7f72\u540d\u53ca\u6559\u6703\u84cb\u5370", F9));
                signC.setColspan(3);
                item_table.addCell(signC);
                PdfPTable page_table = new PdfPTable(1);
                page_table.getDefaultCell().setBorder(0);
                page_table.addCell(header_table);
                page_table.addCell(parent_table);
                page_table.addCell(item_table);
                document.add((Element)page_table);
                if (i != this.gVouchers.size() - 1) {
                    document.newPage();
                }
                ++i;
            }
        }
        catch (DocumentException e1) {
            Tools.writeError(e1.getMessage());
        }
        catch (IOException e2) {
            Tools.writeError(e2.getMessage());
        }
        document.close();
        try {
            String option = "";
            Runtime.getRuntime().exec("cmd.exe /c \"" + this.gOutputFile + "\"");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return true;
    }
}

