/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import util.ArrayListSet;
import util.ArrayUtil;

public class ReceiptItem {
    private int g_Receipt_seq = -1;
    private ArrayList g_Items = null;
    public static String RECEIPT_ITEM_SEQ = "receipt_item_seq";
    public static String RECEIPT_SEQ = "receipt_seq";
    public static String TYPE = "type";
    public static String SUB_TYPE = "sub_type";
    public static String NOTE = "note";
    public static String AMOUNT = "amount";

    public ReceiptItem(int receipt_seq) {
        this.g_Receipt_seq = receipt_seq;
        DBConn conn = new DBConn();
        this.g_Items = ReceiptItem.load(this.g_Receipt_seq, conn);
        conn.commit();
    }

    public ArrayList getItems() {
        return this.g_Items;
    }

    private static ArrayList load(int receipt_seq, DBConn conn) {
        String sql = "select RECEIPT_ITEM_SEQ,RECEIPT_SEQ,TYPE,SUB_TYPE,NOTE,AMOUNT from receipt_item where RECEIPT_SEQ=?";
        return DBUtil.select(new String[]{"RECEIPT_ITEM_SEQ", "RECEIPT_SEQ", "TYPE", "SUB_TYPE", "NOTE", "AMOUNT"}, new int[]{4, 4, 12, 12, 12, 8}, new Object[]{new Integer(receipt_seq)}, new int[]{4}, sql, conn);
    }

    public static void update(int receipt_seq, ArrayList items, DBConn conn) {
        ArrayList old_items = ReceiptItem.load(receipt_seq, conn);
        ArrayListSet set = new ArrayListSet(old_items, items, new String[]{"RECEIPT_ITEM_SEQ"});
        ArrayList v = set.getLeftOnly();
        int i = 0;
        while (i < v.size()) {
            int receipt_item_seq = ArrayUtil.getInt("RECEIPT_ITEM_SEQ", i, v);
            ReceiptItem.delete(receipt_item_seq, conn);
            ++i;
        }
        v = set.getIntersectOfRight();
        i = 0;
        while (i < v.size()) {
            ReceiptItem.update(ArrayUtil.getInt("RECEIPT_ITEM_SEQ", i, v), ArrayUtil.getString("TYPE", i, v), ArrayUtil.getString("SUB_TYPE", i, v), ArrayUtil.getString("NOTE", i, v), ArrayUtil.getDouble("AMOUNT", i, v), conn);
            ++i;
        }
        v = set.getRightOnly();
        i = 0;
        while (i < v.size()) {
            ReceiptItem.insert(receipt_seq, ArrayUtil.getString("TYPE", i, v), ArrayUtil.getString("SUB_TYPE", i, v), ArrayUtil.getString("NOTE", i, v), ArrayUtil.getDouble("AMOUNT", i, v), conn);
            ++i;
        }
    }

    private static void insert(int receipt_seq, String type, String sub_type, String note, double amount, DBConn conn) {
        String sql = "insert into receipt_item( RECEIPT_ITEM_SEQ,RECEIPT_SEQ,TYPE,SUB_TYPE,NOTE,AMOUNT)values(?,?,?,?,?,?)";
        int receipt_item_seq = DBUtil.getNextValueFor("receipt_item_seq", conn);
        DBUtil.update(new Object[]{new Integer(receipt_item_seq), new Integer(receipt_seq), type, sub_type, note, new BigDecimal(amount)}, new int[]{4, 4, 12, 12, 12, 8}, sql, conn);
    }

    private static void update(int receipt_item_seq, String type, String sub_type, String note, double amount, DBConn conn) {
        String sql = "update receipt_item set TYPE=?,SUB_TYPE=?,NOTE=?,AMOUNT=? where RECEIPT_ITEM_SEQ=?";
        DBUtil.update(new Object[]{type, sub_type, note, new BigDecimal(amount), new Integer(receipt_item_seq)}, new int[]{12, 12, 12, 8, 4}, sql, conn);
    }

    private static void delete(int receipt_item_seq, DBConn conn) {
        String sql = "delete from receipt_item where RECEIPT_ITEM_SEQ=?";
        DBUtil.update(new Object[]{new Integer(receipt_item_seq)}, new int[]{4}, sql, conn);
    }
}

