/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.ReceiptItem;
import account.ReceiptListDialog;
import account.ReceiptPrintout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import member.MemberGroup;
import member.MemberGroupMember;
import system.Config;
import system.MasterCode;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayListCreator;
import util.ArrayUtil;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class ReceiptInfoDialog
extends JDialog {
    private JTextField idTF;
    private JTextField offer_fromTF;
    private JTextField cheque_noTF;
    private JTextField remarkTF;
    private JTextField totalTF;
    private ComboBoxCN statusCN;
    private AutoComboBoxNV memberNV;
    private DateTextField dateDT;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton nextB;
    private JButton cancelB;
    private ScrollList itemSL;
    private JCheckBox auto_printCB;
    private Receipt g_Receipt = null;
    private ArrayList g_Items = null;
    private boolean g_isUpdate = false;
    private ArrayList g_Sub_types = null;

    public ReceiptInfoDialog(JDialog f, int receipt_seq, boolean isUpdate) {
        super(f, "\u65b0\u589e\u6536\u64da", false);
        if (isUpdate) {
            this.setTitle("\u4fee\u6539\u6536\u64da");
        }
        this.g_isUpdate = isUpdate;
        this.init(receipt_seq);
    }

    private void init(int receipt_seq) {
        this.g_Receipt = new Receipt(receipt_seq);
        ReceiptItem p = new ReceiptItem(receipt_seq);
        this.g_Items = p.getItems();
        this.g_Sub_types = MasterCode.getCodes("RECEIPT_SUB_TYPE");
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        this.idTF = new JTextField(this.g_Receipt.getReceipt_seq() == -1 ? Tools.getNextID(Config.getS(Config.receiptIdFormat), "receipt", "id") : this.g_Receipt.getId());
        this.offer_fromTF = new JTextField(this.g_Receipt.getOffer_from());
        this.cheque_noTF = new JTextField(this.g_Receipt.getCheque_no());
        this.remarkTF = new JTextField(this.g_Receipt.getRemark());
        this.statusCN = this.getStatusSel();
        this.memberNV = new AutoComboBoxNV((ArrayList)MemberGroupMember.getActiveMembersInGroup(MemberGroup.ROOT_GROUP_SEQ, this.g_Receipt.getMember_seq()), "list_item", "member_seq", this.g_Receipt.getMember_seq());
        Timestamp date = this.g_Receipt.getDate();
        date = date == null ? TimeUtil.getCurrentDate() : date;
        this.dateDT = new DateTextField(date);
        this.add_itemB = new JButton("\u52a0\u5165\u9805\u76ee");
        this.del_itemB = new JButton("\u522a\u9664\u9805\u76ee");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.nextB = new JButton("\u4e0b\u4e00\u5f35");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.auto_printCB = new JCheckBox("\u78ba\u5b9a\u5f8c\u986f\u793a\u6536\u64da\u5217\u5370\u756b\u9762");
        TableLayout t = new TableLayout(this, 500, 560, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 230;
        nArray[2] = 50;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("\u6536\u64da\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, row, 20, 0, 100, -1);
        JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, row, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 3, row, 20, 0);
        ++row;
        JLabel jLabel3 = new JLabel("\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.dateDT, 1, row, 20, 0);
        ++row;
        JLabel jLabel4 = new JLabel("\u6703\u773e");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.memberNV, 1, row, 20, 0, 360, -1);
        ++row;
        JLabel jLabel5 = new JLabel("\u8332\u6536\u5230");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.offer_fromTF, 1, row, 20, 0, 360, -1);
        ++row;
        JLabel jLabel6 = new JLabel("\u652f\u7968\u865f\u78bc");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cheque_noTF, 1, row, 20, 0, 360, -1);
        ++row;
        JLabel jLabel7 = new JLabel("\u5099\u8a3b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, row, 20, 0, 360, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[4];
        t.getClass();
        nArray2[0] = 0;
        nArray2[1] = 15;
        nArray2[2] = 80;
        nArray2[3] = 10;
        t.addTable(nArray2, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.del_itemB, 2, 0, -1, 0);
        this.itemSL = new ScrollList(460, 200, this.g_Items, new int[]{50, 80, 270, 55}, new String[]{"\u985e\u5225", "\u9805\u76ee", "\u6458\u8981", "\u91d1\u984d"}, new String[]{ReceiptItem.TYPE, ReceiptItem.SUB_TYPE, ReceiptItem.NOTE, ReceiptItem.AMOUNT}, new boolean[]{true, true, true, true});
        this.itemSL.setBigDecimalTextFieldColumn(ReceiptItem.AMOUNT);
        this.itemSL.setEditing_mode(true);
        ArrayListCreator c = new ArrayListCreator(new String[]{"name", "type"});
        c.add(new String[]{"\u5949\u737b", Receipt.TYPE__OFFERING});
        c.add(new String[]{"\u6536\u8cbb", Receipt.TYPE__CHARGE});
        ComboBoxNV typeNV = new ComboBoxNV(c.getArrayList(), "name", "type", Receipt.TYPE__OFFERING);
        typeNV.hasNilItem(false);
        this.itemSL.setComboxNVColumn("type", typeNV);
        ComboBoxCN sub_typeENV = new ComboBoxCN(MasterCode.getCodes("RECEIPT_SUB_TYPE"), "");
        this.itemSL.setComboxNVColumn("sub_type", sub_typeENV);
        this.totalTF = new JTextField(String.valueOf(ArrayUtil.getDoubleSum(this.g_Items, ReceiptItem.AMOUNT)));
        this.totalTF.setEditable(false);
        int[] nArray3 = new int[1];
        t.getClass();
        nArray3[0] = 0;
        t.addTable(nArray3, new int[]{210, 30});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, 0, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.auto_printCB, 0, 1, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.totalTF, 0, 1, 1, 0, 75, -1);
        int[] nArray4 = new int[6];
        t.getClass();
        nArray4[0] = 0;
        nArray4[1] = 15;
        nArray4[2] = 60;
        nArray4[3] = 15;
        nArray4[4] = 60;
        nArray4[5] = 10;
        t.addTable(nArray4, new int[]{30});
        if (this.g_isUpdate) {
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.saveB, 2, 0, -1, 0, 60, -1);
        } else {
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.saveB, 0, 0, 1, 0, 60, -1);
            t.getClass();
            t.getClass();
            t.addCell(this.nextB, 2, 0, -1, 0);
        }
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 4, 0, -1, 0, 60, -1);
    }

    public ComboBoxCN getStatusSel() {
        String[][] status;
        String cur_status = this.g_Receipt.getStatus();
        if (this.g_Receipt.getStatus().equals("")) {
            status = new String[][]{Tools.getStatusItem(Receipt.STATUS_MAP, Receipt.STATUS__CP)};
            cur_status = Receipt.STATUS__CP;
        } else {
            status = new String[][]{Tools.getStatusItem(Receipt.STATUS_MAP, Receipt.STATUS__CP), Tools.getStatusItem(Receipt.STATUS_MAP, Receipt.STATUS__CL)};
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), cur_status);
        c.hasNilItem(false);
        return c;
    }

    private void setEventHandler() {
        this.memberNV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onChangeMember(evt);
            }
        });
        this.add_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onSave(evt);
            }
        });
        this.nextB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onNext(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReceiptInfoDialog.this.onCancel(evt);
            }
        });
        this.itemSL.addActionListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ReceiptInfoDialog.this.onTableChanged(e);
            }
        });
    }

    private void onChangeMember(ActionEvent evt) {
        ArrayList members = this.memberNV.getItems();
        String name = ArrayUtil.getString("NAME", this.memberNV.getSelectedIndex(), members);
        this.offer_fromTF.setText(name);
    }

    private void onAddItem(ActionEvent evt) {
        this.addNewItem();
    }

    private void addNewItem() {
        ArrayList v = this.itemSL.getTableData();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put(ReceiptItem.RECEIPT_ITEM_SEQ, new Integer(-1));
        h.put(ReceiptItem.TYPE, Receipt.TYPE__OFFERING);
        h.put(ReceiptItem.SUB_TYPE, "");
        h.put(ReceiptItem.NOTE, "");
        h.put(ReceiptItem.AMOUNT, new BigDecimal(0));
        v.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        ArrayList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    private void onTableChanged(TableModelEvent e) {
        if (this.itemSL.getChangedColName(e).equals(ReceiptItem.SUB_TYPE)) {
            ArrayList v = this.itemSL.getTableData();
            String sub_type = ArrayUtil.getString(ReceiptItem.SUB_TYPE, e.getFirstRow(), v);
            int k = ArrayUtil.indexOf("CODE", sub_type, this.g_Sub_types);
            if (k != -1) {
                String note = ArrayUtil.getString("NAME", k, this.g_Sub_types);
                ArrayUtil.setString(ReceiptItem.NOTE, note, e.getFirstRow(), v);
            }
        } else if (this.itemSL.getChangedColName(e).equals(ReceiptItem.AMOUNT)) {
            ArrayList v = this.itemSL.getTableData();
            double total = ArrayUtil.getDoubleSum(v, ReceiptItem.AMOUNT);
            this.totalTF.setText(String.valueOf(total));
        }
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.idTF.getText(), "\u6536\u64da\u7de8\u865f", "R");
        validation.add(this.dateDT.getInput(), "\u65e5\u671f", "R,D");
        validation.add(!Receipt.existID(this.idTF.getText(), this.g_Receipt.getReceipt_seq()), "\u6b64\u6536\u64da\u7de8\u865f\u5df2\u7d93\u5b58\u5728,\u8acb\u4f7f\u7528\u53e6\u4e00\u7de8\u865f", "RT");
        ArrayList items = this.itemSL.getTableData();
        validation.add(items.size(), "\u6536\u64da\u9805\u76ee", "GTZ");
        int i = 0;
        while (i < items.size()) {
            String sub_type = ArrayUtil.getString(ReceiptItem.SUB_TYPE, i, items);
            String note = ArrayUtil.getString(ReceiptItem.NOTE, i, items);
            double amount = ArrayUtil.getDouble(ReceiptItem.AMOUNT, i, items);
            validation.add(sub_type, "\u7b2c" + (i + 1) + "\u9805\u7684\u9805\u76ee", "R");
            validation.add(note, "\u7b2c" + (i + 1) + "\u9805\u7684\u6458\u8981", "R");
            validation.add(amount, "\u7b2c" + (i + 1) + "\u9805\u7684\u91d1\u984d", "F,GTZ");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        int seq = -1;
        seq = this.g_isUpdate ? Receipt.update(this.g_Receipt.getReceipt_seq(), this.idTF.getText(), this.dateDT.getDate(), this.statusCN.getSelectedCode(), this.offer_fromTF.getText(), this.cheque_noTF.getText(), this.memberNV.getSelectedIntValue(), this.remarkTF.getText(), items) : Receipt.insert(this.idTF.getText(), this.dateDT.getDate(), this.statusCN.getSelectedCode(), this.offer_fromTF.getText(), this.cheque_noTF.getText(), this.memberNV.getSelectedIntValue(), this.remarkTF.getText(), items);
        ((ReceiptListDialog)this.getParent()).onSearch(null);
        if (this.auto_printCB.isSelected()) {
            ReceiptPrintout p = new ReceiptPrintout(seq, 1);
            p.genFile();
        }
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onNext(ActionEvent evt) {
        boolean successful = this.onSave(evt);
        if (successful) {
            this.memberNV.setSelected(0);
            this.offer_fromTF.setText("");
            this.idTF.setText(Tools.getNextID(Config.getS(Config.receiptIdFormat), "receipt", "id"));
            this.setVisible(true);
        }
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

