/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.ReceiptItem;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Receipt {
    private int g_Receipt_seq = -1;
    private String g_Id = "";
    private Timestamp g_Date = null;
    private String g_Status = "";
    private String g_Offer_from = "";
    private String g_Cheque_no = "";
    private int g_Member_seq = -1;
    private String g_Remark = "";
    public static String TYPE__OFFERING = "OF";
    public static String TYPE__CHARGE = "CH";
    public static String STATUS__CP = "CP";
    public static String STATUS__CL = "CL";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__CP, "\u5df2\u78ba\u5b9a"}, new String[]{STATUS__CL, "\u5df2\u53d6\u6d88"}};

    public Receipt() {
    }

    public Receipt(int receipt_seq) {
        this.g_Receipt_seq = receipt_seq;
        this.load();
    }

    public int getReceipt_seq() {
        return this.g_Receipt_seq;
    }

    public String getId() {
        return this.g_Id;
    }

    public Timestamp getDate() {
        return this.g_Date;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public String getOffer_from() {
        return this.g_Offer_from;
    }

    public String getCheque_no() {
        return this.g_Cheque_no;
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    private void load() {
        String sql = "select ID,DATE,STATUS,OFFER_FROM,CHEQUE_NO,MEMBER_SEQ,REMARK from receipt where RECEIPT_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"ID", "DATE", "STATUS", "OFFER_FROM", "CHEQUE_NO", "MEMBER_SEQ", "REMARK"}, new int[]{12, 93, 12, 12, 12, 4, 12}, new Object[]{new Integer(this.g_Receipt_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Id = ArrayUtil.getString("ID", 0, v);
            this.g_Date = ArrayUtil.getTimestamp("DATE", 0, v);
            this.g_Status = ArrayUtil.getString("STATUS", 0, v);
            this.g_Offer_from = ArrayUtil.getString("OFFER_FROM", 0, v);
            this.g_Cheque_no = ArrayUtil.getString("CHEQUE_NO", 0, v);
            this.g_Member_seq = ArrayUtil.getInt("MEMBER_SEQ", 0, v);
            this.g_Remark = ArrayUtil.getString("REMARK", 0, v);
        }
    }

    public static int insert(String id, Timestamp date, String status, String offer_from, String cheque_no, int member_seq, String remark, ArrayList items) {
        String sql = "insert into receipt( RECEIPT_SEQ,ID,DATE,STATUS,OFFER_FROM,CHEQUE_NO,MEMBER_SEQ,REMARK)values(?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int receipt_seq = DBUtil.getNextValueFor("receipt_seq", conn);
        DBUtil.update(new Object[]{new Integer(receipt_seq), id, date, status, offer_from, cheque_no, new Integer(member_seq), remark}, new int[]{4, 12, 93, 12, 12, 12, 4, 12}, sql, conn);
        ReceiptItem.update(receipt_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? receipt_seq : -1;
    }

    public static int update(int receipt_seq, String id, Timestamp date, String status, String offer_from, String cheque_no, int member_seq, String remark, ArrayList items) {
        String sql = "update receipt set ID=?,DATE=?,STATUS=?,OFFER_FROM=?,CHEQUE_NO=?,MEMBER_SEQ=?,REMARK=? where RECEIPT_SEQ=?";
        DBConn conn = new DBConn();
        DBUtil.update(new Object[]{id, date, status, offer_from, cheque_no, new Integer(member_seq), remark, new Integer(receipt_seq)}, new int[]{12, 93, 12, 12, 12, 4, 12, 4}, sql, conn);
        ReceiptItem.update(receipt_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? receipt_seq : -1;
    }

    public static boolean existID(String id, int receipt_seq) {
        String sql = "select 'x' as TMP from receipt where id=? and receipt_seq<>?";
        RecordList v = DBUtil.select(new String[]{"TMP"}, new int[]{12}, new Object[]{id, new Integer(receipt_seq)}, new int[]{12, 4}, sql);
        return !v.isEmpty();
    }

    public static ArrayList search(String offer_form, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(rc.OFFER_FROM) LIKE lower(?)", "rc.DATE>=?", "rc.DATE<?"}, new Object[]{Tools.pad(offer_form), start_date, TimeUtil.adjustDate(end_date, 1)}, new int[]{12, 93, 93});
        String sql = "select rc.receipt_seq,rc.id,rc.date,rc.status,rc.offer_from,sum(ri.amount) as total from receipt rc,receipt_item ri where rc.receipt_seq=ri.receipt_seq" + clause.getConds() + " group by rc.receipt_seq,rc.id,rc.date,rc.status,rc.offer_from" + " order by rc.id desc" + " limit 1000";
        RecordList v = DBUtil.select(new String[]{"RECEIPT_SEQ", "ID", "DATE", "STATUS", "OFFER_FROM", "TOTAL"}, new int[]{4, 12, 93, 12, 12, 8}, clause.getPrepValues(), clause.getPrepTypes(), sql);
        int i = 0;
        while (i < v.size()) {
            ArrayUtil.setString("STATUS", Tools.getStatusName(STATUS_MAP, ArrayUtil.getString("STATUS", i, v)), i, v);
            ++i;
        }
        return v;
    }

    public static ArrayList getReceipts(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"id>=?", "id<=?", "date>=?", "date<?", "status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), STATUS__CP}, new int[]{12, 12, 93, 93, 12});
        String sql = "select receipt_seq,id,date,offer_from,cheque_no from receipt" + clause.getConds();
        return DBUtil.select(new String[]{"RECEIPT_SEQ", "ID", "DATE", "OFFER_FROM", "CHEQUE_NO"}, new int[]{4, 12, 93, 12, 12}, clause.getPrepValues(), clause.getPrepTypes(), sql);
    }

    public static ArrayList getReceiptItems(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"id>=?", "id<=?", "date>=?", "date<?", "status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), STATUS__CP}, new int[]{12, 12, 93, 93, 12});
        String sql = "select ri.receipt_seq as receipt_seq,ri.type as type,ri.note as note,ri.amount as amount from receipt as rc,receipt_item as ri where rc.receipt_seq=ri.receipt_seq" + clause.getConds();
        return DBUtil.select(new String[]{"RECEIPT_SEQ", "TYPE", "NOTE", "AMOUNT"}, new int[]{4, 12, 12, 8}, clause.getPrepValues(), clause.getPrepTypes(), sql);
    }

    public static RecordList getMemberReceipts(int member_seq, String sub_type, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"rci.sub_type=?", "rc.date>=?", "rc.date<?"}, new Object[]{sub_type, start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select rc.id,rc.date,mc.name as sub_type,rci.type,rci.note,rci.amount from receipt rc,receipt_item rci,master_code mc where rc.receipt_seq=rci.receipt_seq and rci.sub_type=mc.code and rc.member_seq=" + member_seq + " and rc.status='" + STATUS__CP + "'" + clause.getConds() + " order by rc.id desc";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        r.replaceColValue("type", TYPE__OFFERING, "\u5949\u737b");
        r.replaceColValue("type", TYPE__CHARGE, "\u6536\u8cbb");
        return r;
    }
}

