/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import util.Arith;
import util.RecordList;
import util.TimeUtil;

public class OfferingPrintout {
    private RecordList gReceipts;
    private RecordList gMembers;
    private Timestamp gStartDate;
    private Timestamp gEndDate;
    private ExcelPrintout gPrintout;
    private int gRow = -1;
    private static final String INDENT = "  ";

    public OfferingPrintout(int member_seq, Timestamp start_date, Timestamp end_date) {
        this.gStartDate = start_date;
        this.gEndDate = end_date;
        this.gReceipts = this.getReceipts(member_seq, this.gStartDate, this.gEndDate);
        this.gMembers = this.gReceipts.uniq(new String[]{"member_seq"});
        ExcelCellFormat TITLE = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.FS15) + ExcelFormat.AC);
        ExcelCellFormat BTAR = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.BT) + ExcelFormat.AR);
        this.gPrintout = new ExcelPrintout(ExcelFormat.PA4, new int[]{25, 30, 40, 60, 25});
        this.gPrintout.setReportEnd(false);
        int i = 0;
        while (i < this.gMembers.size()) {
            this.gMembers.setCurrentRow(i);
            ++this.gRow;
            this.gPrintout.addCell(0, this.gRow, 5, 1, "\u5949\u737b\u8b49\u660e\u66f8", TITLE);
            this.gRow += 2;
            this.gPrintout.addCell(0, this.gRow, "\u5949\u737b\u8005: " + this.gMembers.getS("name_eng") + " " + this.gMembers.getS("name_chi"));
            this.gPrintout.addCell(4, this.gRow, "\u5949\u737b\u6642\u671f: " + TimeUtil.getStringByDate(this.gStartDate) + " - " + TimeUtil.getStringByDate(this.gEndDate), this.gPrintout.AR);
            ++this.gRow;
            this.gPrintout.addCell(0, this.gRow, "\u65e5\u671f", this.gPrintout.TL);
            this.gPrintout.addCell(1, this.gRow, "\u6536\u64da\u7de8\u865f", this.gPrintout.TL);
            this.gPrintout.addCell(2, this.gRow, "\u9805\u76ee", this.gPrintout.TL);
            this.gPrintout.addCell(3, this.gRow, "\u6458\u8981", this.gPrintout.TL);
            this.gPrintout.addCell(4, this.gRow, "\u91d1\u984d(" + Config.getS(Config.currencyCode) + ")", this.gPrintout.TR);
            RecordList receipts = this.gReceipts.getGroupItems("member_seq", this.gMembers.getI("member_seq", i));
            double ttlAmount = 0.0;
            int j = 0;
            while (j < receipts.size()) {
                receipts.setCurrentRow(j);
                ++this.gRow;
                this.gPrintout.addCell(0, this.gRow, TimeUtil.getStringByDate(receipts.getT("date")));
                this.gPrintout.addCell(1, this.gRow, receipts.getS("id"));
                this.gPrintout.addCell(2, this.gRow, receipts.getS("sub_type"));
                this.gPrintout.addCell(3, this.gRow, receipts.getS("note"));
                this.gPrintout.addCell(4, this.gRow, Arith.formatAmount(receipts.getD("amount")), this.gPrintout.AR);
                ttlAmount = Arith.add(ttlAmount, receipts.getD("amount"));
                ++j;
            }
            ++this.gRow;
            this.gPrintout.addCell(3, this.gRow, "\u7e3d\u91d1\u984d:", this.gPrintout.AR);
            this.gPrintout.addCell(4, this.gRow, ttlAmount, this.gPrintout.BTBD);
            ++this.gRow;
            ++this.gRow;
            this.gPrintout.addCell(0, this.gRow, "\u8332\u8b49\u660e  " + this.gMembers.getS("name_eng") + " " + this.gMembers.getS("name_chi"));
            ++this.gRow;
            this.gPrintout.addCell(0, this.gRow, "\u7531" + TimeUtil.getStringByDate(this.gStartDate) + " \u81f3 " + TimeUtil.getStringByDate(this.gEndDate) + " \u5949\u737b\u5408\u8a08" + Config.getS(Config.currencyCode) + Arith.formatAmount(ttlAmount) + "\uff0c\u7279\u6b64\u8b49\u660e\u3002");
            this.gRow += 6;
            this.gPrintout.addCell(3, this.gRow, 2, 1, Config.getS(Config.companyName), BTAR);
            this.gPrintout.addPageBreak(this.gRow + 1);
            ++i;
        }
        this.gPrintout.genPrintout();
    }

    private RecordList getReceipts(int member_seq, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"mb.member_seq=?", "rc.date>=?", "rc.date<?"}, new Object[]{new Integer(member_seq), start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select rc.member_seq,mb.name_eng,mb.name_chi,rc.date,rc.id,mc.name as sub_type,rci.note,rci.amount from receipt rc,receipt_item rci,master_code mc,member mb where rc.receipt_seq=rci.receipt_seq and rc.status='" + Receipt.STATUS__CP + "'" + " and rci.type='" + Receipt.TYPE__OFFERING + "'" + " and rci.sub_type=mc.code" + " and rc.member_seq=mb.member_seq" + " and rc.member_seq>0" + clause.getConds() + " order by mb.name_eng,rc.date";
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

