/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountMonth;
import account.AccountPostingListDialog;
import account.AccountYear;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ui.ComboBoxNV;
import ui.TableLayout;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;

public class AccountYearPostingDialog
extends JDialog {
    JTextField nameTF;
    ComboBoxNV plr_acNV;
    JButton lockB;
    JButton unpostB;
    JButton postB;
    JButton cancelB;
    private Timestamp g_Start_date1;
    private Timestamp g_Start_date2;
    private boolean g_Posted = false;
    private boolean g_Consistence = false;
    private boolean g_Locked = false;
    private AccountYear g_AccountYear;

    public AccountYearPostingDialog(JDialog f, Timestamp start_date1, Timestamp start_date2) {
        super(f, "\u5e74\u7d50\u904e\u5e33", false);
        this.g_Start_date1 = start_date1;
        this.g_Start_date2 = start_date2;
        this.g_Posted = AccountYear.isPosted(this.g_Start_date1, this.g_Start_date2);
        this.g_Consistence = AccountYear.isPostConsistence(this.g_Start_date1, this.g_Start_date2);
        int ac_year_seq = -1;
        if (this.g_Posted && this.g_Consistence) {
            ac_year_seq = AccountYear.getMonth_posted_ac_year_seq(this.g_Start_date1, this.g_Start_date2);
        }
        this.g_AccountYear = new AccountYear(ac_year_seq);
        this.g_Locked = this.g_AccountYear.getLock().equals("Y");
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.plr_acNV = new ComboBoxNV(Account.getAccountsOfPLRetainedGroup(), "name", "ac_seq", this.g_AccountYear.getPlr_ac_seq());
        this.nameTF = new JTextField(this.g_AccountYear.getName());
        this.lockB = new JButton(this.g_Locked ? "\u89e3\u9664\u9396\u5b9a" : "\u9396\u5b9a\u5e74\u7d50");
        this.unpostB = new JButton("\u522a\u9664\u5e74\u7d50");
        this.postB = new JButton("\u9032\u884c\u5e74\u7d50");
        this.cancelB = new JButton("\u53d6\u6d88");
        if (!this.g_Posted || !this.g_Consistence) {
            this.lockB.setEnabled(false);
        }
        if (this.g_Locked || !this.g_Posted || !this.g_Consistence) {
            this.unpostB.setEnabled(false);
        }
        if (this.g_Locked || !this.g_Consistence) {
            this.postB.setEnabled(false);
        }
        TableLayout t = new TableLayout(this, 370, 215, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        String msg = !this.g_Consistence ? "\u5df2\u5b58\u5728\u591a\u500b\u5e74\u7d50\u6216\u5e74\u7d50\u6708\u4efd\u4e0d\u9f4a\u5168\uff0c\u8acb\u5148\u66f4\u6b63\u3002" : "";
        int row = 0;
        JLabel jLabel = new JLabel("\u5e74\u7d50\u6642\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        JLabel jLabel2 = new JLabel(String.valueOf(TimeUtil.getStringByDate(this.g_Start_date1)) + " \u81f3 " + TimeUtil.getStringByDate(TimeUtil.getMonthEndDay(this.g_Start_date2)));
        t.getClass();
        t.addCell(jLabel2, 1, row, 20, 0);
        JLabel jLabel3 = new JLabel(msg);
        t.getClass();
        t.addCell(jLabel3, 1, ++row, 20, 0);
        ++row;
        JLabel jLabel4 = new JLabel("\u6703\u8a08\u5e74\u5ea6\u540d\u7a31");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, row, 20, 0, 200, -1);
        ++row;
        JLabel jLabel5 = new JLabel("\u7d2f\u7a4d\u640d\u76ca\u5e33\u6236");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.plr_acNV, 1, row, 20, 0, 200, -1);
        t.addYSpace(15);
        t.addTable(new int[]{90, 90, 90, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.lockB, 0, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.unpostB, 1, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.postB, 2, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 3, 0, -1, 0, 80, -1);
    }

    void setEventHandler() {
        this.lockB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onLock(evt);
            }
        });
        this.unpostB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onUnpost(evt);
            }
        });
        this.postB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onPost(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onCancel(evt);
            }
        });
    }

    void onLock(ActionEvent evt) {
        AccountYear.lock(this.g_AccountYear.getAc_year_seq(), this.g_Locked ? "N" : "Y");
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onUnpost(ActionEvent evt) {
        AccountYear.unpost(this.g_AccountYear.getAc_year_seq(), AccountMonth.getAc_month_seq(this.g_Start_date2));
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onPost(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.nameTF.getText(), "\u6703\u8a08\u5e74\u5ea6\u540d\u7a31", "R");
        validation.add(this.plr_acNV.getSelectedIntValue(), "\u7d2f\u7a4d\u640d\u76ca\u5e33\u6236", "CBNVIR");
        if (!validation.isValid()) {
            return;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_Posted) {
            AccountYear.update(this.g_AccountYear.getAc_year_seq(), this.nameTF.getText(), this.g_Start_date1, this.g_Start_date2, AccountMonth.getAc_month_seq(this.g_Start_date2), this.plr_acNV.getSelectedIntValue());
        } else {
            AccountYear.insert(this.nameTF.getText(), this.g_Start_date1, this.g_Start_date2, AccountMonth.getAc_month_seq(this.g_Start_date2), this.plr_acNV.getSelectedIntValue());
        }
        wait_dialog.dispose();
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

