/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountMonth;
import account.AccountPostingListDialog;
import account.AccountYear;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import ui.TableLayout;
import util.ArrayUtil;
import util.TimeUtil;
import util.WinUtil;

public class AccountMonthPostingDialog
extends JDialog {
    JButton saveB;
    JButton cancelB;
    private AccountMonth g_AccountMonth = null;
    private boolean g_isUpdate = false;

    public AccountMonthPostingDialog(JDialog f, int ac_month_seq) {
        super(f, "\u6708\u7d50\u904e\u5e33", false);
        this.g_AccountMonth = new AccountMonth(ac_month_seq);
        if (ac_month_seq != -1) {
            this.g_isUpdate = true;
        } else {
            Timestamp start_date = AccountMonth.getNextMonthStartDate();
            this.g_AccountMonth.setStart_date(start_date);
            this.g_AccountMonth.setEnd_date(TimeUtil.getMonthEndDay(start_date));
        }
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.saveB = new JButton("\u904e\u5e33");
        this.cancelB = new JButton("\u53d6\u6d88");
        boolean locked = new AccountYear(this.g_AccountMonth.getAc_year_seq()).getLock().equals("Y");
        String msg = "";
        if (locked) {
            this.saveB.setEnabled(false);
            msg = "\u6b64\u6708\u4efd\u5df2\u9396\u5b9a\uff0c\u4e0d\u53ef\u904e\u5e33";
        }
        TableLayout t = new TableLayout(this, 350, 150, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30});
        JLabel jLabel = new JLabel("\u904e\u5e33\u6642\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel(String.valueOf(TimeUtil.getStringByDate(this.g_AccountMonth.getStart_date())) + " \u81f3 " + TimeUtil.getStringByDate(this.g_AccountMonth.getEnd_date()));
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0);
        JLabel jLabel3 = new JLabel(msg);
        t.getClass();
        t.addCell(jLabel3, 1, 1, 20, 0);
        t.addYSpace(10);
        t.addTable(new int[]{250, 15, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountMonthPostingDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccountMonthPostingDialog.this.onCancel(evt);
            }
        });
    }

    void onSave(ActionEvent evt) {
        if (this.g_AccountMonth.getAc_year_seq() != -1 && !WinUtil.getConfirm(this, "\u7531\u65bc\u6b64\u6708\u4efd\u5df2\u6709\u5e74\u7d50,\u5728\u6708\u7d50\u904e\u5e33,\u7cfb\u7d71\u6703\u81ea\u52d5\u884c\u9032\u5e74\u7d50.")) {
            return;
        }
        JDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_isUpdate) {
            AccountMonth.update(this.g_AccountMonth.getAc_month_seq());
        } else {
            AccountMonth.insert(this.g_AccountMonth.getStart_date(), this.g_AccountMonth.getEnd_date());
        }
        if (this.g_AccountMonth.getAc_year_seq() != -1) {
            AccountYear ac_year = new AccountYear(this.g_AccountMonth.getAc_year_seq());
            ArrayList months = AccountYear.getYearInfo(ac_year.getAc_year_seq());
            AccountYear.update(ac_year.getAc_year_seq(), ac_year.getName(), ArrayUtil.getTimestamp("START_DATE", 0, months), ArrayUtil.getTimestamp("START_DATE", months.size() - 1, months), ArrayUtil.getInt("AC_MONTH_SEQ", months.size() - 1, months), ac_year.getPlr_ac_seq());
        }
        wait_dialog.dispose();
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

