/* SFMTcc.h */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

BOOL SFMT_Initialize(void);

BOOL SFMT_SetEnableSSE2(BOOL b);

/* */

struct SFMTContext;

typedef struct SFMTContext SFMTContext_t;

SFMTContext_t* SFMT_CreateContext(void);

void SFMT_ReleaseContext(SFMTContext_t* t);

void SFMT_InitializeContext(
	SFMTContext_t* t,
	UINT32         seed);

void SFMT_InitializeContextByArray(
	SFMTContext_t* t,
	const UINT32*  key,
	INT32          len);

/* */

typedef UINT32 (*SFMT_gen_rand32_t)(SFMTContext_t*);

SFMT_gen_rand32_t SFMT_Get_gen_rand32(
	SFMTContext_t* t);

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

