// Main.cpp

#include <windows.h>

#include <stdio.h>

#include "SFMTcc.h"

static void test1();
static void test2();

int wmain(int argc, LPCWSTR argv[])
{
	SFMT_Initialize();

	if (argc > 1 && wcscmp(argv[1], L"-n") == 0) {
		SFMT_SetEnableSSE2(FALSE);
		fputs("NO SSE2 Mode.\n", stderr);
	}

	puts("SFMT-19937:122-18-1-11-1:dfffffef-ddfecb7f-bffaffff-bffffff6");
	puts("32 bit generated randoms");

	test1();

	puts("");

	test2();

	return 0;
}

static void test1()
{
	puts("init_gen_rand__________");

	SFMTContext_t* ctx = SFMT_CreateContext();
	if (ctx != 0) {
		SFMT_InitializeContext(ctx, 1234);
		SFMT_gen_rand32_t gen = SFMT_Get_gen_rand32(ctx);

		for (INT32 i = 0; i < 1000; i++) {
			UINT32 r = gen(ctx);
			printf("%10u ", r);
			if (i % 5 == 4) {
				printf("\n");
			}
		}

		SFMT_ReleaseContext(ctx);
	}
}

static void test2()
{
	UINT32 key[4] = { 0x1234, 0x5678, 0x9abc, 0xdef0 };

	puts("init_by_array__________");

	SFMTContext_t* ctx = SFMT_CreateContext();
	if (ctx != 0) {
		SFMT_InitializeContextByArray(ctx, key, 4);
		SFMT_gen_rand32_t gen = SFMT_Get_gen_rand32(ctx);

		for (INT32 i = 0; i < 1000; i++) {
			UINT32 r = gen(ctx);
			printf("%10u ", r);
			if (i % 5 == 4) {
				printf("\n");
			}
		}

		SFMT_ReleaseContext(ctx);
	}
}

