#include "common.h"

//Method definition
DWORD Structure_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
  for (UINT i = 0; i < cNames; i++)
  {
	rgDispId[i] = DISPID_UNKNOWN;
	for (int j=0;j<data->CompoNum;j++)
	{
		if (!lstrcmpiW(rgszNames[i],data->ComponentNames[j])) 
		{
			rgDispId[i]=j+1;
			break;
		}
	}
	if (rgDispId[i] == DISPID_UNKNOWN) return DISP_E_MEMBERNOTFOUND;
  }
  return S_OK;
}

//Method Invoke
DWORD Structure_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
	int i,j,sSize;
	int cArgs = pDispParams->cArgs;
	byte* pByte; short* pShort; int* pInt;
	LPWSTR Unicode,Unicode2;
	LPSTR ANSI;
	int vInt,dimPos;
	COMDATA* dataOrg;
	COMDATA* data2;
	VARIANTARG* rgvarg = pDispParams->rgvarg;
	int COM_ID=data->COM_ID;
	COMDATA* gpData;
	if (data->GrandParentData) {
		//This is child structure of nested structure.
		gpData=data->GrandParentData;
	} else gpData=data;

	if (wFlags & (DISPATCH_METHOD|DISPATCH_PROPERTYGET) ) {
		switch (dispIdMember) {
		case 0:
			if (cArgs==0) {//Getting pointer of Structure.
				if (pVarResult) {
					if (!data->Address) return DISP_E_BADPARAMCOUNT;
					pVarResult->lVal=(int)data->Address;
					pVarResult->vt=VT_I4;                 //32 bit int
				}
				return S_OK;
			} else if (cArgs==1) {
				if (!ResolveUnicode(&rgvarg[0],&Unicode)) return DISP_E_BADPARAMCOUNT;
				if (lstrcmpiW(Unicode,L"Reset"))          return DISP_E_BADPARAMCOUNT;
				// Reset structure
				data->Reset();
				return S_OK;
			} else if (cArgs&1) return DISP_E_BADPARAMCOUNT; //cArgs must be even number.

			//New Structure construction.
			data->Reset();
			data->RedimComponents(cArgs>>1);
			sSize=0;
			int CurrentPosition;
			CurrentPosition=0;
			for (i=cArgs-2;0<=i;i=i-2) {
				//Copy component name
				if (!ResolveUnicode(&rgvarg[i+1],&Unicode)) return DISP_E_BADPARAMCOUNT;
				Unicode2=CreateUnicode(Unicode,data,MALLOC_KEEP);
				data->ComponentNames[CurrentPosition]=Unicode2;
				if (Unicode=wcsrchr(Unicode2,L'(')){
					Unicode[0]=0;
					Unicode++;
					data->VarNums[CurrentPosition]=GetIntFromUnicode(Unicode)+1;
				} else data->VarNums[CurrentPosition]=1;

				//Set val type
				dataOrg=0;
				if (rgvarg[i].vt & VT_BYREF) {
					if (rgvarg[i].pvarVal->vt==VT_DISPATCH)
						dataOrg=GetDataFromComClass(rgvarg[i].pvarVal->pdispVal);
				} else if (rgvarg[i].vt==VT_DISPATCH) {
					dataOrg=GetDataFromComClass(rgvarg[i].pdispVal);
				} 
				if (dataOrg) {//Child structure in nested structure
					//dataOrg contains the structural information of child structure.
					//dataOrg may be released after this invoke (maybe not).
					//What we need to do here are:
					// 1) Create new IDispatch object as a container of child structure.
					// 2) Register the new object as data->ChildComClass[CurrentPosition].
					//    (This object will be released when current object will be released.)
					// 3) Copy the information from dataOrg to new object.
					// 4) Set data type to 0x20 with the size of dataOrg.
					// 5) Set the ParentData (this will be used when releasing object).
					//Resolving Address is not needed this time. This will be done later,  
					//when the parameter of child will be accessed. This way supports using
					//array of child structure.
					data->ChildComClass[CurrentPosition]=NewComClass(data->COM_ID);
					data2=GetDataFromComClass(data->ChildComClass[CurrentPosition]);
					data2->Copy(dataOrg);
					data2->ParentData=data;
					data->Types[CurrentPosition]=0x200000+data2->Size;
					//data2->Address=(void*)((int)data->Address+sSize);
				} else {
					if (!ResolveUnicode(&rgvarg[i],&Unicode)) return DISP_E_BADPARAMCOUNT;
					if (!lstrcmpiW(Unicode,L"Byte"))         data->Types[CurrentPosition]=0x1;
					else if (!lstrcmpiW(Unicode,L"Integer")) data->Types[CurrentPosition]=0x2;
					else if (!lstrcmpiW(Unicode,L"Long"))    data->Types[CurrentPosition]=0x4;
					else if (!lstrcmpiW(Unicode,L"String"))  data->Types[CurrentPosition]=0x110004;
					else if (!lstrcmpiW(Unicode,L"Unicode")) data->Types[CurrentPosition]=0x120004;
					else if (0<=lstrcmpiW(Unicode,L"String*0") && lstrcmpiW(Unicode,L"String*99999")<=0) {
						j=GetIntFromUnicode((LPWSTR)((int)wcsrchr(Unicode, L'*')+2));
						data->Types[CurrentPosition]=0x210000+j;
					} else if (0<=lstrcmpiW(Unicode,L"Unicode*0") && lstrcmpiW(Unicode,L"Unicode*99999")<=0) {
						j=GetIntFromUnicode((LPWSTR)((int)wcsrchr(Unicode, L'*')+2));
						data->Types[CurrentPosition]=0x220000+j*2;
					} else return DISP_E_BADPARAMCOUNT;
				}
				data->Positions[CurrentPosition]=sSize;
				sSize=sSize+(data->Types[CurrentPosition]&0xFFFF)*data->VarNums[CurrentPosition];
				CurrentPosition++;
			}
			data->Address=data->Malloc(sSize,MALLOC_KEEP);
			data->Size=sSize;
			data->CompoNum=CurrentPosition;
			if (pVarResult) {//Export ComClass for creating nested structure.
				//What we need to do here are:
				// 1) Create new IDispatch object (current object may be released after this invoke).
				// 2) Copy the information from current object to new object.
				pVarResult->vt=VT_DISPATCH;
				pVarResult->pdispVal=NewComClass(data->COM_ID);
				data2=GetDataFromComClass(pVarResult->pdispVal);
				data2->Copy(data);
			}
			return S_OK;

		default: //dispIdMember shows the position of component.
			if (data->CompoNum<dispIdMember) return DISP_E_BADPARAMCOUNT;
			//Getting property of component.
			if (cArgs==0) {
				if (data->VarNums[dispIdMember-1]!=1) return DISP_E_BADPARAMCOUNT;
				dimPos=0;
			} else if (cArgs==1) {//dimPos is the number in dimension ("dimPos"st parameter is asked).
				if (!ResolveInt(&rgvarg[0],&dimPos)) return DISP_E_BADPARAMCOUNT;
				if (dimPos<0 || data->VarNums[dispIdMember-1]<=dimPos) return DISP_E_BADINDEX;
			} else return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			switch (data->Types[dispIdMember-1]) {
			case 0x1: //Byte
				pByte=(byte*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				pVarResult->bVal=*pByte;
				pVarResult->vt=VT_UI1;                 //byte
				return S_OK;
			case 0x2: //Int16
				pShort=(short*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				pVarResult->iVal=*pShort;
				pVarResult->vt=VT_I2;                 //16 bit int
				return S_OK;
			case 0x4: //Int32
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				pVarResult->lVal=*pInt;
				pVarResult->vt=VT_I4;                 //32 bit int
				return S_OK;
			case 0x110004: //String
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				if (*pInt) {
					pVarResult->bstrVal=SysAllocString(CreateUnicode((LPSTR)*pInt,data,MALLOC_TEMPORARY));//copy as Unicode for export
				} else pVarResult->lVal=0;
				pVarResult->vt=VT_BSTR;               //return as Unicode
				return S_OK;
			case 0x120004: //Unicode
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				pVarResult->bstrVal=SysAllocString(CreateUnicode((LPWSTR)*pInt,data,MALLOC_TEMPORARY));//copy Unicode for export
				pVarResult->vt=VT_BSTR;               //Unicode
				return S_OK;
			default:
				switch (data->Types[dispIdMember-1]>>16) {
				case 0x21://String*XXX              //copy as Unicode for export
					ANSI=(LPSTR)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
					i=data->Types[dispIdMember-1]&0xFFFF;//String length
					pVarResult->bstrVal=SysAllocString(CreateFixedLengthUnicode(ANSI,data,i,MALLOC_TEMPORARY));
					pVarResult->vt=VT_BSTR;               //return as Unicode
					return S_OK;
				case 0x22://Unicode*XXX              //copy as Unicode for export
					Unicode=(LPWSTR)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
					i=(data->Types[dispIdMember-1]&0xFFFF)>>1;//String length
					pVarResult->bstrVal=SysAllocString(CreateFixedLengthUnicode(Unicode,data,i,MALLOC_TEMPORARY));
					pVarResult->vt=VT_BSTR;               //return as Unicode
					return S_OK;
				case 0x20://Child structure
					//What we need to do here are:
					// 1) Create new IDispatch object as a container of child structure.
					// 2) Register the new object as data->ChildComClass[CurrentPosition].
					//    (This object will be released when current object will be released.)
					// 3) Copy the information from dataOrg to new object.
					// 4) Set GrandParentData to current data.
					// 5) Resolve Address.
					//This child structure will be released after accessing its parameters.
					//The GrandParentData will be used for malloc function 
					//when accessing parameters, so that strings won't be lost 
					//when this temporary object will be released.
					pVarResult->vt=VT_DISPATCH;
					pVarResult->pdispVal=NewComClass(data->COM_ID);
					dataOrg=GetDataFromComClass(data->ChildComClass[dispIdMember-1]);
					data2=GetDataFromComClass(pVarResult->pdispVal);
					data2->Copy(dataOrg);
					data2->GrandParentData=dataOrg;
					data2->Address=(void*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
					return S_OK;
				}
			}
		return E_NOTIMPL;
		}
	} else if (wFlags & DISPATCH_PROPERTYPUT) {
		switch (dispIdMember) {
		case 0: //Copy the structure.
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			//Resolve COMDATA structure
			if (rgvarg[0].vt & VT_BYREF) {
				if (rgvarg[0].pvarVal->vt!=VT_DISPATCH) return DISP_E_BADPARAMCOUNT;
				dataOrg=GetDataFromComClass(rgvarg[0].pvarVal->pdispVal);
			} else if (rgvarg[0].vt==VT_DISPATCH) {
				dataOrg=GetDataFromComClass(rgvarg[0].pdispVal);
			} else return DISP_E_BADPARAMCOUNT;
			if (dataOrg->COM_ID!=1) return DISP_E_BADPARAMCOUNT; //Must be "SfcMini.Structure"
			data->Copy(dataOrg);
			return S_OK;
		default: //(dispIdMember-1) shows the position of component.
			//Put the property value.
			if (data->CompoNum<dispIdMember) return DISP_E_BADPARAMCOUNT;
			if (cArgs==1) {
				if (data->VarNums[dispIdMember-1]!=1) return DISP_E_BADPARAMCOUNT;
				dimPos=0;
			} else if (cArgs==2) {//dimPos is the number in dimension ("dimPos"st parameter is asked).
				if (!ResolveInt(&rgvarg[1],&dimPos)) return DISP_E_BADPARAMCOUNT;
				if (dimPos<0 || data->VarNums[dispIdMember-1]<=dimPos) return DISP_E_BADINDEX;
			} else return DISP_E_BADPARAMCOUNT;
			switch (data->Types[dispIdMember-1]) {
			case 0x1: //Byte
				if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
				pByte=(byte*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				*pByte=(byte)vInt;
				return S_OK;
			case 0x2: //Int16
				if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
				pShort=(short*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				*pShort=vInt;
				return S_OK;
			case 0x4: //Int32
				if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				*pInt=vInt;
				return S_OK;
			case 0x110004: //String
				if (!ResolveUnicode(&rgvarg[0],&Unicode)) { 
					if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
					if (vInt!=0) return DISP_E_BADPARAMCOUNT;
					pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
					*pInt=0;//Null string
					return S_OK;
				}
				//set pointer
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				data->MallocFree((void*)*pInt);//Throw away previous data
				*pInt=(int)CreateAnsiString(Unicode,gpData,MALLOC_KEEP);//Create ANSI
				return S_OK;
			case 0x120004: //Unicode
				if (!ResolveUnicode(&rgvarg[0],&Unicode)) { 
					if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
					if (vInt!=0) return DISP_E_BADPARAMCOUNT;
					pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
					*pInt=0;//Null string
					return S_OK;
				}
				//set pointer
				pInt=(int*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
				data->MallocFree((void*)*pInt);//Throw away previous data
				*pInt=(int)CreateUnicode(Unicode,gpData,MALLOC_KEEP);//Copy Unicode
				return S_OK;
			default:
				switch (data->Types[dispIdMember-1]>>16) {
				case 0x21://String*XXX              
					if (!ResolveUnicode(&rgvarg[0],&Unicode)) { 
						if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
						if (vInt!=0) return DISP_E_BADPARAMCOUNT;
						pByte=(byte*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
						*pByte=0;//Zero length String
						return S_OK;
					}
					//Convert to ANSI
					ANSI=(LPSTR)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);//LPSTR
					j=data->Types[dispIdMember-1]&0xFFFF;//String length
					WideCharToMultiByte(CP_ACP,0,Unicode,-1,ANSI,j,NULL,NULL);
					return S_OK;
				case 0x22://Unicode*XXX              
					if (!ResolveUnicode(&rgvarg[0],&Unicode)) { 
						if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
						if (vInt!=0) return DISP_E_BADPARAMCOUNT;
						pShort=(short*)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);
						*pShort=0;//Zero length String
						return S_OK;
					}
					//Copy Unicode
					Unicode2=(LPWSTR)((int)data->Address+(int)data->Positions[dispIdMember-1]+(data->Types[dispIdMember-1]&0xFFFF)*dimPos);//LPWSTR
					j=(data->Types[dispIdMember-1]&0xFFFF)>>1;//String length
					for (i=0;i<j;i++) if (!(Unicode2[i]=Unicode[i])) break;
					return S_OK;
				}
			}
		return E_NOTIMPL;
		}
		return S_OK;
	} else return DISP_E_BADPARAMCOUNT;
}