#include "common.h"

#pragma comment(linker, "/export:CreateObjectA=_CreateObjectA@12,PRIVATE")
#pragma comment(linker, "/export:CreateObjectW=_CreateObjectW@12,PRIVATE")

STDAPI CreateObjectA(LPCSTR file, LPCSTR clsidstr, IDispatch** ppv){
	*ppv=CreateObject(file,clsidstr);
	return ((*ppv)!=NULL) ? S_OK : E_INVALIDARG;
}

STDAPI CreateObjectW(LPWSTR file, LPWSTR clsidstr, IDispatch** ppv){
	*ppv=CreateObject(file,clsidstr);
	return ((*ppv)!=NULL) ? S_OK : E_INVALIDARG;
}

IDispatch* CreateObject(LPCSTR file, LPCSTR clsidstr){
	GUID clsid;
	int cchWideChar;
	LPWSTR lpWideCharStr;
	IDispatch* result;
	// clsidstr: Calculate UNICODE string length
	cchWideChar=MultiByteToWideChar(CP_ACP,MB_ERR_INVALID_CHARS,clsidstr,-1,0,0);
	if (!cchWideChar) return NULL;
	// clsidstr: Prepare memory for UNICODE
	lpWideCharStr=new wchar_t[cchWideChar+2];
	// clsidstr: Receive UNICODE
	if (!MultiByteToWideChar(CP_ACP,MB_ERR_INVALID_CHARS,clsidstr,-1,lpWideCharStr,cchWideChar)) {
		// Failed to construct UNICODE.
		return NULL;
	}
	// clsidstr: Receive CLSID
	if (NOERROR!=CLSIDFromString(lpWideCharStr,&clsid)) return NULL;
	delete lpWideCharStr;
	// file: Calculate UNICODE string length
	cchWideChar=MultiByteToWideChar(CP_ACP,MB_ERR_INVALID_CHARS,file,-1,0,0);
	if (!cchWideChar) return NULL;
	// file: Prepare memory for UNICODE
	lpWideCharStr=new wchar_t[cchWideChar+2];
	// file: Receive UNICODE
	if (!MultiByteToWideChar(CP_ACP,MB_ERR_INVALID_CHARS,file,-1,lpWideCharStr,cchWideChar)) {
		// Failed to construct UNICODE.
		return NULL;
	}
	// All done let's create the object
	result=CreateObject(lpWideCharStr,&clsid);
	delete lpWideCharStr;
	return result;
}


IDispatch* CreateObject(LPWSTR file, LPWSTR clsidstr){
	GUID clsid;
	if (NOERROR!=CLSIDFromString(clsidstr,&clsid)) return NULL;
	return CreateObject(file,&clsid);
}


IDispatch* CreateObject(LPWSTR file, const GUID* clsid){
	// General variables
	int i;

	// Load DLL & check DllGetClassObject
	HINSTANCE hDLL;
	void* Address;
	if (!(hDLL=LoadLibraryW(file))) return 0;
	if (!(Address=GetProcAddress(hDLL,"DllGetClassObject"))) return 0;

	// DllGetClassObject(&clsid,IID_IClassFactory,(LPVOID*)&ppv);
	IClassFactory* ppv=0;
	void *Stack1,*Stack2,*Stack3;
	Stack3=&ppv;
	Stack2=(void*)&IID_IClassFactory;
	Stack1=(void*)clsid;
	_asm push Stack3;
	_asm push Stack2;
	_asm push Stack1;
	_asm call Address;
	_asm mov i,eax;
	if (i!=S_OK || !ppv) return 0;

	// Class factory was succesfully obteined.
	// Lets get the object.

	IDispatch* ppvObject=0;
	if (S_OK!=ppv->QueryInterface(IID_IClassFactory, (void**) &ppv)) return 0;
	ppv->Release();
	if (S_OK!=ppv->CreateInstance(NULL,IID_IUnknown,(void**)&ppvObject)) return 0;
	ppv->Release();
	if (!ppvObject) return 0;
	if (S_OK!=ppvObject->QueryInterface(IID_IDispatch,(void**)&ppvObject)) return 0;
	ppvObject->Release();

	return ppvObject;
}
