#include "common.h"

void CallAPI(COMDATA* data);
char* ModulePath();

char _PathOfMachineDll[MAX_PATH]="";
char* PathOfMachineDll(){
	if (_PathOfMachineDll[0]!=0) return (char*)&_PathOfMachineDll;
	int i,j;
	//Resolve "machie.dll" full path
	char* szModulePath;
	szModulePath=ModulePath();
	for (i=j=0;(_PathOfMachineDll[j]=szModulePath[j])!=0;j++) if (szModulePath[j]=='\\') i=j+1;
	for (j=0;(_PathOfMachineDll[i]="machine.dll"[j++])!=0;i++);
	return (char*)&_PathOfMachineDll;
}

int _PositionOfMachineLanguage=0;
int PositionOfMachineLanguage(char* MACHINEDLL){
	if (_PositionOfMachineLanguage) return _PositionOfMachineLanguage;
	HANDLE fHandle;
	int i,j;
	unsigned char c;
	UINT fSize;
	// Seek the position of machine language
	fHandle=CreateFileA(MACHINEDLL,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (fHandle==INVALID_HANDLE_VALUE) return 0;
	for (i=j=0;ReadFile(fHandle,&c,1,(DWORD*)&fSize,NULL);i++) {
		if (fSize==0) break; // "_asm ret;" not found
		if (c==0xc3) { // "_asm ret;" found.
			if (15<=j) break; // More than 16 times "_asm ret;" found.
			j++;
		} else j=0; // Not "_asm ret;"
	}
	CloseHandle(fHandle);
	if (j<15) return 0;
	_PositionOfMachineLanguage=i-j;
	return _PositionOfMachineLanguage;
}


BOOL LoadMachineDll(COMDATA* data){
	HANDLE fHandle,fHandle2;
	char TMP[MAX_PATH],TMPFILE[MAX_PATH];
	UINT fSize;
	int i,j;
	char c;
	char* mCode=(char*)data->Address;

	// Open the original machine.dll
	char* orgDll=PathOfMachineDll();
	int mlPos=PositionOfMachineLanguage(orgDll);
	if (!mlPos) return FALSE;
	fHandle=CreateFileA(orgDll,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (fHandle==INVALID_HANDLE_VALUE) return FALSE;

	//Make sfcmini directory in the temporary path if required.
	GetTempPathA(MAX_PATH,TMP);
	for (i=0;TMP[i]!=0;i++);
	if (TMP[i-1]!='\\') TMP[i++]='\\';
	for (j=0;(TMP[i]="sfcmini\\"[j++])!=0;i++);
	CreateDirectoryA(TMP,NULL);
	//Delete all dll files in the temporary directory if possible
	for (j=0;(TMP[i+j]="*.dll"[j])!=0;j++);
	HANDLE hSearch;
	WIN32_FIND_DATAA fd;
	hSearch = FindFirstFileA(TMP, &fd );
	if (hSearch!=INVALID_HANDLE_VALUE){
		do {
			for (j=0;(TMP[i+j]=fd.cFileName[j])!=0;j++);
			DeleteFileA(TMP);
		} while (FindNextFileA(hSearch,&fd));
	}
	TMP[i]=0;// Remove the file name

	//Make temporary file (*.dll) and open it for writing.
	TMPFILE[0]=0;
	do {
		if (!GetTempFileNameA(TMP,"machine",0,TMPFILE)) return FALSE;
		DeleteFileA(TMPFILE);
		for (i=0;TMPFILE[i]!=0;i++);
		for (j=0;(TMPFILE[i]=".dll"[j++])!=0;i++);
		fHandle2=CreateFileA(TMPFILE,GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	} while (fHandle2==INVALID_HANDLE_VALUE);
	data->MachineCodeDllPath=CreateAnsiString(TMPFILE,data,MALLOC_PERMANENT);

	// Transfer the code from original dll to destination dll
	// When position reachs the "_asm ret;" position, the machine code is taken.
	for (i=0;ReadFile(fHandle,&c,1,(DWORD*)&fSize,NULL);i++) {
		if (fSize==0) break;
		if (mlPos<=i && i<mlPos+data->Size) c=mCode[i-mlPos];
		WriteFile(fHandle2,&c,1,(DWORD*)&fSize,NULL);
		if (fSize==0) {// Writing error
			CloseHandle(fHandle);
			CloseHandle(fHandle2);
			DeleteFileA(TMPFILE);
			return FALSE;
		}
	}
	CloseHandle(fHandle);
	CloseHandle(fHandle2);

	// Load the library.
	data->MachineCodehDLL=LoadLibraryA(TMPFILE);
	if (data->MachineCodehDLL==0) return TYPE_E_CANTLOADLIBRARY;

	// Set the address of function
	if (data->MachineCodeAddress=GetProcAddress(data->MachineCodehDLL,"MachineLanguage")) return TRUE;
	return FALSE;
}

void* AddByteToCode(int lVal,COMDATA* data,BOOL Relative=FALSE){
	if (Relative) lVal=lVal-((int)data->Address+data->CodePoint+1);
	byte* pByte;
	pByte=(byte*)((int)data->Address+data->CodePoint);
	*pByte=lVal&0xff;
	data->CodePoint++;
	return (void*)pByte;
}

void* AddInt16ToCode(int lVal,COMDATA* data,BOOL Relative=FALSE){
	if (Relative) lVal=lVal-((int)data->Address+data->CodePoint+2);
	short* pShort;
	pShort=(short*)((int)data->Address+data->CodePoint);
	*pShort=lVal&0xffff;
	data->CodePoint++;
	data->CodePoint++;
	return (void*)pShort;
}

void* AddInt32ToCode(int lVal,COMDATA* data,BOOL Relative=FALSE){
	if (Relative) lVal=lVal-((int)data->Address+data->CodePoint+4);
	int* pInt;
	pInt=(int*)((int)data->Address+data->CodePoint);
	*pInt=lVal;
	data->CodePoint=data->CodePoint+4;
	return (void*)pInt;
}

void* AddCode(LPSTR str,COMDATA* data){
	int i;
	byte b1,b2;
	void* ret=(void*)((int)data->Address+data->CodePoint);
	for (i=0;(b1=str[i])!=0;i++) {
		if ('0'<=b1 && b1<='9') b1=b1-'0';
		else if ('A'<=b1 && b1<='F') b1=b1-'A'+10;
		else if ('a'<=b1 && b1<='f') b1=b1-'a'+10;
		else continue;
		if ((b2=str[++i])==0) return 0;
		else if ('0'<=b2 && b2<='9') b2=b2-'0';
		else if ('A'<=b2 && b2<='F') b2=b2-'A'+10;
		else if ('a'<=b2 && b2<='f') b2=b2-'a'+10;
		else return 0;
		AddByteToCode((int)b1*16+(int)b2,data);
	}
	return ret;
}
void ResetCode(COMDATA* data,int bSize=256){
	if (data->Size!=bSize) {
		data->MallocFree(data->Address);
		data->Address=data->Malloc(bSize+1,MALLOC_PERMANENT);//1 byte used for "ret" asm code
	}
	data->Size=bSize;
	data->CodePoint=0;
}

//Method definition
DWORD Machine_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
	if (!data->Address) ResetCode(data);
	for (UINT i = 0; i < cNames; i++)
	{
		rgDispId[i] = DISPID_UNKNOWN;
		if      (!lstrcmpiW(rgszNames[i],L"Reset"))      rgDispId[i]=1;
		else if (!lstrcmpiW(rgszNames[i],L"AddCode"))    rgDispId[i]=2;
		else if (!lstrcmpiW(rgszNames[i],L"AddByte"))    rgDispId[i]=3;
		else if (!lstrcmpiW(rgszNames[i],L"AddInt16"))   rgDispId[i]=4;
		else if (!lstrcmpiW(rgszNames[i],L"AddInt32"))   rgDispId[i]=5;
		else if (!lstrcmpiW(rgszNames[i],L"CallCode"))   rgDispId[i]=6;
		else if (!lstrcmpiW(rgszNames[i],L"AnsiString")) rgDispId[i]=7;
		else if (!lstrcmpiW(rgszNames[i],L"Unicode"))    rgDispId[i]=8;
		else if (!lstrcmpiW(rgszNames[i],L"eax"))        rgDispId[i]=9;
		else if (!lstrcmpiW(rgszNames[i],L"edx"))        rgDispId[i]=10;
		else if (!lstrcmpiW(rgszNames[i],L"Address"))    rgDispId[i]=11;
		else if (!lstrcmpiW(rgszNames[i],L"BufferAddress"))    rgDispId[i]=12;
		else return DISP_E_MEMBERNOTFOUND;
	}
	return S_OK;
}

//Method Invoke
DWORD Machine_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
	int vInt,i,StrLen,ret;
	LPWSTR Unicode;
	LPSTR ANSI;
	LPSTR* String;
	BOOL Relative;
	byte* pByte;
	int cArgs = pDispParams->cArgs;
	VARIANTARG* rgvarg = pDispParams->rgvarg;

	if (wFlags & (DISPATCH_METHOD|DISPATCH_PROPERTYGET) ) 
	switch (dispIdMember)
	{
	case 1: //Reset
		if (cArgs==0) ResetCode(data);
		else if (cArgs==1) {
			if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
			ResetCode(data,vInt);
		}
		return S_OK;
	case 2: //AddCode
		if (cArgs==0) return DISP_E_BADPARAMCOUNT;
		for (i=cArgs-1;0<=i;i--){
			if (!ResolveUnicode(&rgvarg[i],&Unicode)) return DISP_E_BADPARAMCOUNT;
			StrLen=WideCharToMultiByte(CP_ACP,0,Unicode,-1,NULL,0,NULL,NULL)+1;
			ANSI=new char[StrLen+1];
			WideCharToMultiByte(CP_ACP,0,Unicode,-1,ANSI,StrLen,NULL,NULL);
			if (i==cArgs-1) ret=(int)AddCode(ANSI,data);
			else AddCode(ANSI,data);
			delete ANSI;
		}
		if (pVarResult) {
			pVarResult->lVal=ret;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	case 3: //AddByte
	case 4: //AddInt16
	case 5: //AddInt32
		if (cArgs==0) return DISP_E_BADPARAMCOUNT;
		else if (cArgs==2) {
			if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
			Relative=vInt & 1;
			if (!ResolveInt(&rgvarg[1],&vInt)) return DISP_E_BADPARAMCOUNT;
		} else if (cArgs==1) {
			Relative=FALSE;
			if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
		} else return DISP_E_BADPARAMCOUNT;
		switch (dispIdMember){
		case 3:
			ret=(int)AddByteToCode(vInt,data,Relative);
			break;
		case 4:
			ret=(int)AddInt16ToCode(vInt,data,Relative);
			break;
		case 5:
			ret=(int)AddInt32ToCode(vInt,data,Relative);
			break;
		}
		if (pVarResult) {
			pVarResult->lVal=ret;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	case 0:
	case 6: //CallCode
		if (data->Address==0) return DISP_E_BADPARAMCOUNT;
		data->IsUnicode=FALSE;
		pByte=(byte*)((int)data->Address+data->CodePoint);
		*pByte=0xc3;  //                   ret;
		String=new LPSTR[cArgs];
		data->Stack=new int[cArgs];
		data->cArgs=cArgs;
		for (i=cArgs-1;0<=i;i--)
		{
			if (!ResolveInt(&rgvarg[i],&vInt))
			{
				if (!ResolveUnicode(&rgvarg[i],&Unicode)) return DISP_E_BADPARAMCOUNT;
				if (data->IsUnicode) vInt=(int)Unicode;
				else {
					vInt=(int)CreateAnsiString(Unicode,data,MALLOC_TEMPORARY);
					String[i]=(LPSTR)vInt;
				}
			}
			data->Stack[cArgs-1-i]=vInt;
		}
		if (!data->MachineCodeAddress) if (!LoadMachineDll(data)) return TYPE_E_CANTLOADLIBRARY;
		i=(int)data->Address;
		data->Address=data->MachineCodeAddress;
		CallAPI(data);
		data->Address=(void*)i;

		//Resolve Unicode from ANSI string
		if (!data->IsUnicode) for (i=cArgs-1;0<=i;i--)
		{
		  if (rgvarg[i].vt & VT_BYREF) 
			  if (rgvarg[i].pvarVal->vt==VT_BSTR)
			  { //get Unicode
				  StrLen=MultiByteToWideChar(CP_ACP,0,String[i],-1,0,0);
				  MultiByteToWideChar(CP_ACP,0,String[i],-1,rgvarg[i].pvarVal->bstrVal,StrLen);
			  }
		}
		if (pVarResult) {
			pVarResult->lVal=data->eax;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		delete String;
		delete data->Stack;
		//"Free memory" code will be here.
		return S_OK;
	case 7: //AnsiString
	case 8: //Unicode
		return DISP_E_MEMBERNOTFOUND;
	case 9: //eax
		if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
		if (pVarResult) {
			pVarResult->lVal=data->eax;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	case 10: //edx
		if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
		if (pVarResult) {
			pVarResult->lVal=data->edx;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	case 11: //Address
		if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
		if (!data->MachineCodeAddress) if (!LoadMachineDll(data)) return TYPE_E_CANTLOADLIBRARY;
		if (pVarResult) {
			pVarResult->lVal=(int)data->MachineCodeAddress;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	case 12: //BufferAddress
		if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
		if (pVarResult) {
			pVarResult->lVal=(int)data->Address;
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
	default: 
	  return (DWORD)DISPID_UNKNOWN;
	} else if (wFlags & DISPATCH_PROPERTYPUT) return DISP_E_BADPARAMCOUNT;
	else return DISP_E_BADPARAMCOUNT;
}
